/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.AbstractBaseBean;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.types.LoggerType;
import org.apache.syncope.common.util.LoggerEventUtils;

public class AuditLoggerName
extends AbstractBaseBean {
    private static final long serialVersionUID = -647989486671786839L;
    private final AuditElements.EventCategoryType type;
    private final String category;
    private final String subcategory;
    private final String event;
    private final AuditElements.Result result;

    @JsonCreator
    public AuditLoggerName(@JsonProperty(value="type") AuditElements.EventCategoryType type, @JsonProperty(value="category") String category, @JsonProperty(value="subcategory") String subcategory, @JsonProperty(value="event") String event, @JsonProperty(value="result") AuditElements.Result result) throws IllegalArgumentException {
        this.type = type == null ? AuditElements.EventCategoryType.CUSTOM : type;
        this.category = category;
        this.subcategory = subcategory;
        this.event = event;
        this.result = result == null ? AuditElements.Result.SUCCESS : result;
    }

    public AuditElements.EventCategoryType getType() {
        return this.type;
    }

    public String getEvent() {
        return this.event;
    }

    public String getCategory() {
        return this.category;
    }

    public AuditElements.Result getResult() {
        return this.result;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public String toLoggerName() {
        return LoggerType.AUDIT.getPrefix() + '.' + LoggerEventUtils.buildEvent(this.type, this.category, this.subcategory, this.event, this.result);
    }

    public static AuditLoggerName fromLoggerName(String loggerName) throws IllegalArgumentException, ParseException {
        if (StringUtils.isBlank((CharSequence)loggerName)) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        if (!loggerName.startsWith(LoggerType.AUDIT.getPrefix())) {
            throw new ParseException("Audit logger name must start with " + LoggerType.AUDIT.getPrefix(), 0);
        }
        Map.Entry<EventCategoryTO, AuditElements.Result> eventCategory = LoggerEventUtils.parseEventCategory(loggerName.replaceAll(LoggerType.AUDIT.getPrefix() + ".", ""));
        return new AuditLoggerName(eventCategory.getKey().getType(), eventCategory.getKey().getCategory(), eventCategory.getKey().getSubcategory(), eventCategory.getKey().getEvents().isEmpty() ? "" : eventCategory.getKey().getEvents().iterator().next(), eventCategory.getValue());
    }
}

