/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        BeanUtils.copyProperties(source, target, null, (String[])null);
    }

    public static void copyProperties(Object source, Object target, Class<?> editable) throws BeansException {
        BeanUtils.copyProperties(source, target, editable, (String[])null);
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) throws BeansException {
        BeanUtils.copyProperties(source, target, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target, Class<?> editable, String ... ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = org.springframework.beans.BeanUtils.getPropertyDescriptors(actualEditable);
        List<Object> ignoreList = ignoreProperties == null ? Collections.emptyList() : Arrays.asList(ignoreProperties);
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            if (ignoreProperties != null && ignoreList.contains(targetPd.getName()) || (sourcePd = org.springframework.beans.BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null) continue;
            Method writeMethod = targetPd.getWriteMethod();
            try {
                Object value;
                if (writeMethod == null) {
                    value = readMethod.invoke(source, new Object[0]);
                    Method targetReadMethod = targetPd.getReadMethod();
                    if (targetReadMethod == null) continue;
                    if (!Modifier.isPublic(targetReadMethod.getDeclaringClass().getModifiers())) {
                        targetReadMethod.setAccessible(true);
                    }
                    Object destValue = targetReadMethod.invoke(target, new Object[0]);
                    if (value instanceof Collection && destValue instanceof Collection) {
                        ((Collection)destValue).clear();
                        ((Collection)destValue).addAll((Collection)value);
                        continue;
                    }
                    if (!(value instanceof Map) || !(destValue instanceof Map)) continue;
                    ((Map)destValue).clear();
                    ((Map)destValue).putAll((Map)value);
                    continue;
                }
                if (!ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }
}

