/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.to.LoggerTO;
import org.apache.syncope.common.types.AuditLoggerName;
import org.apache.syncope.common.types.LoggerLevel;
import org.apache.syncope.common.wrap.AbstractWrappable;

public final class CollectionWrapper {
    private CollectionWrapper() {
    }

    public static <E, T extends AbstractWrappable<E>> List<T> wrap(E element, Class<T> reference) {
        return Collections.singletonList(AbstractWrappable.getInstance(reference, element));
    }

    public static <E, T extends AbstractWrappable<E>> List<T> wrap(Collection<E> collection, Class<T> reference) {
        ArrayList<T> response = new ArrayList<T>();
        for (E element : collection) {
            response.add(AbstractWrappable.getInstance(reference, element));
        }
        return response;
    }

    public static <T extends AbstractWrappable<String>> List<String> unwrap(Collection<T> collection) {
        ArrayList<String> response = new ArrayList<String>();
        for (AbstractWrappable item : collection) {
            response.add((String)item.getElement());
        }
        return response;
    }

    public static List<AuditLoggerName> wrapLogger(Collection<LoggerTO> logger) {
        ArrayList<AuditLoggerName> respons = new ArrayList<AuditLoggerName>();
        for (LoggerTO l : logger) {
            try {
                respons.add(AuditLoggerName.fromLoggerName(l.getName()));
            }
            catch (Exception exception) {}
        }
        return respons;
    }

    public static List<LoggerTO> unwrapLogger(Collection<AuditLoggerName> auditNames) {
        ArrayList<LoggerTO> respons = new ArrayList<LoggerTO>();
        for (AuditLoggerName l : auditNames) {
            LoggerTO loggerTO = new LoggerTO();
            loggerTO.setName(l.toLoggerName());
            loggerTO.setLevel(LoggerLevel.DEBUG);
            respons.add(loggerTO);
        }
        return respons;
    }
}

