/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console;

import java.io.Serializable;
import javax.servlet.ServletContext;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.SyncopeRequestCycleListener;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.pages.Configuration;
import org.apache.syncope.console.pages.InfoModalPage;
import org.apache.syncope.console.pages.Login;
import org.apache.syncope.console.pages.Logout;
import org.apache.syncope.console.pages.Reports;
import org.apache.syncope.console.pages.Resources;
import org.apache.syncope.console.pages.Roles;
import org.apache.syncope.console.pages.Schema;
import org.apache.syncope.console.pages.Tasks;
import org.apache.syncope.console.pages.Todo;
import org.apache.syncope.console.pages.UserSelfModalPage;
import org.apache.syncope.console.pages.Users;
import org.apache.syncope.console.pages.WelcomePage;
import org.apache.syncope.console.resources.FilesystemResource;
import org.apache.syncope.console.resources.WorkflowDefGETResource;
import org.apache.syncope.console.resources.WorkflowDefPUTResource;
import org.apache.syncope.console.rest.UserSelfRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ContextRelativeResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SyncopeApplication
extends WebApplication
implements IUnauthorizedComponentInstantiationListener,
IRoleCheckingStrategy,
Serializable {
    private static final long serialVersionUID = -2920378752291913495L;
    public static final String IMG_PREFIX = "/img/menu/";
    public static final String IMG_NOTSEL = "notsel/";
    private static final String ACTIVITI_MODELER_CONTEXT = "activiti-modeler";
    private static final int EDIT_PROFILE_WIN_HEIGHT = 550;
    private static final int EDIT_PROFILE_WIN_WIDTH = 800;

    protected void init() {
        super.init();
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this));
        this.getResourceSettings().setThrowExceptionOnMissingResource(true);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)this);
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setCompressWhitespace(true);
        this.getRequestCycleListeners().add((Object)new SyncopeRequestCycleListener());
        final String activitiModelerDirectory = (String)WebApplicationContextUtils.getWebApplicationContext((ServletContext)WebApplication.get().getServletContext()).getBean("activitiModelerDirectory", String.class);
        this.mountResource("/activiti-modeler", new ResourceReference(ACTIVITI_MODELER_CONTEXT){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new FilesystemResource(SyncopeApplication.ACTIVITI_MODELER_CONTEXT, activitiModelerDirectory);
            }
        });
        this.mountResource("/workflowDefGET", new ResourceReference("workflowDefGET"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new WorkflowDefGETResource();
            }
        });
        this.mountResource("/workflowDefPUT", new ResourceReference("workflowDefPUT"){
            private static final long serialVersionUID = -128426276529456602L;

            public IResource getResource() {
                return new WorkflowDefPUTResource();
            }
        });
    }

    public void setupNavigationPanel(WebPage page, XMLRolesReader xmlRolesReader, boolean notsel) {
        final ModalWindow infoModal = new ModalWindow("infoModal");
        page.add(new Component[]{infoModal});
        infoModal.setInitialWidth(350);
        infoModal.setInitialHeight(300);
        infoModal.setCssClassName("w_silver");
        infoModal.setCookieName("infoModal");
        infoModal.setPageCreator(new ModalWindow.PageCreator(){
            private static final long serialVersionUID = -7834632442532690940L;

            public Page createPage() {
                return new InfoModalPage();
            }
        });
        AjaxLink<Page> infoLink = new AjaxLink<Page>("infoLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                infoModal.show(target);
            }
        };
        page.add(new Component[]{infoLink});
        BookmarkablePageLink schemaLink = new BookmarkablePageLink("schema", Schema.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)schemaLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Schema", "list"));
        page.add(new Component[]{schemaLink});
        schemaLink.add(new Component[]{new Image("schemaIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "schema" + ".png"))});
        BookmarkablePageLink usersLink = new BookmarkablePageLink("users", Users.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)usersLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Users", "list"));
        page.add(new Component[]{usersLink});
        usersLink.add(new Component[]{new Image("usersIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "users" + ".png"))});
        BookmarkablePageLink rolesLink = new BookmarkablePageLink("roles", Roles.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)rolesLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Roles", "list"));
        page.add(new Component[]{rolesLink});
        rolesLink.add(new Component[]{new Image("rolesIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "roles" + ".png"))});
        BookmarkablePageLink resourcesLink = new BookmarkablePageLink("resources", Resources.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)resourcesLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Resources", "list"));
        page.add(new Component[]{resourcesLink});
        resourcesLink.add(new Component[]{new Image("resourcesIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "resources" + ".png"))});
        BookmarkablePageLink todoLink = new BookmarkablePageLink("todo", Todo.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)todoLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Approval", "list"));
        page.add(new Component[]{todoLink});
        todoLink.add(new Component[]{new Image("todoIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "todo" + ".png"))});
        BookmarkablePageLink reportLink = new BookmarkablePageLink("reports", Reports.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)reportLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Reports", "list"));
        page.add(new Component[]{reportLink});
        reportLink.add(new Component[]{new Image("reportsIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "reports" + ".png"))});
        BookmarkablePageLink configurationLink = new BookmarkablePageLink("configuration", Configuration.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)configurationLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Configuration", "list"));
        page.add(new Component[]{configurationLink});
        configurationLink.add(new Component[]{new Image("configurationIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "configuration" + ".png"))});
        BookmarkablePageLink taskLink = new BookmarkablePageLink("tasks", Tasks.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)taskLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Tasks", "list"));
        page.add(new Component[]{taskLink});
        taskLink.add(new Component[]{new Image("tasksIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "tasks" + ".png"))});
        page.add(new Component[]{new BookmarkablePageLink("logout", Logout.class)});
    }

    public void setupEditProfileModal(final WebPage page, final UserSelfRestClient userSelfRestClient) {
        final ModalWindow editProfileModalWin = new ModalWindow("editProfileModal");
        editProfileModalWin.setCssClassName("w_silver");
        editProfileModalWin.setInitialHeight(550);
        editProfileModalWin.setInitialWidth(800);
        editProfileModalWin.setCookieName("edit-profile-modal");
        page.add(new Component[]{editProfileModalWin});
        AjaxLink<Page> editProfileLink = new AjaxLink<Page>("editProfileLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                UserTO userTO;
                if (SyncopeSession.get().isAuthenticated()) {
                    try {
                        userTO = userSelfRestClient.read();
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                } else {
                    userTO = new UserTO();
                }
                editProfileModalWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new UserSelfModalPage(page.getPageReference(), editProfileModalWin, userTO);
                    }
                });
                editProfileModalWin.show(target);
            }
        };
        editProfileLink.add(new Component[]{new Label("username", SyncopeSession.get().getUsername())});
        if ("admin".equals(SyncopeSession.get().getUsername())) {
            editProfileLink.setEnabled(false);
        }
        page.add(new Component[]{editProfileLink});
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeSession(request);
    }

    public Class<? extends Page> getHomePage() {
        return SyncopeSession.get().isAuthenticated() ? WelcomePage.class : Login.class;
    }

    public void onUnauthorizedInstantiation(Component component) {
        SyncopeSession.get().invalidate();
        if (component instanceof Page) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
        throw new RestartResponseAtInterceptPageException(Login.class);
    }

    public boolean hasAnyRole(org.apache.wicket.authroles.authorization.strategies.role.Roles roles) {
        return SyncopeSession.get().hasAnyRole(roles);
    }
}

