/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.SyncopeClient;
import org.apache.syncope.client.SyncopeClientFactoryBean;
import org.apache.syncope.common.types.SubjectType;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SyncopeSession
extends WebSession {
    private static final long serialVersionUID = 7743446298924805872L;
    public static final List<Locale> SUPPORTED_LOCALES = Arrays.asList(Locale.ENGLISH, Locale.ITALIAN, new Locale("pt", "BR"));
    private String username;
    private String password;
    private String version;
    private Roles roles = new Roles();
    private final SyncopeClientFactoryBean clientFactory;
    private final String anonymousUser;
    private final String anonymousKey;
    private final Map<Integer, SyncopeClient> clients = Collections.synchronizedMap(new HashMap());

    public static SyncopeSession get() {
        return (SyncopeSession)Session.get();
    }

    public SyncopeSession(Request request) {
        super(request);
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)WebApplication.get().getServletContext());
        this.clientFactory = ((SyncopeClientFactoryBean)ctx.getBean(SyncopeClientFactoryBean.class)).setContentType(SyncopeClientFactoryBean.ContentType.JSON);
        this.anonymousUser = (String)ctx.getBean("anonymousUser", String.class);
        this.anonymousKey = (String)ctx.getBean("anonymousKey", String.class);
    }

    public void resetClients() {
        this.clients.clear();
    }

    public boolean isSelfRegAllowed() {
        SyncopeClient client = this.clients.isEmpty() ? this.clientFactory.createAnonymous() : this.clients.values().iterator().next();
        return client.isSelfRegAllowed();
    }

    public boolean isPwdResetAllowed() {
        SyncopeClient client = this.clients.isEmpty() ? this.clientFactory.createAnonymous() : this.clients.values().iterator().next();
        return client.isPwdResetAllowed();
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        SyncopeClient client = this.clients.isEmpty() ? this.clientFactory.createAnonymous() : this.clients.values().iterator().next();
        return client.isPwdResetRequiringSecurityQuestions();
    }

    public boolean isActivitiEnabledFor(SubjectType type) {
        SyncopeClient client = this.clients.isEmpty() ? this.clientFactory.createAnonymous() : this.clients.values().iterator().next();
        return client.isActivitiEnabledFor(type);
    }

    public <T> T getService(Class<T> service) {
        return this.getService(service, this.username, this.password);
    }

    public <T> T getService(String etag, Class<T> service) {
        T serviceInstance = this.getService(service, this.username, this.password);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false);
        return serviceInstance;
    }

    public <T> void resetClient(Class<T> service) {
        T serviceInstance = this.getService(service, this.username, this.password);
        WebClient.client(serviceInstance).reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(MediaType mediaType, Class<T> serviceClass) {
        Object service;
        SyncopeClientFactoryBean syncopeClientFactoryBean = this.clientFactory;
        synchronized (syncopeClientFactoryBean) {
            SyncopeClientFactoryBean.ContentType preType = this.clientFactory.getContentType();
            this.clientFactory.setContentType(SyncopeClientFactoryBean.ContentType.fromString((String)mediaType.toString()));
            service = this.clientFactory.create(this.username, this.password).getService(serviceClass);
            this.clientFactory.setContentType(preType);
        }
        return (T)service;
    }

    public <T> T getAnonymousService(Class<T> serviceClass) {
        return this.getService(serviceClass, this.anonymousUser, this.anonymousKey);
    }

    public <T> T getService(Class<T> serviceClass, String username, String password) {
        int clientKey = new HashCodeBuilder().append((Object)username).append((Object)password).toHashCode();
        if (!this.clients.containsKey(clientKey)) {
            this.clients.put(clientKey, this.clientFactory.create(username, password));
        }
        return (T)this.clients.get(clientKey).getService(serviceClass);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEntitlements(String[] entitlements) {
        String[] defensiveCopy = (String[])entitlements.clone();
        this.roles = new Roles(defensiveCopy);
    }

    public Roles getEntitlements() {
        return this.roles;
    }

    public boolean isAuthenticated() {
        return this.getUsername() != null;
    }

    public boolean hasAnyRole(Roles roles) {
        return this.roles.hasAnyRole(roles);
    }

    public DateFormat getDateFormat() {
        Locale locale = this.getLocale() == null ? Locale.ENGLISH : this.getLocale();
        return DateFormat.getDateTimeInstance(3, 3, locale);
    }
}

