/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.commons;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.commons.Mode;

public enum AttrLayoutType {
    ADMIN_USER("admin.user.layout", Mode.ADMIN, AttributableType.USER),
    SELF_USER("self.user.layout", Mode.SELF, AttributableType.USER),
    ADMIN_ROLE("admin.role.layout", Mode.ADMIN, AttributableType.ROLE),
    SELF_ROLE("self.role.layout", Mode.SELF, AttributableType.ROLE),
    ADMIN_MEMBERSHIP("admin.membership.layout", Mode.ADMIN, AttributableType.MEMBERSHIP),
    SELF_MEMBERSHIP("self.membership.layout", Mode.SELF, AttributableType.MEMBERSHIP);

    private final String confKey;
    private final Mode mode;
    private final AttributableType attrType;

    private AttrLayoutType(String confKey, Mode mode, AttributableType attrType) {
        this.confKey = confKey;
        this.mode = mode;
        this.attrType = attrType;
    }

    public String getConfKey() {
        return this.confKey;
    }

    public Mode getMode() {
        return this.mode;
    }

    public AttributableType getAttrType() {
        return this.attrType;
    }

    public static List<String> confKeys() {
        ArrayList<String> confKeys = new ArrayList<String>();
        for (AttrLayoutType value : AttrLayoutType.values()) {
            confKeys.add(value.getConfKey());
        }
        return confKeys;
    }

    public static AttrLayoutType valueOf(Mode mode, AttributableType attrType) {
        AttrLayoutType result = null;
        if (mode == Mode.ADMIN) {
            switch (attrType) {
                case USER: {
                    result = ADMIN_USER;
                    break;
                }
                case MEMBERSHIP: {
                    result = ADMIN_MEMBERSHIP;
                    break;
                }
                case ROLE: {
                    result = ADMIN_ROLE;
                    break;
                }
            }
        } else if (mode == Mode.SELF) {
            switch (attrType) {
                case USER: {
                    result = SELF_USER;
                    break;
                }
                case MEMBERSHIP: {
                    result = SELF_MEMBERSHIP;
                    break;
                }
                case ROLE: {
                    result = SELF_ROLE;
                    break;
                }
            }
        }
        return result;
    }
}

