/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.commons;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.cookies.CookieDefaults;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.crypt.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PreferenceManager {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceManager.class);
    private static final String PREFMAN_KEY = "prefMan";
    private static final int ONE_YEAR_TIME = 31536000;
    private static final TypeReference<Map<String, String>> MAP_TYPE_REF = new TypeReference<Map<String, String>>(){};
    private static final List<Integer> PAGINATOR_CHOICES = Arrays.asList(10, 25, 50);
    private final ObjectMapper mapper = new ObjectMapper();
    private final CookieUtils cookieUtils;

    public PreferenceManager() {
        CookieDefaults cookieDefaults = new CookieDefaults();
        cookieDefaults.setMaxAge(31536000);
        this.cookieUtils = new CookieUtils(cookieDefaults);
    }

    public List<Integer> getPaginatorChoices() {
        return PAGINATOR_CHOICES;
    }

    private Map<String, String> getPrefs(String value) {
        HashMap<String, String> prefs;
        try {
            if (!StringUtils.hasText((String)value)) {
                throw new Exception("Invalid cookie value '" + value + "'");
            }
            prefs = (HashMap<String, String>)this.mapper.readValue(value, MAP_TYPE_REF);
        }
        catch (Exception e) {
            LOG.debug("No preferences found", (Throwable)e);
            prefs = new HashMap<String, String>();
        }
        return prefs;
    }

    private String setPrefs(Map<String, String> prefs) throws IOException {
        StringWriter writer = new StringWriter();
        this.mapper.writeValue((Writer)writer, prefs);
        return writer.toString();
    }

    public String get(Request request, String key) {
        String result = null;
        String prefString = this.cookieUtils.load(PREFMAN_KEY);
        if (prefString != null) {
            Map<String, String> prefs = this.getPrefs(new String(Base64.decodeBase64((byte[])prefString.getBytes())));
            result = prefs.get(key);
        }
        return result;
    }

    public Integer getPaginatorRows(Request request, String key) {
        Integer result = this.getPaginatorChoices().get(0);
        String value = this.get(request, key);
        if (value != null) {
            result = NumberUtils.toInt((String)value, (int)10);
        }
        return result;
    }

    public List<String> getList(Request request, String key) {
        ArrayList<String> result = new ArrayList<String>();
        String compound = this.get(request, key);
        if (StringUtils.hasText((String)compound)) {
            String[] items = compound.split(";");
            result.addAll(Arrays.asList(items));
        }
        return result;
    }

    public void set(Request request, Response response, Map<String, List<String>> prefs) {
        String prefString = this.cookieUtils.load(PREFMAN_KEY);
        HashMap<String, String> current = new HashMap<String, String>();
        if (prefString != null) {
            current.putAll(this.getPrefs(new String(Base64.decodeBase64((byte[])prefString.getBytes()))));
        }
        for (Map.Entry<String, List<String>> entry : prefs.entrySet()) {
            current.put(entry.getKey(), StringUtils.collectionToDelimitedString((Collection)entry.getValue(), (String)";"));
        }
        try {
            this.cookieUtils.save(PREFMAN_KEY, new String[]{new String(Base64.encodeBase64((byte[])this.setPrefs(current).getBytes()))});
        }
        catch (IOException e) {
            LOG.error("Could not save {} info: {}", new Object[]{this.getClass().getSimpleName(), current, e});
        }
    }

    public void set(Request request, Response response, String key, String value) {
        String prefString = this.cookieUtils.load(PREFMAN_KEY);
        HashMap<String, String> current = new HashMap<String, String>();
        if (prefString != null) {
            current.putAll(this.getPrefs(new String(Base64.decodeBase64((byte[])prefString.getBytes()))));
        }
        current.put(key, value);
        try {
            this.cookieUtils.save(PREFMAN_KEY, new String[]{new String(Base64.encodeBase64((byte[])this.setPrefs(current).getBytes()))});
        }
        catch (IOException e) {
            LOG.error("Could not save {} info: {}", new Object[]{this.getClass().getSimpleName(), current, e});
        }
    }

    public void setList(Request request, Response response, String key, List<String> values) {
        this.set(request, response, key, StringUtils.collectionToDelimitedString(values, (String)";"));
    }

    public void setList(Request request, Response response, Map<String, List<String>> prefs) {
        this.set(request, response, prefs);
    }
}

