/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.commons;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.types.SchemaType;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.AbstractReadOnlyModel;

public class SortableAttributableProviderComparator
extends SortableDataProviderComparator<AbstractAttributableTO> {
    private static final long serialVersionUID = 1775967163571699258L;
    private static final Set<String> INLINE_PROPS = new HashSet<String>(Arrays.asList("id", "status", "token", "username"));

    public SortableAttributableProviderComparator(SortableDataProvider<AbstractAttributableTO, String> provider) {
        super(provider);
    }

    @Override
    public int compare(AbstractAttributableTO attributable1, AbstractAttributableTO attributable2) {
        if (INLINE_PROPS.contains(this.provider.getSort().getProperty())) {
            return super.compare(attributable1, attributable2);
        }
        return super.compare(new AttrModel(attributable1), new AttrModel(attributable2));
    }

    private class AttrModel
    extends AbstractReadOnlyModel<Comparable> {
        private static final long serialVersionUID = -7856686374020091808L;
        private final Map<String, AttributeTO> attrs;
        private final Map<String, AttributeTO> derAttrs;
        private final Map<String, AttributeTO> virAttrs;

        public AttrModel(AbstractAttributableTO attributableTO) {
            this.attrs = attributableTO.getAttrMap();
            this.derAttrs = attributableTO.getDerAttrMap();
            this.virAttrs = attributableTO.getVirAttrMap();
        }

        public Comparable getObject() {
            List values;
            AttributeTO attr;
            String schema;
            int hashPos = ((String)SortableAttributableProviderComparator.this.provider.getSort().getProperty()).indexOf(35);
            SchemaType schemaType = null;
            if (hashPos == -1) {
                schema = (String)SortableAttributableProviderComparator.this.provider.getSort().getProperty();
            } else {
                String[] splitted = ((String)SortableAttributableProviderComparator.this.provider.getSort().getProperty()).split("#");
                try {
                    schemaType = SchemaType.valueOf((String)splitted[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                schema = ((String)SortableAttributableProviderComparator.this.provider.getSort().getProperty()).substring(hashPos + 1);
            }
            if (schemaType == null) {
                attr = this.attrs.get(schema);
            } else {
                switch (schemaType) {
                    default: {
                        attr = this.attrs.get(schema);
                        break;
                    }
                    case DERIVED: {
                        attr = this.derAttrs.get(schema);
                        break;
                    }
                    case VIRTUAL: {
                        attr = this.virAttrs.get(schema);
                    }
                }
            }
            Comparable result = null;
            List list = values = attr == null ? null : attr.getValues();
            if (values != null && !values.isEmpty()) {
                result = (Comparable)values.iterator().next();
            }
            return result;
        }
    }
}

