/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.commons;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRolesReader {
    private static final Logger LOG = LoggerFactory.getLogger(XMLRolesReader.class);
    private String authorizations;
    private Map<Pair<String, String>, String> authMap;

    public void setAuthorizations(String authorizations) {
        this.authorizations = authorizations;
    }

    private void init() {
        this.authMap = new HashMap<Pair<String, String>, String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.getClass().getResource("/" + this.authorizations).openStream());
            doc.getDocumentElement().normalize();
            Node authNode = null;
            NodeList root = doc.getChildNodes();
            for (int i = 0; i < root.getLength() && authNode == null; ++i) {
                if (!"auth".equals(root.item(i).getNodeName())) continue;
                authNode = root.item(i);
            }
            if (authNode == null) {
                throw new IllegalArgumentException("Could not find root <auth> node");
            }
            NodeList pages = authNode.getChildNodes();
            for (int i = 0; i < pages.getLength(); ++i) {
                if (!"page".equals(pages.item(i).getNodeName())) continue;
                String page = pages.item(i).getAttributes().getNamedItem("id").getTextContent();
                NodeList actions = pages.item(i).getChildNodes();
                for (int j = 0; j < actions.getLength(); ++j) {
                    if (!"action".equals(actions.item(j).getNodeName())) continue;
                    String action = actions.item(j).getAttributes().getNamedItem("id").getTextContent();
                    NodeList entitlements = actions.item(j).getChildNodes();
                    for (int k = 0; k < entitlements.getLength(); ++k) {
                        if (!"entitlement".equals(entitlements.item(k).getNodeName())) continue;
                        String entitlement = entitlements.item(k).getTextContent();
                        this.authMap.put((Pair<String, String>)new ImmutablePair((Object)page, (Object)action), entitlement);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("While initializing parsing of {}", (Object)this.authorizations, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntitlement(String pageId, String actionId) {
        XMLRolesReader xMLRolesReader = this;
        synchronized (xMLRolesReader) {
            if (this.authMap == null) {
                this.init();
            }
        }
        ImmutablePair key = new ImmutablePair((Object)pageId, (Object)actionId);
        return this.authMap.containsKey(key) ? this.authMap.get(key) : "";
    }
}

