/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.init;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MIMETypesInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(MIMETypesInitializer.class);
    private List<String> mimeTypes;

    public void load() {
        HashSet<String> mediaTypes = new HashSet<String>();
        this.mimeTypes = new ArrayList<String>();
        try {
            String mimeTypesFile = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/MIMETypes"));
            for (String fileRow : mimeTypesFile.split("\n")) {
                if (!StringUtils.isNotBlank((CharSequence)fileRow) || fileRow.startsWith("#")) continue;
                mediaTypes.add(fileRow);
            }
            this.mimeTypes.addAll(mediaTypes);
            Collections.sort(this.mimeTypes);
        }
        catch (Exception e) {
            LOG.error("Error reading file MIMETypes from resources", (Throwable)e);
        }
    }

    public List<String> getMimeTypes() {
        LOG.debug("Returning loaded MIME types list");
        return this.mimeTypes;
    }
}

