/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.syncope.console.preview.BinaryPreview;
import org.apache.syncope.console.preview.PreviewerClassScanner;
import org.apache.syncope.console.wicket.markup.html.form.preview.AbstractBinaryPreviewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreviewPanelClassInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewPanelClassInitializer.class);
    @Autowired
    private PreviewerClassScanner classScanner;
    private List<Class<? extends AbstractBinaryPreviewer>> classes;

    public void load() {
        this.classes = new ArrayList<Class<? extends AbstractBinaryPreviewer>>();
        for (Class<? extends AbstractBinaryPreviewer> candidate : this.classScanner.getComponentClasses()) {
            this.classes.add(candidate);
        }
    }

    public List<Class<? extends AbstractBinaryPreviewer>> getClasses() {
        LOG.debug("Returning loaded classes: {}", this.classes);
        return this.classes;
    }

    public Class<? extends AbstractBinaryPreviewer> getClass(String mimeType) {
        LOG.debug("Searching for previewer class for MIME type: {}", (Object)mimeType);
        Class<? extends AbstractBinaryPreviewer> previewer = null;
        for (Class<? extends AbstractBinaryPreviewer> candidate : this.classes) {
            LOG.debug("Evaluating previewer class {} for MIME type {}", (Object)candidate.getName(), (Object)mimeType);
            if (!Arrays.asList(candidate.getAnnotation(BinaryPreview.class).mimeTypes()).contains(mimeType)) continue;
            LOG.debug("Found existing previewer for MIME type {}: {}", (Object)mimeType, (Object)candidate.getName());
            previewer = candidate;
        }
        return previewer;
    }
}

