/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.markup.html;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.syncope.console.commons.SelectChoiceRenderer;
import org.apache.syncope.console.commons.SelectOption;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class CrontabContainer
extends WebMarkupContainer {
    private static final long serialVersionUID = 7879593326085337650L;
    private final TextField seconds;
    private final TextField minutes;
    private final TextField hours;
    private final TextField daysOfMonth;
    private final TextField months;
    private final TextField daysOfWeek;

    public CrontabContainer(String id, final PropertyModel<String> cronExpressionModel, String cronExpression) {
        super(id);
        this.setOutputMarkupId(true);
        final SelectOption[] CRON_TEMPLATES = new SelectOption[]{new SelectOption(this.getString("selOpt1"), "UNSCHEDULE"), new SelectOption(this.getString("selOpt2"), "0 0/5 * * * ?"), new SelectOption(this.getString("selOpt3"), "0 0 12 * * ?"), new SelectOption(this.getString("selOpt4"), "0 0 0 1 * ?"), new SelectOption(this.getString("selOpt5"), "0 0 0 L * ?"), new SelectOption(this.getString("selOpt6"), "0 0 0 ? * 2")};
        DropDownChoice<SelectOption> cronTemplateChooser = new DropDownChoice<SelectOption>("cronTemplateChooser"){
            private static final long serialVersionUID = -5843424545478691442L;

            protected CharSequence getDefaultChoice(String selected) {
                return "<option value=\"\">" + this.getString("chooseForTemplate") + "</option>";
            }
        };
        cronTemplateChooser.setModel((IModel)new IModel<SelectOption>(){
            private static final long serialVersionUID = 6762568283146531315L;

            public SelectOption getObject() {
                SelectOption result = null;
                for (SelectOption so : CRON_TEMPLATES) {
                    if (!so.getKeyValue().equals(cronExpressionModel.getObject())) continue;
                    result = so;
                }
                return result;
            }

            public void setObject(SelectOption object) {
                cronExpressionModel.setObject(object == null || object.equals(CRON_TEMPLATES[0]) ? null : object.toString());
            }

            public void detach() {
            }
        });
        cronTemplateChooser.setChoices(Arrays.asList(CRON_TEMPLATES));
        cronTemplateChooser.setChoiceRenderer(new SelectChoiceRenderer());
        this.add(new Component[]{cronTemplateChooser});
        this.seconds = new TextField("seconds", (IModel)new Model((Serializable)((Object)this.getCronField(cronExpression, 0))));
        this.add(new Component[]{this.seconds});
        this.minutes = new TextField("minutes", (IModel)new Model((Serializable)((Object)this.getCronField(cronExpression, 1))));
        this.add(new Component[]{this.minutes});
        this.hours = new TextField("hours", (IModel)new Model((Serializable)((Object)this.getCronField(cronExpression, 2))));
        this.add(new Component[]{this.hours});
        this.daysOfMonth = new TextField("daysOfMonth", (IModel)new Model((Serializable)((Object)this.getCronField(cronExpression, 3))));
        this.add(new Component[]{this.daysOfMonth});
        this.months = new TextField("months", (IModel)new Model((Serializable)((Object)this.getCronField(cronExpression, 4))));
        this.add(new Component[]{this.months});
        this.daysOfWeek = new TextField("daysOfWeek", (IModel)new Model((Serializable)((Object)this.getCronField(cronExpression, 5))));
        this.add(new Component[]{this.daysOfWeek});
        cronTemplateChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange", (DropDownChoice)cronTemplateChooser){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ DropDownChoice val$cronTemplateChooser;
            {
                this.val$cronTemplateChooser = dropDownChoice;
                super(x0);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                CrontabContainer.this.seconds.setModelObject((Object)CrontabContainer.this.getCronField((FormComponent)this.val$cronTemplateChooser, 0));
                CrontabContainer.this.minutes.setModelObject((Object)CrontabContainer.this.getCronField((FormComponent)this.val$cronTemplateChooser, 1));
                CrontabContainer.this.hours.setModelObject((Object)CrontabContainer.this.getCronField((FormComponent)this.val$cronTemplateChooser, 2));
                CrontabContainer.this.daysOfMonth.setModelObject((Object)CrontabContainer.this.getCronField((FormComponent)this.val$cronTemplateChooser, 3));
                CrontabContainer.this.months.setModelObject((Object)CrontabContainer.this.getCronField((FormComponent)this.val$cronTemplateChooser, 4));
                CrontabContainer.this.daysOfWeek.setModelObject((Object)CrontabContainer.this.getCronField((FormComponent)this.val$cronTemplateChooser, 5));
                target.add(new Component[]{CrontabContainer.this});
            }
        }});
    }

    private String getCronField(FormComponent formComponent, int field) {
        String cronField = null;
        if (formComponent != null) {
            cronField = this.getCronField(formComponent.getInput(), field);
        }
        return cronField;
    }

    private String getCronField(String cron, int field) {
        String cronField = null;
        if (cron != null && !cron.isEmpty() && !"UNSCHEDULE".equals(cron)) {
            cronField = cron.split(" ")[field].trim();
        }
        return cronField;
    }

    public String getCronExpression() {
        String cronExpression = null;
        if (this.seconds != null && this.seconds.getInput() != null && this.minutes != null && this.minutes.getInput() != null && this.hours != null && this.hours.getInput() != null && this.daysOfMonth != null && this.daysOfMonth.getInput() != null && this.months != null && this.months.getInput() != null && this.daysOfWeek != null && this.daysOfWeek.getInput() != null) {
            cronExpression = this.seconds.getInput().trim() + " " + this.minutes.getInput().trim() + " " + this.hours.getInput().trim() + " " + this.daysOfMonth.getInput().trim() + " " + this.months.getInput().trim() + " " + this.daysOfWeek.getInput().trim();
        }
        return cronExpression;
    }
}

