/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.markup.html.list;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.console.markup.html.list.AltListView;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class ConnConfPropertyListView
extends AltListView<ConnConfProperty> {
    private static final long serialVersionUID = -5239334900329150316L;
    private static final Logger LOG = LoggerFactory.getLogger(ConnConfPropertyListView.class);
    private final boolean withOverridable;
    private final Set<ConnConfProperty> configuration;

    public ConnConfPropertyListView(String id, IModel<? extends List<? extends ConnConfProperty>> model, boolean withOverridable, Set<ConnConfProperty> configuration) {
        super(id, model);
        this.configuration = configuration;
        this.withOverridable = withOverridable;
    }

    protected void populateItem(ListItem<ConnConfProperty> item) {
        FieldPanel field;
        ConnConfProperty property = (ConnConfProperty)item.getModelObject();
        Label label = new Label("connPropAttrSchema", StringUtils.isBlank((CharSequence)property.getSchema().getDisplayName()) ? property.getSchema().getName() : property.getSchema().getDisplayName());
        item.add(new Component[]{label});
        boolean required = false;
        boolean isArray = false;
        if (property.getSchema().isConfidential() || "org.identityconnectors.common.security.GuardedString".equalsIgnoreCase(property.getSchema().getType()) || "org.identityconnectors.common.security.GuardedByteArray".equalsIgnoreCase(property.getSchema().getType())) {
            field = new AjaxPasswordFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<String>)new Model());
            ((PasswordTextField)field.getField()).setResetPassword(false);
            required = property.getSchema().isRequired();
        } else {
            Class propertySchemaClass;
            try {
                propertySchemaClass = ClassUtils.forName((String)property.getSchema().getType(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                if (ClassUtils.isPrimitiveOrWrapper((Class)propertySchemaClass)) {
                    propertySchemaClass = org.apache.commons.lang3.ClassUtils.primitiveToWrapper(propertySchemaClass);
                }
            }
            catch (Exception e) {
                LOG.error("Error parsing attribute type", (Throwable)e);
                propertySchemaClass = String.class;
            }
            if (ClassUtils.isAssignable(Number.class, propertySchemaClass)) {
                Class numberClass = propertySchemaClass;
                field = new SpinnerFieldPanel<Object>("panel", label.getDefaultModelObjectAsString(), numberClass, (IModel<Object>)new Model(), null, null);
                required = property.getSchema().isRequired();
            } else if (ClassUtils.isAssignable(Boolean.class, (Class)propertySchemaClass)) {
                field = new AjaxCheckBoxPanel("panel", label.getDefaultModelObjectAsString(), (IModel<Boolean>)new Model());
            } else {
                field = new AjaxTextFieldPanel("panel", label.getDefaultModelObjectAsString(), (IModel<String>)new Model());
                required = property.getSchema().isRequired();
            }
            if (propertySchemaClass.isArray()) {
                isArray = true;
            }
        }
        field.setTitle(property.getSchema().getHelpMessage());
        if (required) {
            ((FieldPanel)field).addRequiredLabel();
        }
        if (isArray) {
            if (property.getValues().isEmpty()) {
                property.getValues().add(null);
            }
            MultiFieldPanel<String> multiFieldPanel = new MultiFieldPanel<String>("panel", (IModel<List<String>>)new PropertyModel((Object)property, "values"), field);
            item.add(new Component[]{multiFieldPanel});
        } else {
            this.setNewFieldModel(field, property.getValues());
            item.add(new Component[]{field});
        }
        if (this.withOverridable) {
            item.add(new Component[]{new AjaxCheckBoxPanel("connPropAttrOverridable", "connPropAttrOverridable", (IModel<Boolean>)new PropertyModel((Object)property, "overridable"))});
        }
        this.configuration.add(property);
    }

    private void setNewFieldModel(FieldPanel field, List<Object> values) {
        field.setNewModel(values);
    }
}

