/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.console.commons.DateFormatROModel;
import org.apache.syncope.console.markup.html.CrontabContainer;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.TaskModalPage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.springframework.util.StringUtils;

public abstract class AbstractSchedTaskModalPage
extends TaskModalPage {
    private static final long serialVersionUID = 2892005971093059242L;
    protected final AjaxTextFieldPanel description;
    protected CrontabContainer crontab;

    public AbstractSchedTaskModalPage(final ModalWindow window, SchedTaskTO taskTO, final PageReference pageRef) {
        super((AbstractTaskTO)taskTO);
        this.crontab = new CrontabContainer("crontab", (PropertyModel<String>)new PropertyModel((Object)taskTO, "cronExpression"), taskTO.getCronExpression());
        this.form.add(new Component[]{this.crontab});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel<String>)new PropertyModel((Object)taskTO, "name"));
        name.setEnabled(true);
        this.profile.add(new Component[]{name});
        this.description = new AjaxTextFieldPanel("description", "description", (IModel<String>)new PropertyModel((Object)taskTO, "description"));
        this.description.setEnabled(true);
        this.profile.add(new Component[]{this.description});
        AjaxTextFieldPanel lastExec = new AjaxTextFieldPanel("lastExec", this.getString("lastExec"), new DateFormatROModel(new PropertyModel((Object)taskTO, "lastExec")));
        lastExec.setEnabled(false);
        this.profile.add(new Component[]{lastExec});
        AjaxTextFieldPanel nextExec = new AjaxTextFieldPanel("nextExec", this.getString("nextExec"), new DateFormatROModel(new PropertyModel((Object)taskTO, "nextExec")));
        nextExec.setEnabled(false);
        this.profile.add(new Component[]{nextExec});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("apply")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SchedTaskTO taskTO;
                taskTO.setCronExpression(StringUtils.hasText((String)(taskTO = (SchedTaskTO)form.getModelObject()).getCronExpression()) ? AbstractSchedTaskModalPage.this.crontab.getCronExpression() : null);
                try {
                    AbstractSchedTaskModalPage.this.submitAction(taskTO);
                    ((BasePage)pageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientException e) {
                    AbstractBasePage.LOG.error("While creating or updating task", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    AbstractSchedTaskModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                AbstractSchedTaskModalPage.this.feedbackPanel.refresh(target);
            }
        };
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        if (taskTO.getId() > 0L) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Tasks", "update"));
        } else {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Tasks", "create"));
        }
        this.form.add(new Component[]{submit});
        this.form.add(new Component[]{cancel});
    }

    protected abstract void submitAction(SchedTaskTO var1);
}

