/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.to.AbstractSyncTaskTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.common.types.MatchingRule;
import org.apache.syncope.common.types.UnmatchingRule;
import org.apache.syncope.console.commons.SelectChoiceRenderer;
import org.apache.syncope.console.pages.AbstractSchedTaskModalPage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public abstract class AbstractSyncTaskModalPage
extends AbstractSchedTaskModalPage {
    private static final long serialVersionUID = 2148403203517274669L;
    protected AjaxDropDownChoicePanel<MatchingRule> matchingRule;
    protected AjaxDropDownChoicePanel<UnmatchingRule> unmatchingRule;
    final IModel<List<String>> allResources = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            ArrayList<String> resourceNames = new ArrayList<String>();
            for (ResourceTO resourceTO : AbstractSyncTaskModalPage.this.resourceRestClient.getAll()) {
                resourceNames.add(resourceTO.getName());
            }
            Collections.sort(resourceNames);
            return resourceNames;
        }
    };
    final IModel<List<String>> syncActionsClasses = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157438L;

        protected List<String> load() {
            return AbstractSyncTaskModalPage.this.getSyncActions();
        }
    };

    protected abstract List<String> getSyncActions();

    public AbstractSyncTaskModalPage(ModalWindow window, final AbstractSyncTaskTO taskTO, PageReference pageRef) {
        super(window, (SchedTaskTO)taskTO, pageRef);
        AjaxDropDownChoicePanel resource = new AjaxDropDownChoicePanel("resource", this.getString("resourceName"), new PropertyModel((Object)taskTO, "resource"));
        resource.setChoices((List)this.allResources.getObject());
        resource.setChoiceRenderer(new SelectChoiceRenderer());
        resource.addRequiredLabel();
        resource.setEnabled(taskTO.getId() == 0L);
        resource.setStyleSheet("ui-widget-content ui-corner-all long_dynamicsize");
        this.profile.add(new Component[]{resource});
        final WebMarkupContainer syncActionsClassNames = new WebMarkupContainer("syncActionsClassNames");
        syncActionsClassNames.setOutputMarkupId(true);
        this.profile.add(new Component[]{syncActionsClassNames});
        IndicatingAjaxLink<Void> first = new IndicatingAjaxLink<Void>("first"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                taskTO.getActionsClassNames().add("");
                this.setVisible(false);
                target.add(new Component[]{syncActionsClassNames});
            }
        };
        first.setOutputMarkupPlaceholderTag(true);
        first.setVisible(taskTO.getActionsClassNames().isEmpty());
        syncActionsClassNames.add(new Component[]{first});
        ListView<String> actionsClasses = new ListView<String>("actionsClasses", (IModel)new PropertyModel((Object)taskTO, "actionsClassNames"), (AjaxLink)first){
            private static final long serialVersionUID = 9101744072914090143L;
            final /* synthetic */ AjaxLink val$first;
            {
                this.val$first = ajaxLink;
                super(x0, x1);
            }

            protected void populateItem(final ListItem<String> item) {
                final String className = (String)item.getModelObject();
                final DropDownChoice actionsClass = new DropDownChoice("actionsClass", (IModel)new Model((Serializable)((Object)className)), (List)AbstractSyncTaskModalPage.this.syncActionsClasses.getObject());
                actionsClass.setNullValid(true);
                actionsClass.setRequired(true);
                actionsClass.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        taskTO.getActionsClassNames().set(item.getIndex(), actionsClass.getModelObject());
                        target.add(new Component[]{syncActionsClassNames});
                    }
                }});
                actionsClass.setRequired(true);
                actionsClass.setOutputMarkupId(true);
                actionsClass.setRequired(true);
                item.add(new Component[]{actionsClass});
                IndicatingAjaxLink<Void> minus = new IndicatingAjaxLink<Void>("drop"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        taskTO.getActionsClassNames().remove(className);
                        val$first.setVisible(taskTO.getActionsClassNames().isEmpty());
                        target.add(new Component[]{syncActionsClassNames});
                    }
                };
                item.add(new Component[]{minus});
                IndicatingAjaxLink<Void> plus = new IndicatingAjaxLink<Void>("add"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        taskTO.getActionsClassNames().add("");
                        target.add(new Component[]{syncActionsClassNames});
                    }
                };
                plus.setOutputMarkupPlaceholderTag(true);
                plus.setVisible(item.getIndex() == taskTO.getActionsClassNames().size() - 1);
                item.add(new Component[]{plus});
            }
        };
        syncActionsClassNames.add(new Component[]{actionsClasses});
        syncActionsClassNames.setEnabled(!((List)this.syncActionsClasses.getObject()).isEmpty());
        AjaxCheckBoxPanel creates = new AjaxCheckBoxPanel("performCreate", this.getString("creates"), (IModel<Boolean>)new PropertyModel((Object)taskTO, "performCreate"));
        this.profile.add(new Component[]{creates});
        AjaxCheckBoxPanel updates = new AjaxCheckBoxPanel("performUpdate", this.getString("updates"), (IModel<Boolean>)new PropertyModel((Object)taskTO, "performUpdate"));
        this.profile.add(new Component[]{updates});
        AjaxCheckBoxPanel deletes = new AjaxCheckBoxPanel("performDelete", this.getString("updates"), (IModel<Boolean>)new PropertyModel((Object)taskTO, "performDelete"));
        this.profile.add(new Component[]{deletes});
        AjaxCheckBoxPanel syncStatus = new AjaxCheckBoxPanel("syncStatus", this.getString("syncStatus"), (IModel<Boolean>)new PropertyModel((Object)taskTO, "syncStatus"));
        this.profile.add(new Component[]{syncStatus});
        this.matchingRule = new AjaxDropDownChoicePanel("matchingRule", "matchingRule", new PropertyModel((Object)taskTO, "matchingRule"));
        this.matchingRule.setChoices(Arrays.asList(MatchingRule.values()));
        ((DropDownChoice)this.matchingRule.getField()).setNullValid(false);
        this.unmatchingRule = new AjaxDropDownChoicePanel("unmatchingRule", "unmatchingRule", new PropertyModel((Object)taskTO, "unmatchingRule"));
        this.unmatchingRule.setChoices(Arrays.asList(UnmatchingRule.values()));
        ((DropDownChoice)this.unmatchingRule.getField()).setNullValid(false);
    }
}

