/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.WorkflowFormPropertyTO;
import org.apache.syncope.common.to.WorkflowFormTO;
import org.apache.syncope.console.commons.MapChoiceRenderer;
import org.apache.syncope.console.markup.html.list.AltListView;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.Todo;
import org.apache.syncope.console.pages.ViewUserModalPage;
import org.apache.syncope.console.rest.ApprovalRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ApprovalModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -8847854414429745216L;
    private static final int USER_WIN_HEIGHT = 550;
    private static final int USER_WIN_WIDTH = 800;
    @SpringBean
    private ApprovalRestClient restClient;
    private final ModalWindow editUserWin;

    public ApprovalModalPage(final PageReference pageRef, final ModalWindow window, final WorkflowFormTO formTO) {
        LoadableDetachableModel<List<WorkflowFormPropertyTO>> formProps = new LoadableDetachableModel<List<WorkflowFormPropertyTO>>(){
            private static final long serialVersionUID = 3169142472626817508L;

            protected List<WorkflowFormPropertyTO> load() {
                return formTO.getProperties();
            }
        };
        final AltListView<WorkflowFormPropertyTO> propView = new AltListView<WorkflowFormPropertyTO>("propView", (IModel)formProps){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<WorkflowFormPropertyTO> item) {
                FieldPanel field;
                final WorkflowFormPropertyTO prop = (WorkflowFormPropertyTO)item.getModelObject();
                Label label = new Label("key", prop.getName() == null ? prop.getId() : prop.getName());
                item.add(new Component[]{label});
                switch (prop.getType()) {
                    case Boolean: {
                        field = new AjaxDropDownChoicePanel<String>("value", label.getDefaultModelObjectAsString(), (IModel<String>)new Model((Serializable)Boolean.valueOf(prop.getValue()))).setChoices(Arrays.asList("Yes", "No"));
                        break;
                    }
                    case Date: {
                        SimpleDateFormat df = StringUtils.isNotBlank((CharSequence)prop.getDatePattern()) ? new SimpleDateFormat(prop.getDatePattern()) : new SimpleDateFormat();
                        Date parsedDate = null;
                        if (StringUtils.isNotBlank((CharSequence)prop.getValue())) {
                            try {
                                parsedDate = df.parse(prop.getValue());
                            }
                            catch (ParseException e) {
                                AbstractBasePage.LOG.error("Unparsable date: {}", (Object)prop.getValue(), (Object)e);
                            }
                        }
                        field = new DateTimeFieldPanel("value", label.getDefaultModelObjectAsString(), (IModel<Date>)new Model((Serializable)parsedDate), df.toLocalizedPattern());
                        break;
                    }
                    case Enum: {
                        MapChoiceRenderer enumCR = new MapChoiceRenderer(prop.getEnumValues());
                        field = new AjaxDropDownChoicePanel("value", label.getDefaultModelObjectAsString(), new Model((Serializable)((Object)prop.getValue()))).setChoiceRenderer(enumCR).setChoices(new Model(){
                            private static final long serialVersionUID = -858521070366432018L;

                            public Serializable getObject() {
                                return new ArrayList(prop.getEnumValues().keySet());
                            }
                        });
                        break;
                    }
                    case Long: {
                        field = new SpinnerFieldPanel<Object>("value", label.getDefaultModelObjectAsString(), (Class<Object>)Long.class, (IModel<Object>)new Model((Serializable)Long.valueOf(NumberUtils.toLong((String)prop.getValue()))), null, null);
                        break;
                    }
                    default: {
                        field = new AjaxTextFieldPanel("value", "..", (IModel<String>)new Model((Serializable)((Object)prop.getValue())));
                    }
                }
                field.setReadOnly(!prop.isWritable());
                if (prop.isRequired()) {
                    field.addRequiredLabel();
                }
                item.add(new Component[]{field});
            }
        };
        IndicatingAjaxButton userDetails = new IndicatingAjaxButton("userDetails", (IModel)new Model((Serializable)((Object)this.getString("userDetails")))){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ApprovalModalPage.this.editUserWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new ViewUserModalPage(ApprovalModalPage.this.getPageReference(), ApprovalModalPage.this.editUserWin, ApprovalModalPage.this.userRestClient.read(formTO.getUserId())){
                            private static final long serialVersionUID = -2819994749866481607L;

                            protected void closeAction(AjaxRequestTarget target, Form form) {
                                this.setResponsePage((Page)ApprovalModalPage.this);
                            }
                        };
                    }
                });
                ApprovalModalPage.this.editUserWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)userDetails, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Users", "read"));
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                Map props = formTO.getPropertyMap();
                block5: for (int i = 0; i < propView.size(); ++i) {
                    ListItem item = (ListItem)propView.get(i);
                    String input = ((FieldPanel)item.get("value")).getField().getInput();
                    if (!props.containsKey(((WorkflowFormPropertyTO)item.getModelObject()).getId())) {
                        props.put(((WorkflowFormPropertyTO)item.getModelObject()).getId(), new WorkflowFormPropertyTO());
                    }
                    if (!((WorkflowFormPropertyTO)item.getModelObject()).isWritable()) continue;
                    switch (((WorkflowFormPropertyTO)item.getModelObject()).getType()) {
                        case Boolean: {
                            ((WorkflowFormPropertyTO)props.get(((WorkflowFormPropertyTO)item.getModelObject()).getId())).setValue(String.valueOf("0".equals(input)));
                            continue block5;
                        }
                        default: {
                            ((WorkflowFormPropertyTO)props.get(((WorkflowFormPropertyTO)item.getModelObject()).getId())).setValue(input);
                        }
                    }
                }
                formTO.setProperties(props.values());
                try {
                    ApprovalModalPage.this.restClient.submitForm(formTO);
                    ((Todo)pageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    AbstractBasePage.LOG.error("While submitting form {}", (Object)formTO, (Object)e);
                    ApprovalModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ApprovalModalPage.this.feedbackPanel.refresh(target);
            }
        };
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
            }
        };
        cancel.setDefaultFormProcessing(false);
        Form form = new Form("form");
        form.add(new Component[]{propView});
        form.add(new Component[]{userDetails});
        form.add(new Component[]{submit});
        form.add(new Component[]{cancel});
        MetaDataRoleAuthorizationStrategy.authorize((Component)form, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Approval", "submit"));
        this.editUserWin = new ModalWindow("editUserWin");
        this.editUserWin.setCssClassName("w_silver");
        this.editUserWin.setInitialHeight(550);
        this.editUserWin.setInitialWidth(800);
        this.editUserWin.setCookieName("edit-user-modal");
        this.add(new Component[]{this.editUserWin});
        this.add(new Component[]{form});
    }
}

