/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.BulkActionResultModalPage;
import org.apache.syncope.console.rest.BaseRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.springframework.beans.BeanUtils;

public class BulkActionModalPage<T, S>
extends BaseModalPage {
    private static final long serialVersionUID = 4114026480146090962L;

    public BulkActionModalPage(final ModalWindow window, final Collection<T> items, final List<IColumn<T, S>> columns, Collection<ActionLink.ActionType> actions, final BaseRestClient bulkActionExecutor, final String idFieldName, String pageId) {
        SortableDataProvider dataProvider = new SortableDataProvider<T, S>(){
            private static final long serialVersionUID = 5291903859908641954L;

            public Iterator<? extends T> iterator(long first, long count) {
                return items.iterator();
            }

            public long size() {
                return items.size();
            }

            public IModel<T> model(T object) {
                return new CompoundPropertyModel(object);
            }
        };
        this.add(new Component[]{new AjaxFallbackDefaultDataTable("selectedObjects", new ArrayList<IColumn<T, S>>(columns.subList(1, columns.size() - 1)), (ISortableDataProvider)dataProvider, Integer.MAX_VALUE).setVisible(items != null && !items.isEmpty())});
        ActionLinksPanel actionPanel = new ActionLinksPanel("actions", (IModel<?>)new Model(), this.getPageReference());
        this.add(new Component[]{actionPanel});
        for (ActionLink.ActionType action : actions) {
            final BulkAction bulkAction = new BulkAction();
            for (T item : items) {
                try {
                    bulkAction.getTargets().add(this.getTargetId(item, idFieldName).toString());
                }
                catch (Exception e) {
                    LOG.error("Error retrieving item id {}", (Object)idFieldName, (Object)e);
                }
            }
            switch (action) {
                case DELETE: {
                    bulkAction.setOperation(BulkAction.Type.DELETE);
                    break;
                }
                case SUSPEND: {
                    bulkAction.setOperation(BulkAction.Type.SUSPEND);
                    break;
                }
                case REACTIVATE: {
                    bulkAction.setOperation(BulkAction.Type.REACTIVATE);
                    break;
                }
                case EXECUTE: {
                    bulkAction.setOperation(BulkAction.Type.EXECUTE);
                    break;
                }
                case DRYRUN: {
                    bulkAction.setOperation(BulkAction.Type.DRYRUN);
                    break;
                }
                default: {
                    LOG.error("Bulk action type not supported");
                }
            }
            actionPanel.add(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    try {
                        BulkActionResult res = (BulkActionResult)bulkActionExecutor.getClass().getMethod("bulkAction", BulkAction.class).invoke((Object)bulkActionExecutor, bulkAction);
                        BulkActionModalPage.this.setResponsePage((Page)new BulkActionResultModalPage(window, items, columns, res, idFieldName));
                    }
                    catch (Exception e) {
                        BulkActionModalPage.this.error((Serializable)((Object)(BulkActionModalPage.this.getString("error") + ": Operation " + bulkAction.getOperation() + " not supported")));
                        BulkActionModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }, action, pageId, !items.isEmpty());
        }
        Form form = new Form("form");
        this.add(new Component[]{form});
        ClearIndicatingAjaxButton cancel = new ClearIndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel"), this.getPageReference()){
            private static final long serialVersionUID = -958724007591692537L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    private Object getTargetId(Object target, String idFieldName) throws IllegalAccessException, InvocationTargetException {
        return BeanUtils.getPropertyDescriptor(target.getClass(), (String)idFieldName).getReadMethod().invoke(target, new Object[0]);
    }
}

