/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.Collections;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConfTO;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.panels.AttributesPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class ConfModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 3524777398688399977L;

    public ConfModalPage(final PageReference pageRef, final ModalWindow window, WebMarkupContainer parameters) {
        MetaDataRoleAuthorizationStrategy.authorize((Component)parameters, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "list"));
        ConfTO conf = this.confRestClient.list();
        Form form = new Form("confForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)conf));
        form.add(new Component[]{new AttributesPanel("paramAttrs", conf, form, Mode.ADMIN)});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ConfTO updatedConf = (ConfTO)form.getModelObject();
                try {
                    for (AttributeTO attr : updatedConf.getAttrs()) {
                        attr.getValues().removeAll(Collections.singleton(null));
                        if (attr.getValues().isEmpty() || attr.getValues().equals(Collections.singletonList(""))) {
                            ConfModalPage.this.confRestClient.delete(attr.getSchema());
                            continue;
                        }
                        ConfModalPage.this.confRestClient.set(attr);
                    }
                    if (pageRef.getPage() instanceof BasePage) {
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                    }
                    window.close(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    ConfModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ConfModalPage.this.feedbackPanel.refresh(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "set"));
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "delete"));
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

