/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.LoggerTO;
import org.apache.syncope.common.to.NotificationTO;
import org.apache.syncope.common.to.SecurityQuestionTO;
import org.apache.syncope.common.types.LoggerLevel;
import org.apache.syncope.common.types.PolicyType;
import org.apache.syncope.console.commons.AttrLayoutType;
import org.apache.syncope.console.commons.HttpResourceStream;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.ActivitiModelerPopupPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.ConfModalPage;
import org.apache.syncope.console.pages.NotificationModalPage;
import org.apache.syncope.console.pages.SecurityQuestionModalPage;
import org.apache.syncope.console.pages.XMLEditorPopupPage;
import org.apache.syncope.console.pages.panels.LayoutsPanel;
import org.apache.syncope.console.pages.panels.PoliciesPanel;
import org.apache.syncope.console.rest.LoggerRestClient;
import org.apache.syncope.console.rest.NotificationRestClient;
import org.apache.syncope.console.rest.SecurityQuestionRestClient;
import org.apache.syncope.console.rest.WorkflowRestClient;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.CollectionPropertyColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.syncope.console.wicket.markup.html.link.VeilPopupSettings;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PropertyListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.resource.IResourceStream;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class Configuration
extends BasePage {
    private static final long serialVersionUID = -2838270869037702214L;
    private static final int SYNCOPECONF_WIN_HEIGHT = 300;
    private static final int SYNCOPECONF_WIN_WIDTH = 900;
    private static final int NOTIFICATION_WIN_HEIGHT = 500;
    private static final int NOTIFICATION_WIN_WIDTH = 1100;
    private static final int SECURITY_QUESTION_WIN_HEIGHT = 300;
    private static final int SECURITY_QUESTION_WIN_WIDTH = 900;
    @SpringBean
    private LoggerRestClient loggerRestClient;
    @SpringBean
    private NotificationRestClient notificationRestClient;
    @SpringBean
    private SecurityQuestionRestClient securityQuestionRestClient;
    @SpringBean
    private WorkflowRestClient wfRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow syncopeConfWin;
    private final ModalWindow createNotificationWin;
    private final ModalWindow editNotificationWin;
    private final ModalWindow createSecurityQuestionWin;
    private final ModalWindow editSecurityQuestionWin;
    private WebMarkupContainer notificationContainer;
    private WebMarkupContainer securityQuestionContainer;
    private int notificationPaginatorRows;

    public Configuration() {
        Component[] componentArray = new Component[1];
        this.syncopeConfWin = new ModalWindow("syncopeConfWin");
        componentArray[0] = this.syncopeConfWin;
        this.add(componentArray);
        this.syncopeConfWin.setCssClassName("w_silver");
        this.syncopeConfWin.setInitialHeight(300);
        this.syncopeConfWin.setInitialWidth(900);
        this.syncopeConfWin.setCookieName("syncopeconf-modal");
        this.setupSyncopeConf();
        this.add(new Component[]{new PoliciesPanel("passwordPoliciesPanel", this.getPageReference(), PolicyType.PASSWORD)});
        this.add(new Component[]{new PoliciesPanel("accountPoliciesPanel", this.getPageReference(), PolicyType.ACCOUNT)});
        this.add(new Component[]{new PoliciesPanel("syncPoliciesPanel", this.getPageReference(), PolicyType.SYNC)});
        Component[] componentArray2 = new Component[1];
        this.createNotificationWin = new ModalWindow("createNotificationWin");
        componentArray2[0] = this.createNotificationWin;
        this.add(componentArray2);
        this.createNotificationWin.setCssClassName("w_silver");
        this.createNotificationWin.setInitialHeight(500);
        this.createNotificationWin.setInitialWidth(1100);
        this.createNotificationWin.setCookieName("create-notification-modal");
        Component[] componentArray3 = new Component[1];
        this.editNotificationWin = new ModalWindow("editNotificationWin");
        componentArray3[0] = this.editNotificationWin;
        this.add(componentArray3);
        this.editNotificationWin.setCssClassName("w_silver");
        this.editNotificationWin.setInitialHeight(500);
        this.editNotificationWin.setInitialWidth(1100);
        this.editNotificationWin.setCookieName("edit-notification-modal");
        this.setupNotification();
        Component[] componentArray4 = new Component[1];
        this.createSecurityQuestionWin = new ModalWindow("createSecurityQuestionWin");
        componentArray4[0] = this.createSecurityQuestionWin;
        this.add(componentArray4);
        this.createSecurityQuestionWin.setCssClassName("w_silver");
        this.createSecurityQuestionWin.setInitialHeight(300);
        this.createSecurityQuestionWin.setInitialWidth(900);
        this.createSecurityQuestionWin.setCookieName("create-security-question-modal");
        Component[] componentArray5 = new Component[1];
        this.editSecurityQuestionWin = new ModalWindow("editSecurityQuestionWin");
        componentArray5[0] = this.editSecurityQuestionWin;
        this.add(componentArray5);
        this.editSecurityQuestionWin.setCssClassName("w_silver");
        this.editSecurityQuestionWin.setInitialHeight(300);
        this.editSecurityQuestionWin.setInitialWidth(900);
        this.editSecurityQuestionWin.setCookieName("edit-security-question-modal");
        this.setupSecurityQuestion();
        WebMarkupContainer noActivitiEnabledForUsers = new WebMarkupContainer("noActivitiEnabledForUsers");
        noActivitiEnabledForUsers.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{noActivitiEnabledForUsers});
        WebMarkupContainer workflowDefContainer = new WebMarkupContainer("workflowDefContainer");
        workflowDefContainer.setOutputMarkupPlaceholderTag(true);
        if (this.wfRestClient.isActivitiEnabledForUsers()) {
            noActivitiEnabledForUsers.setVisible(false);
        } else {
            workflowDefContainer.setVisible(false);
        }
        BookmarkablePageLink activitiModeler = new BookmarkablePageLink("activitiModeler", ActivitiModelerPopupPage.class);
        activitiModeler.setPopupSettings(new VeilPopupSettings().setHeight(600).setWidth(800));
        MetaDataRoleAuthorizationStrategy.authorize((Component)activitiModeler, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "workflowDefRead"));
        workflowDefContainer.add(new Component[]{activitiModeler});
        boolean activitiModelerEnabled = false;
        try {
            String activitiModelerDirectory = (String)WebApplicationContextUtils.getWebApplicationContext((ServletContext)WebApplication.get().getServletContext()).getBean("activitiModelerDirectory", String.class);
            File baseDir = new File(activitiModelerDirectory);
            activitiModelerEnabled = baseDir.exists() && baseDir.canRead() && baseDir.isDirectory();
        }
        catch (Exception e) {
            LOG.error("Could not check for Activiti Modeler directory", (Throwable)e);
        }
        activitiModeler.setEnabled(activitiModelerEnabled);
        BookmarkablePageLink xmlEditor = new BookmarkablePageLink("xmlEditor", XMLEditorPopupPage.class);
        xmlEditor.setPopupSettings(new VeilPopupSettings().setHeight(480).setWidth(800));
        MetaDataRoleAuthorizationStrategy.authorize((Component)xmlEditor, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "workflowDefRead"));
        workflowDefContainer.add(new Component[]{xmlEditor});
        Image workflowDefDiagram = new Image("workflowDefDiagram", (IModel)new Model()){
            private static final long serialVersionUID = -8457850449086490660L;

            protected IResource getImageResource() {
                return new DynamicImageResource(){
                    private static final long serialVersionUID = 923201517955737928L;

                    protected byte[] getImageData(IResource.Attributes attributes) {
                        return Configuration.this.wfRestClient.isActivitiEnabledForUsers() ? Configuration.this.wfRestClient.getDiagram() : new byte[]{};
                    }
                };
            }
        };
        workflowDefContainer.add(new Component[]{workflowDefDiagram});
        MetaDataRoleAuthorizationStrategy.authorize((Component)workflowDefContainer, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "workflowDefRead"));
        this.add(new Component[]{workflowDefContainer});
        LoggerPropertyList coreLoggerList = new LoggerPropertyList(null, "corelogger", this.loggerRestClient.listLogs());
        WebMarkupContainer coreLoggerContainer = new WebMarkupContainer("coreLoggerContainer");
        coreLoggerContainer.add(new Component[]{coreLoggerList});
        coreLoggerContainer.setOutputMarkupId(true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)coreLoggerContainer, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "logList"));
        this.add(new Component[]{coreLoggerContainer});
        ConsoleLoggerController consoleLoggerController = new ConsoleLoggerController();
        LoggerPropertyList consoleLoggerList = new LoggerPropertyList(consoleLoggerController, "consolelogger", consoleLoggerController.getLoggers());
        WebMarkupContainer consoleLoggerContainer = new WebMarkupContainer("consoleLoggerContainer");
        consoleLoggerContainer.add(new Component[]{consoleLoggerList});
        consoleLoggerContainer.setOutputMarkupId(true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)consoleLoggerContainer, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "logList"));
        this.add(new Component[]{consoleLoggerContainer});
        this.add(new Component[]{new LayoutsPanel("adminUserLayoutPanel", AttrLayoutType.ADMIN_USER, this.feedbackPanel)});
        this.add(new Component[]{new LayoutsPanel("selfUserLayoutPanel", AttrLayoutType.SELF_USER, this.feedbackPanel)});
        this.add(new Component[]{new LayoutsPanel("adminRoleLayoutPanel", AttrLayoutType.ADMIN_ROLE, this.feedbackPanel)});
        this.add(new Component[]{new LayoutsPanel("selfRoleLayoutPanel", AttrLayoutType.SELF_ROLE, this.feedbackPanel)});
        this.add(new Component[]{new LayoutsPanel("adminMembershipLayoutPanel", AttrLayoutType.ADMIN_MEMBERSHIP, this.feedbackPanel)});
        this.add(new Component[]{new LayoutsPanel("selfMembershipLayoutPanel", AttrLayoutType.SELF_MEMBERSHIP, this.feedbackPanel)});
    }

    private void setupSyncopeConf() {
        final WebMarkupContainer parameters = new WebMarkupContainer("parameters");
        parameters.setOutputMarkupId(true);
        this.add(new Component[]{parameters});
        this.setWindowClosedCallback(this.syncopeConfWin, parameters);
        IndicatingAjaxLink<Void> confLink = new IndicatingAjaxLink<Void>("confLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.syncopeConfWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new ConfModalPage(Configuration.this.getPageReference(), Configuration.this.editNotificationWin, parameters);
                    }
                });
                Configuration.this.syncopeConfWin.show(target);
            }
        };
        parameters.add(new Component[]{confLink});
        Link<Void> dbExportLink = new Link<Void>("dbExportLink"){
            private static final long serialVersionUID = -4331619903296515985L;

            public void onClick() {
                try {
                    HttpResourceStream stream = new HttpResourceStream(Configuration.this.confRestClient.dbExport());
                    ResourceStreamRequestHandler rsrh = new ResourceStreamRequestHandler((IResourceStream)stream);
                    rsrh.setFileName(stream.getFilename() == null ? "content.xml" : stream.getFilename());
                    rsrh.setContentDisposition(ContentDisposition.ATTACHMENT);
                    this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)rsrh);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                }
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)dbExportLink, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Configuration", "export"));
        this.add(new Component[]{dbExportLink});
    }

    private void setupNotification() {
        this.notificationPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "notification.paginator.rows");
        ArrayList<Object> notificationCols = new ArrayList<Object>();
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        notificationCols.add((Object)new CollectionPropertyColumn((IModel<String>)new ResourceModel("events"), "events", "events"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("subject"), (Object)"subject", "subject"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("template"), (Object)"template", "template"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("traceLevel"), (Object)"traceLevel", "traceLevel"));
        notificationCols.add(new PropertyColumn((IModel)new ResourceModel("active"), (Object)"active", "active"));
        notificationCols.add(new AbstractColumn<NotificationTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<NotificationTO>> cellItem, String componentId, IModel<NotificationTO> model) {
                final NotificationTO notificationTO = (NotificationTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, Configuration.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Configuration.this.editNotificationWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new NotificationModalPage(Configuration.this.getPageReference(), Configuration.this.editNotificationWin, notificationTO, false);
                            }
                        });
                        Configuration.this.editNotificationWin.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Notification");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Configuration.this.notificationRestClient.delete(notificationTO.getId());
                        }
                        catch (SyncopeClientException e) {
                            AbstractBasePage.LOG.error("While deleting a notification", (Throwable)e);
                            Configuration.this.error((Serializable)((Object)e.getMessage()));
                            return;
                        }
                        Configuration.this.info((Serializable)((Object)Configuration.this.getString("operation_succeeded")));
                        Configuration.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{Configuration.this.notificationContainer});
                    }
                }, ActionLink.ActionType.DELETE, "Notification");
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable notificationTable = new AjaxFallbackDefaultDataTable("notificationTable", notificationCols, (ISortableDataProvider)new NotificationProvider(), this.notificationPaginatorRows);
        this.notificationContainer = new WebMarkupContainer("notificationContainer");
        this.notificationContainer.add(new Component[]{notificationTable});
        this.notificationContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.notificationContainer});
        this.setWindowClosedCallback(this.createNotificationWin, this.notificationContainer);
        this.setWindowClosedCallback(this.editNotificationWin, this.notificationContainer);
        AjaxLink<Void> createNotificationLink = new AjaxLink<Void>("createNotificationLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.createNotificationWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new NotificationModalPage(Configuration.this.getPageReference(), Configuration.this.createNotificationWin, new NotificationTO(), true);
                    }
                });
                Configuration.this.createNotificationWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createNotificationLink, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Notification", "create"));
        this.add(new Component[]{createNotificationLink});
        Form notificationPaginatorForm = new Form("notificationPaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "notificationPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Configuration.this.prefMan.set(Configuration.this.getRequest(), Configuration.this.getResponse(), "notification.paginator.rows", String.valueOf(Configuration.this.notificationPaginatorRows));
                notificationTable.setItemsPerPage((long)Configuration.this.notificationPaginatorRows);
                target.add(new Component[]{Configuration.this.notificationContainer});
            }
        }});
        notificationPaginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{notificationPaginatorForm});
    }

    private void setupSecurityQuestion() {
        ArrayList<Object> securityQuestionCols = new ArrayList<Object>();
        securityQuestionCols.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        securityQuestionCols.add(new PropertyColumn((IModel)new ResourceModel("content"), (Object)"content", "content"));
        securityQuestionCols.add(new AbstractColumn<SecurityQuestionTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<SecurityQuestionTO>> cellItem, String componentId, IModel<SecurityQuestionTO> model) {
                final SecurityQuestionTO securityQuestionTO = (SecurityQuestionTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, Configuration.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Configuration.this.editSecurityQuestionWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new SecurityQuestionModalPage(Configuration.this.getPageReference(), Configuration.this.editSecurityQuestionWin, securityQuestionTO, false);
                            }
                        });
                        Configuration.this.editSecurityQuestionWin.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "SecurityQuestion");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Configuration.this.securityQuestionRestClient.delete(securityQuestionTO.getId());
                        }
                        catch (SyncopeClientException e) {
                            AbstractBasePage.LOG.error("While deleting a security question", (Throwable)e);
                            Configuration.this.error((Serializable)((Object)e.getMessage()));
                            return;
                        }
                        Configuration.this.info((Serializable)((Object)Configuration.this.getString("operation_succeeded")));
                        Configuration.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{Configuration.this.securityQuestionContainer});
                    }
                }, ActionLink.ActionType.DELETE, "SecurityQuestion");
                cellItem.add(new Component[]{panel});
            }
        });
        AjaxFallbackDefaultDataTable securityQuestionTable = new AjaxFallbackDefaultDataTable("securityQuestionTable", securityQuestionCols, (ISortableDataProvider)new SecurityQuestionProvider(), 50);
        this.securityQuestionContainer = new WebMarkupContainer("securityQuestionContainer");
        this.securityQuestionContainer.add(new Component[]{securityQuestionTable});
        this.securityQuestionContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.securityQuestionContainer});
        this.setWindowClosedCallback(this.createSecurityQuestionWin, this.securityQuestionContainer);
        this.setWindowClosedCallback(this.editSecurityQuestionWin, this.securityQuestionContainer);
        AjaxLink<Void> createSecurityQuestionLink = new AjaxLink<Void>("createSecurityQuestionLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.createSecurityQuestionWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new SecurityQuestionModalPage(Configuration.this.getPageReference(), Configuration.this.createSecurityQuestionWin, new SecurityQuestionTO(), true);
                    }
                });
                Configuration.this.createSecurityQuestionWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createSecurityQuestionLink, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("SecurityQuestion", "create"));
        this.add(new Component[]{createSecurityQuestionLink});
    }

    private static class ConsoleLoggerController
    implements Serializable {
        private static final long serialVersionUID = -1550459341476431714L;

        private ConsoleLoggerController() {
        }

        public List<LoggerTO> getLoggers() {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            ArrayList<LoggerTO> result = new ArrayList<LoggerTO>();
            for (LoggerConfig logger : ctx.getConfiguration().getLoggers().values()) {
                String loggerName;
                String string = loggerName = "".equals(logger.getName()) ? "ROOT" : logger.getName();
                if (logger.getLevel() == null) continue;
                LoggerTO loggerTO = new LoggerTO();
                loggerTO.setName(loggerName);
                loggerTO.setLevel(LoggerLevel.fromLevel((Level)logger.getLevel()));
                result.add(loggerTO);
            }
            return result;
        }

        public void setLogLevel(String name, LoggerLevel level) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            LoggerConfig logConf = "ROOT".equals(name) ? ctx.getConfiguration().getLoggerConfig("") : ctx.getConfiguration().getLoggerConfig(name);
            logConf.setLevel(level.getLevel());
            ctx.updateLoggers();
        }
    }

    private class LoggerPropertyList
    extends PropertyListView<LoggerTO> {
        private static final long serialVersionUID = 5911412425994616111L;
        private final ConsoleLoggerController consoleLoggerController;

        public LoggerPropertyList(ConsoleLoggerController consoleLoggerController, String id, List<? extends LoggerTO> list) {
            super(id, list);
            this.consoleLoggerController = consoleLoggerController;
        }

        protected void populateItem(final ListItem<LoggerTO> item) {
            item.add(new Component[]{new Label("name")});
            DropDownChoice level = new DropDownChoice("level");
            level.setModel((IModel)new IModel<LoggerLevel>(){
                private static final long serialVersionUID = -2350428186089596562L;

                public LoggerLevel getObject() {
                    return ((LoggerTO)item.getModelObject()).getLevel();
                }

                public void setObject(LoggerLevel object) {
                    ((LoggerTO)item.getModelObject()).setLevel(object);
                }

                public void detach() {
                }
            });
            level.setChoices(Arrays.asList(LoggerLevel.values()));
            level.setOutputMarkupId(true);
            level.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    try {
                        if (LoggerPropertyList.this.getId().equals("corelogger")) {
                            Configuration.this.loggerRestClient.setLogLevel(((LoggerTO)item.getModelObject()).getName(), ((LoggerTO)item.getModelObject()).getLevel());
                        } else {
                            LoggerPropertyList.this.consoleLoggerController.setLogLevel(((LoggerTO)item.getModelObject()).getName(), ((LoggerTO)item.getModelObject()).getLevel());
                        }
                        LoggerPropertyList.this.info((Serializable)((Object)LoggerPropertyList.this.getString("operation_succeeded")));
                    }
                    catch (SyncopeClientException e) {
                        LoggerPropertyList.this.info((Serializable)((Object)LoggerPropertyList.this.getString("operation_error")));
                    }
                    Configuration.this.feedbackPanel.refresh(target);
                }
            }});
            MetaDataRoleAuthorizationStrategy.authorize((Component)level, (Action)ENABLE, (String)Configuration.this.xmlRolesReader.getEntitlement("Configuration", "logSetLevel"));
            item.add(new Component[]{level});
        }
    }

    private class SecurityQuestionProvider
    extends SortableDataProvider<SecurityQuestionTO, String> {
        private static final long serialVersionUID = -1458398823626281188L;
        private final SortableDataProviderComparator<SecurityQuestionTO> comparator;

        public SecurityQuestionProvider() {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<SecurityQuestionTO>(this);
        }

        public Iterator<SecurityQuestionTO> iterator(long first, long count) {
            List<SecurityQuestionTO> list = Configuration.this.securityQuestionRestClient.list();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return Configuration.this.securityQuestionRestClient.list().size();
        }

        public IModel<SecurityQuestionTO> model(final SecurityQuestionTO securityQuestionTO) {
            return new AbstractReadOnlyModel<SecurityQuestionTO>(){
                private static final long serialVersionUID = 5079291243768775704L;

                public SecurityQuestionTO getObject() {
                    return securityQuestionTO;
                }
            };
        }
    }

    private class NotificationProvider
    extends SortableDataProvider<NotificationTO, String> {
        private static final long serialVersionUID = -276043813563988590L;
        private final SortableDataProviderComparator<NotificationTO> comparator;

        public NotificationProvider() {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<NotificationTO>(this);
        }

        public Iterator<NotificationTO> iterator(long first, long count) {
            List<NotificationTO> list = Configuration.this.notificationRestClient.getAllNotifications();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return Configuration.this.notificationRestClient.getAllNotifications().size();
        }

        public IModel<NotificationTO> model(final NotificationTO notification) {
            return new AbstractReadOnlyModel<NotificationTO>(){
                private static final long serialVersionUID = 774694801558497248L;

                public NotificationTO getObject() {
                    return notification;
                }
            };
        }
    }
}

