/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class ConfirmPasswordResetModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -8419445804421211904L;

    public ConfirmPasswordResetModalPage(final ModalWindow window, final String token) {
        this.setOutputMarkupId(true);
        StatelessForm form = new StatelessForm("form");
        form.setOutputMarkupId(true);
        final FieldPanel password = new AjaxPasswordFieldPanel("password", "password", (IModel<String>)new Model()).setRequired(true);
        ((PasswordTextField)password.getField()).setResetPassword(true);
        form.add(new Component[]{password});
        AjaxPasswordFieldPanel confirmPassword = new AjaxPasswordFieldPanel("confirmPassword", "confirmPassword", (IModel<String>)new Model());
        ((PasswordTextField)confirmPassword.getField()).setResetPassword(true);
        form.add(new Component[]{confirmPassword});
        form.add((IFormValidator)new EqualPasswordInputValidator(password.getField(), confirmPassword.getField()));
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit", "submit")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    ConfirmPasswordResetModalPage.this.userSelfRestClient.confirmPasswordReset(token, (String)password.getModelObject());
                    this.setResponsePage((Page)new ResultStatusModalPage.Builder(window, (AbstractSubjectTO)new UserTO()).mode(Mode.SELF).build());
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("While confirming password reset for {}", (Object)token, (Object)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    ConfirmPasswordResetModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ConfirmPasswordResetModalPage.this.feedbackPanel.refresh(target);
            }
        };
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

