/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.ConnBundleTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.ConnPoolConfTO;
import org.apache.syncope.common.types.ConnConfPropSchema;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.common.types.ConnectorCapability;
import org.apache.syncope.console.markup.html.list.ConnConfPropertyListView;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.Resources;
import org.apache.syncope.console.rest.ConnectorRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;

public class ConnectorModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -2025535531121434050L;
    @SpringBean
    private ConnectorRestClient restClient;
    private final Map<String, Map<String, Map<String, ConnBundleTO>>> mapConnBundleTOs;
    private final List<ConnectorCapability> selectedCapabilities;
    private ConnBundleTO bundleTO;
    private List<ConnConfProperty> properties;
    private final WebMarkupContainer propertiesContainer;

    public ConnectorModalPage(final PageReference pageRef, final ModalWindow window, final ConnInstanceTO connInstanceTO) {
        this.selectedCapabilities = new ArrayList<ConnectorCapability>(connInstanceTO.getId() == 0L ? EnumSet.noneOf(ConnectorCapability.class) : connInstanceTO.getCapabilities());
        this.mapConnBundleTOs = new HashMap<String, Map<String, Map<String, ConnBundleTO>>>();
        for (ConnBundleTO connBundleTO : this.restClient.getAllBundles()) {
            Map<String, ConnBundleTO> byName;
            Map<String, Map<String, ConnBundleTO>> byLocation;
            if (!this.mapConnBundleTOs.containsKey(connBundleTO.getLocation())) {
                this.mapConnBundleTOs.put(connBundleTO.getLocation(), new HashMap());
            }
            if (!(byLocation = this.mapConnBundleTOs.get(connBundleTO.getLocation())).containsKey(connBundleTO.getBundleName())) {
                byLocation.put(connBundleTO.getBundleName(), new HashMap());
            }
            if ((byName = byLocation.get(connBundleTO.getBundleName())).containsKey(connBundleTO.getVersion())) continue;
            byName.put(connBundleTO.getVersion(), connBundleTO);
        }
        this.bundleTO = this.getSelectedBundleTO(connInstanceTO);
        this.properties = this.fillProperties(this.bundleTO, connInstanceTO);
        Form connectorForm = new Form("form");
        connectorForm.setModel((IModel)new CompoundPropertyModel((Object)connInstanceTO));
        connectorForm.setOutputMarkupId(true);
        this.add(new Component[]{connectorForm});
        this.propertiesContainer = new WebMarkupContainer("container");
        this.propertiesContainer.setOutputMarkupId(true);
        connectorForm.add(new Component[]{this.propertiesContainer});
        Form connectorPropForm = new Form("connectorPropForm");
        connectorPropForm.setModel((IModel)new CompoundPropertyModel((Object)connInstanceTO));
        connectorPropForm.setOutputMarkupId(true);
        this.propertiesContainer.add(new Component[]{connectorPropForm});
        AjaxTextFieldPanel displayName = new AjaxTextFieldPanel("displayName", "display name", (IModel<String>)new PropertyModel((Object)connInstanceTO, "displayName"));
        displayName.setOutputMarkupId(true);
        displayName.addRequiredLabel();
        connectorForm.add(new Component[]{displayName});
        final AjaxDropDownChoicePanel location = new AjaxDropDownChoicePanel("location", "location", new Model(this.bundleTO == null ? null : this.bundleTO.getLocation()));
        ((DropDownChoice)location.getField()).setNullValid(true);
        location.setStyleSheet("long_dynamicsize");
        location.setChoices(new ArrayList<String>(this.mapConnBundleTOs.keySet()));
        location.setRequired(true);
        location.addRequiredLabel();
        location.setOutputMarkupId(true);
        location.setEnabled(connInstanceTO.getId() == 0L);
        location.getField().setOutputMarkupId(true);
        connectorForm.add(new Component[]{location});
        final AjaxDropDownChoicePanel connectorName = new AjaxDropDownChoicePanel("connectorName", "connectorName", new Model(this.bundleTO == null ? null : this.bundleTO.getBundleName()));
        ((DropDownChoice)connectorName.getField()).setNullValid(true);
        connectorName.setStyleSheet("long_dynamicsize");
        connectorName.setChoices(this.bundleTO == null ? new ArrayList() : new ArrayList<String>(this.mapConnBundleTOs.get(connInstanceTO.getLocation()).keySet()));
        connectorName.setRequired(true);
        connectorName.addRequiredLabel();
        connectorName.setEnabled(connInstanceTO.getLocation() != null);
        connectorName.setOutputMarkupId(true);
        connectorName.setEnabled(connInstanceTO.getId() == 0L);
        connectorName.getField().setOutputMarkupId(true);
        connectorForm.add(new Component[]{connectorName});
        final AjaxDropDownChoicePanel version = new AjaxDropDownChoicePanel("version", "version", new Model(this.bundleTO == null ? null : this.bundleTO.getVersion()));
        version.setStyleSheet("long_dynamicsize");
        version.setChoices(this.bundleTO == null ? new ArrayList() : new ArrayList<String>(this.mapConnBundleTOs.get(connInstanceTO.getLocation()).get(connInstanceTO.getBundleName()).keySet()));
        version.setRequired(true);
        version.addRequiredLabel();
        version.setEnabled(connInstanceTO.getBundleName() != null);
        version.setOutputMarkupId(true);
        version.addRequiredLabel();
        version.getField().setOutputMarkupId(true);
        connectorForm.add(new Component[]{version});
        SpinnerFieldPanel<Object> connRequestTimeout = new SpinnerFieldPanel<Object>("connRequestTimeout", "connRequestTimeout", (Class<Object>)Integer.class, (IModel<Object>)new PropertyModel((Object)connInstanceTO, "connRequestTimeout"), 0, null);
        connRequestTimeout.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{connRequestTimeout});
        if (connInstanceTO.getPoolConf() == null) {
            connInstanceTO.setPoolConf(new ConnPoolConfTO());
        }
        SpinnerFieldPanel<Object> poolMaxObjects = new SpinnerFieldPanel<Object>("poolMaxObjects", "poolMaxObjects", (Class<Object>)Integer.class, (IModel<Object>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxObjects"), 0, null);
        poolMaxObjects.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMaxObjects});
        SpinnerFieldPanel<Object> poolMinIdle = new SpinnerFieldPanel<Object>("poolMinIdle", "poolMinIdle", (Class<Object>)Integer.class, (IModel<Object>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minIdle"), 0, null);
        poolMinIdle.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMinIdle});
        SpinnerFieldPanel<Object> poolMaxIdle = new SpinnerFieldPanel<Object>("poolMaxIdle", "poolMaxIdle", (Class<Object>)Integer.class, (IModel<Object>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxIdle"), 0, null);
        poolMaxIdle.getField().add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMaxIdle});
        SpinnerFieldPanel<Object> poolMaxWait = new SpinnerFieldPanel<Object>("poolMaxWait", "poolMaxWait", (Class<Object>)Long.class, (IModel<Object>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxWait"), 0L, null);
        poolMaxWait.getField().add((IValidator)new RangeValidator((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMaxWait});
        SpinnerFieldPanel<Object> poolMinEvictableIdleTime = new SpinnerFieldPanel<Object>("poolMinEvictableIdleTime", "poolMinEvictableIdleTime", (Class<Object>)Long.class, (IModel<Object>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minEvictableIdleTimeMillis"), 0L, null);
        poolMinEvictableIdleTime.getField().add((IValidator)new RangeValidator((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE)));
        connectorForm.add(new Component[]{poolMinEvictableIdleTime});
        location.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ((DropDownChoice)location.getField()).setNullValid(false);
                connInstanceTO.setLocation((String)location.getModelObject());
                target.add(new Component[]{location});
                connectorName.setChoices(new ArrayList(((Map)ConnectorModalPage.this.mapConnBundleTOs.get(location.getModelObject())).keySet()));
                connectorName.setEnabled(true);
                connectorName.getField().setModelValue(null);
                target.add(new Component[]{connectorName});
                version.setChoices(new ArrayList());
                version.getField().setModelValue(null);
                version.setEnabled(false);
                target.add(new Component[]{version});
                ConnectorModalPage.this.properties.clear();
                target.add(new Component[]{ConnectorModalPage.this.propertiesContainer});
            }
        }});
        connectorName.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ((DropDownChoice)connectorName.getField()).setNullValid(false);
                connInstanceTO.setBundleName((String)connectorName.getModelObject());
                target.add(new Component[]{connectorName});
                ArrayList versions = new ArrayList(((Map)((Map)ConnectorModalPage.this.mapConnBundleTOs.get(location.getModelObject())).get(connectorName.getModelObject())).keySet());
                version.setChoices(versions);
                version.setEnabled(true);
                if (versions.size() == 1) {
                    ConnectorModalPage.this.selectVersion(target, connInstanceTO, version, (String)versions.get(0));
                    version.getField().setModelObject(versions.get(0));
                } else {
                    version.getField().setModelValue(null);
                    ConnectorModalPage.this.properties.clear();
                    target.add(new Component[]{ConnectorModalPage.this.propertiesContainer});
                }
                target.add(new Component[]{version});
            }
        }});
        version.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ConnectorModalPage.this.selectVersion(target, connInstanceTO, version, (String)version.getModelObject());
            }
        }});
        final ConnConfPropertyListView connPropView = new ConnConfPropertyListView("connectorProperties", (IModel<? extends List<? extends ConnConfProperty>>)new PropertyModel((Object)this, "properties"), true, connInstanceTO.getConfiguration());
        connPropView.setOutputMarkupId(true);
        connectorPropForm.add(new Component[]{connPropView});
        IndicatingAjaxButton check = new IndicatingAjaxButton("check", (IModel)new ResourceModel("check")){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ConnInstanceTO conn = (ConnInstanceTO)form.getModelObject();
                conn.setBundleName(ConnectorModalPage.this.bundleTO.getBundleName());
                conn.setVersion(ConnectorModalPage.this.bundleTO.getVersion());
                conn.setConnectorName(ConnectorModalPage.this.bundleTO.getConnectorName());
                if (ConnectorModalPage.this.restClient.check(conn)) {
                    this.info((Serializable)((Object)this.getString("success_connection")));
                } else {
                    this.error((Serializable)((Object)this.getString("error_connection")));
                }
                ConnectorModalPage.this.feedbackPanel.refresh(target);
            }
        };
        connectorPropForm.add(new Component[]{check});
        LoadableDetachableModel<List<ConnectorCapability>> capabilities = new LoadableDetachableModel<List<ConnectorCapability>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<ConnectorCapability> load() {
                return Arrays.asList(ConnectorCapability.values());
            }
        };
        CheckBoxMultipleChoice capabilitiesPalette = new CheckBoxMultipleChoice("capabilitiesPalette", (IModel)new PropertyModel((Object)this, "selectedCapabilities"), (IModel)capabilities);
        capabilitiesPalette.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        connectorForm.add(new Component[]{capabilitiesPalette});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ConnInstanceTO conn = (ConnInstanceTO)form.getModelObject();
                conn.setConnectorName(ConnectorModalPage.this.bundleTO.getConnectorName());
                conn.setBundleName(ConnectorModalPage.this.bundleTO.getBundleName());
                conn.setVersion(ConnectorModalPage.this.bundleTO.getVersion());
                conn.getConfiguration().clear();
                conn.getConfiguration().addAll(connPropView.getModelObject());
                conn.getCapabilities().clear();
                conn.getCapabilities().addAll(ConnectorModalPage.this.selectedCapabilities.isEmpty() ? EnumSet.noneOf(ConnectorCapability.class) : EnumSet.copyOf(ConnectorModalPage.this.selectedCapabilities));
                if (conn.getPoolConf() != null && conn.getPoolConf().getMaxIdle() == null && conn.getPoolConf().getMaxObjects() == null && conn.getPoolConf().getMaxWait() == null && conn.getPoolConf().getMinEvictableIdleTimeMillis() == null && conn.getPoolConf().getMinIdle() == null) {
                    conn.setPoolConf(null);
                }
                try {
                    if (connInstanceTO.getId() == 0L) {
                        ConnectorModalPage.this.restClient.create(conn);
                    } else {
                        ConnectorModalPage.this.restClient.update(conn);
                    }
                    ((Resources)pageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    ConnectorModalPage.this.feedbackPanel.refresh(target);
                    ((Resources)pageRef.getPage()).setModalResult(false);
                    AbstractBasePage.LOG.error("While creating or updating connector {}", (Object)conn, (Object)e);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ConnectorModalPage.this.feedbackPanel.refresh(target);
            }
        };
        String roles = connInstanceTO.getId() == 0L ? this.xmlRolesReader.getEntitlement("Connectors", "create") : this.xmlRolesReader.getEntitlement("Connectors", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)roles);
        connectorForm.add(new Component[]{submit});
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        connectorForm.add(new Component[]{cancel});
    }

    private ConnBundleTO getSelectedBundleTO(ConnInstanceTO connInstanceTO) {
        Map<String, ConnBundleTO> byName;
        Map<String, Map<String, ConnBundleTO>> byLocation;
        ConnBundleTO result = null;
        if (connInstanceTO != null && StringUtils.isNotBlank((CharSequence)connInstanceTO.getLocation()) && StringUtils.isNotBlank((CharSequence)connInstanceTO.getBundleName()) && StringUtils.isNotBlank((CharSequence)connInstanceTO.getVersion()) && this.mapConnBundleTOs.containsKey(connInstanceTO.getLocation()) && (byLocation = this.mapConnBundleTOs.get(connInstanceTO.getLocation())).containsKey(connInstanceTO.getBundleName()) && (byName = byLocation.get(connInstanceTO.getBundleName())).containsKey(connInstanceTO.getVersion())) {
            result = byName.get(connInstanceTO.getVersion());
        }
        return result;
    }

    private List<ConnConfProperty> fillProperties(ConnBundleTO bundleTO, ConnInstanceTO connInstanceTO) {
        ArrayList<ConnConfProperty> props = new ArrayList<ConnConfProperty>();
        if (bundleTO != null) {
            for (ConnConfPropSchema key : bundleTO.getProperties()) {
                ConnConfProperty property = new ConnConfProperty();
                property.setSchema(key);
                if (connInstanceTO.getId() != 0L && connInstanceTO.getConfigurationMap().containsKey(key.getName()) && ((ConnConfProperty)connInstanceTO.getConfigurationMap().get(key.getName())).getValues() != null) {
                    property.getValues().addAll(((ConnConfProperty)connInstanceTO.getConfigurationMap().get(key.getName())).getValues());
                    property.setOverridable(((ConnConfProperty)connInstanceTO.getConfigurationMap().get(key.getName())).isOverridable());
                }
                if (property.getValues().isEmpty() && !key.getDefaultValues().isEmpty()) {
                    property.getValues().addAll(key.getDefaultValues());
                }
                props.add(property);
            }
        }
        Collections.sort(props);
        return props;
    }

    private void selectVersion(AjaxRequestTarget target, ConnInstanceTO connInstanceTO, AjaxDropDownChoicePanel<String> version, String versionValue) {
        connInstanceTO.setVersion(versionValue);
        target.add(new Component[]{version});
        this.bundleTO = this.getSelectedBundleTO(connInstanceTO);
        this.properties = this.fillProperties(this.bundleTO, connInstanceTO);
        target.add(new Component[]{this.propertiesContainer});
    }

    public List<ConnConfProperty> getProperties() {
        return this.properties;
    }
}

