/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.DerSchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.pages.AbstractSchemaModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class DerSchemaModalPage
extends AbstractSchemaModalPage<DerSchemaTO> {
    private static final long serialVersionUID = 6668789770131753386L;

    public DerSchemaModalPage(AttributableType kind) {
        super(kind);
    }

    @Override
    public void setSchemaModalPage(final PageReference pageRef, final ModalWindow window, DerSchemaTO schema, final boolean createFlag) {
        if (schema == null) {
            schema = new DerSchemaTO();
        }
        Form schemaForm = new Form("form");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel<String>)new PropertyModel((Object)schema, "name"));
        name.addRequiredLabel();
        AjaxTextFieldPanel expression = new AjaxTextFieldPanel("expression", this.getString("expression"), (IModel<String>)new PropertyModel((Object)schema, "expression"));
        expression.addRequiredLabel();
        WebMarkupContainer jexlHelp = JexlHelpUtil.getJexlHelpWebContainer("jexlHelp");
        AjaxLink<Void> questionMarkJexlHelp = JexlHelpUtil.getAjaxLink(jexlHelp, "questionMarkJexlHelp");
        schemaForm.add(new Component[]{questionMarkJexlHelp});
        questionMarkJexlHelp.add(new Component[]{jexlHelp});
        name.setEnabled(createFlag);
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                DerSchemaTO schemaTO = (DerSchemaTO)form.getDefaultModelObject();
                try {
                    if (createFlag) {
                        DerSchemaModalPage.this.schemaRestClient.createDerSchema(DerSchemaModalPage.this.kind, schemaTO);
                    } else {
                        DerSchemaModalPage.this.schemaRestClient.updateDerSchema(DerSchemaModalPage.this.kind, schemaTO);
                    }
                    if (pageRef.getPage() instanceof BasePage) {
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                    }
                    window.close(target);
                }
                catch (SyncopeClientException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    DerSchemaModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                DerSchemaModalPage.this.feedbackPanel.refresh(target);
            }
        };
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        String allowedRoles = createFlag ? this.xmlRolesReader.getEntitlement("Schema", "create") : this.xmlRolesReader.getEntitlement("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        schemaForm.add(new Component[]{name});
        schemaForm.add(new Component[]{expression});
        schemaForm.add(new Component[]{submit});
        schemaForm.add(new Component[]{cancel});
        this.add(new Component[]{schemaForm});
    }
}

