/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.syncope.common.search.SearchableFields;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class DisplayAttributesModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -4274117450918385110L;
    private static final int MAX_SELECTIONS = 9;
    public static final String[] DEFAULT_SELECTION = new String[]{"id", "username", "status"};
    @SpringBean
    private PreferenceManager prefMan;
    private final List<String> selectedDetails;
    private final List<String> selectedSchemas;
    private final List<String> selectedDerSchemas;

    public DisplayAttributesModalPage(final PageReference pageRef, final ModalWindow window, final List<String> schemaNames, final List<String> dSchemaNames) {
        Fragment fragment;
        LoadableDetachableModel<List<String>> fnames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return SearchableFields.get(UserTO.class);
            }
        };
        LoadableDetachableModel<List<String>> names = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return schemaNames;
            }
        };
        LoadableDetachableModel<List<String>> dsnames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return dSchemaNames;
            }
        };
        Form form = new Form("form");
        form.setModel((IModel)new CompoundPropertyModel((Object)this));
        this.selectedDetails = this.prefMan.getList(this.getRequest(), "users.details.view");
        this.selectedSchemas = this.prefMan.getList(this.getRequest(), "users.attributes.view");
        this.selectedDerSchemas = this.prefMan.getList(this.getRequest(), "users.derived.attributes.view");
        CheckGroup dgroup = new CheckGroup("dCheckGroup", (IModel)new PropertyModel((Object)this, "selectedDetails"));
        form.add(new Component[]{dgroup});
        ListView<String> details = new ListView<String>("details", (IModel)fnames){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("dcheck", item.getModel())});
                item.add(new Component[]{new Label("dname", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
            }
        };
        dgroup.add(new Component[]{details});
        if (names.getObject() == null || ((List)names.getObject()).isEmpty()) {
            fragment = new Fragment("schemas", "emptyFragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            this.selectedSchemas.clear();
        } else {
            fragment = new Fragment("schemas", "sfragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            CheckGroup sgroup = new CheckGroup("sCheckGroup", (IModel)new PropertyModel((Object)this, "selectedSchemas"));
            fragment.add(new Component[]{sgroup});
            ListView<String> schemas = new ListView<String>("schemas", (IModel)names){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<String> item) {
                    item.add(new Component[]{new Check("scheck", item.getModel())});
                    item.add(new Component[]{new Label("sname", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
                }
            };
            sgroup.add(new Component[]{schemas});
        }
        if (dsnames.getObject() == null || ((List)dsnames.getObject()).isEmpty()) {
            fragment = new Fragment("dschemas", "emptyFragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            this.selectedDerSchemas.clear();
        } else {
            fragment = new Fragment("dschemas", "dsfragment", (MarkupContainer)form);
            form.add(new Component[]{fragment});
            CheckGroup dsgroup = new CheckGroup("dsCheckGroup", (IModel)new PropertyModel((Object)this, "selectedDerSchemas"));
            fragment.add(new Component[]{dsgroup});
            ListView<String> derSchemas = new ListView<String>("derSchemas", (IModel)dsnames){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<String> item) {
                    item.add(new Component[]{new Check("dscheck", item.getModel())});
                    item.add(new Component[]{new Label("dsname", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
                }
            };
            dsgroup.add(new Component[]{derSchemas});
        }
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                if (DisplayAttributesModalPage.this.selectedDetails.size() + DisplayAttributesModalPage.this.selectedSchemas.size() + DisplayAttributesModalPage.this.selectedDerSchemas.size() > 9) {
                    this.error((Serializable)((Object)this.getString("tooManySelections")));
                    this.onError(target, form);
                } else {
                    HashMap<String, List<String>> prefs = new HashMap<String, List<String>>();
                    prefs.put("users.details.view", DisplayAttributesModalPage.this.selectedDetails);
                    prefs.put("users.attributes.view", DisplayAttributesModalPage.this.selectedSchemas);
                    prefs.put("users.derived.attributes.view", DisplayAttributesModalPage.this.selectedDerSchemas);
                    DisplayAttributesModalPage.this.prefMan.setList(this.getRequest(), this.getResponse(), prefs);
                    ((BasePage)pageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                DisplayAttributesModalPage.this.feedbackPanel.refresh(target);
            }
        };
        form.add(new Component[]{submit});
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

