/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.util.AttributableOperations;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.pages.UserModalPage;
import org.apache.syncope.console.pages.panels.AccountInformationPanel;
import org.apache.syncope.console.pages.panels.MembershipsPanel;
import org.apache.syncope.console.pages.panels.ResourcesPanel;
import org.apache.syncope.console.pages.panels.StatusPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class EditUserModalPage
extends UserModalPage {
    private static final long serialVersionUID = -6479209496805705739L;
    protected Form form;
    private final UserTO initialUserTO;
    private StatusPanel statusPanel;

    public EditUserModalPage(PageReference pageRef, ModalWindow window, UserTO userTO) {
        super(pageRef, window, userTO, Mode.ADMIN, true);
        this.initialUserTO = (UserTO)SerializationUtils.clone((Serializable)userTO);
        this.form = this.setupEditPanel();
        if (userTO.getId() != 0L) {
            this.form.addOrReplace(new Component[]{new Label("pwdChangeInfo", (IModel)new ResourceModel("pwdChangeInfo"))});
            this.statusPanel = new StatusPanel("statuspanel", (AbstractSubjectTO)userTO, new ArrayList<StatusBean>(), this.getPageReference());
            this.statusPanel.setOutputMarkupId(true);
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.statusPanel, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Resources", "getConnectorObject"));
            this.form.addOrReplace(new Component[]{this.statusPanel});
            this.form.addOrReplace(new Component[]{new AccountInformationPanel("accountinformation", userTO)});
            this.form.addOrReplace(new Component[]{new ResourcesPanel.Builder("resources").attributableTO(userTO).statusPanel(this.statusPanel).build()});
            this.form.addOrReplace(new Component[]{new MembershipsPanel("memberships", userTO, this.mode, this.statusPanel, this.getPageReference())});
        }
    }

    @Override
    protected void submitAction(AjaxRequestTarget target, Form<?> form) {
        UserTO updatedUserTO = (UserTO)form.getModelObject();
        if (updatedUserTO.getId() == 0L) {
            this.userTO = this.userRestClient.create(updatedUserTO, (Boolean)this.storePassword.getModelObject());
        } else {
            UserMod userMod = AttributableOperations.diff((UserTO)updatedUserTO, (UserTO)this.initialUserTO);
            if (this.statusPanel != null) {
                userMod.setPwdPropRequest(this.statusPanel.getStatusMod());
            }
            if (!userMod.isEmpty()) {
                this.userTO = this.userRestClient.update(this.initialUserTO.getETagValue(), userMod);
            }
        }
    }

    @Override
    protected void closeAction(AjaxRequestTarget target, Form<?> form) {
        this.setResponsePage((Page)new ResultStatusModalPage.Builder(this.window, (AbstractSubjectTO)this.userTO).mode(this.mode).build());
    }
}

