/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.services.EntitlementService;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.pages.ConfirmPasswordResetModalPage;
import org.apache.syncope.console.pages.RequestPasswordResetModalPage;
import org.apache.syncope.console.pages.UserSelfModalPage;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.rest.UserSelfRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.syncope.console.wicket.markup.html.form.LinkPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Login
extends WebPage {
    private static final long serialVersionUID = -3744389270366566218L;
    private static final int SELF_REG_WIN_HEIGHT = 550;
    private static final int SELF_REG_WIN_WIDTH = 800;
    private static final int PWD_RESET_WIN_HEIGHT = 300;
    private static final int PWD_RESET_WIN_WIDTH = 800;
    @SpringBean(name="version")
    private String version;
    @SpringBean(name="anonymousUser")
    private String anonymousUser;
    @SpringBean(name="anonymousKey")
    private String anonymousKey;
    @SpringBean
    private UserSelfRestClient userSelfRestClient;
    private final StatelessForm<Void> form;
    private final TextField<String> userIdField;
    private final TextField<String> passwordField;
    private final DropDownChoice<Locale> languageSelect;
    private final NotificationPanel feedbackPanel;

    public Login(final PageParameters parameters) {
        super(parameters);
        Fragment pwdResetFrag;
        Fragment selfRegFrag;
        this.setStatelessHint(true);
        this.feedbackPanel = new NotificationPanel("feedback");
        this.add(new Component[]{this.feedbackPanel});
        this.form = new StatelessForm("login");
        this.userIdField = new TextField("userId", (IModel)new Model());
        this.userIdField.setMarkupId("userId");
        this.form.add(new Component[]{this.userIdField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown("language");
        this.form.add(new Component[]{this.languageSelect});
        AjaxButton submitButton = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = 429178684321093953L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    if (Login.this.anonymousUser.equals(Login.this.userIdField.getRawInput())) {
                        throw new AccessControlException("Illegal username");
                    }
                    Login.this.authenticate(Login.this.userIdField.getRawInput(), Login.this.passwordField.getRawInput());
                    this.setResponsePage(this.getApplication().getHomePage(), parameters);
                }
                catch (AccessControlException e) {
                    this.error((Serializable)((Object)this.getString("login-error")));
                    Login.this.feedbackPanel.refresh(target);
                    SyncopeSession.get().resetClients();
                }
            }
        };
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        final ModalWindow selfRegModalWin = new ModalWindow("selfRegModal");
        selfRegModalWin.setCssClassName("w_silver");
        selfRegModalWin.setInitialHeight(550);
        selfRegModalWin.setInitialWidth(800);
        selfRegModalWin.setCookieName("self-reg-modal");
        this.add(new Component[]{selfRegModalWin});
        if (this.userSelfRestClient.isSelfRegistrationAllowed()) {
            selfRegFrag = new Fragment("selfRegistration", "selfRegAllowed", (MarkupContainer)this);
            ClearIndicatingAjaxLink<Void> selfRegLink = new ClearIndicatingAjaxLink<Void>("link", this.getPageReference()){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                protected void onClickInternal(AjaxRequestTarget target) {
                    selfRegModalWin.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = -7834632442532690940L;

                        public Page createPage() {
                            Login.this.authenticate(Login.this.anonymousUser, Login.this.anonymousKey);
                            return new UserSelfModalPage(Login.this.getPageReference(), selfRegModalWin, new UserTO());
                        }
                    });
                    selfRegModalWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
                        private static final long serialVersionUID = 251794406325329768L;

                        public void onClose(AjaxRequestTarget target) {
                            SyncopeSession.get().invalidate();
                        }
                    });
                    selfRegModalWin.show(target);
                }
            };
            selfRegLink.add(new Component[]{new Label("linkTitle", this.getString("selfRegistration"))});
            LinkPanel panel = new LinkPanel("selfRegistration", (IModel<?>)new ResourceModel("selfRegistration"));
            panel.add(new Component[]{selfRegLink});
            selfRegFrag.add(new Component[]{panel});
        } else {
            selfRegFrag = new Fragment("selfRegistration", "selfRegNotAllowed", (MarkupContainer)this);
        }
        this.add(new Component[]{selfRegFrag});
        final ModalWindow pwdResetReqModalWin = new ModalWindow("pwdResetReqModal");
        pwdResetReqModalWin.setCssClassName("w_silver");
        pwdResetReqModalWin.setInitialHeight(300);
        pwdResetReqModalWin.setInitialWidth(800);
        pwdResetReqModalWin.setCookieName("pwd-reset-req-modal");
        this.add(new Component[]{pwdResetReqModalWin});
        if (this.userSelfRestClient.isPasswordResetAllowed()) {
            pwdResetFrag = new Fragment("passwordReset", "pwdResetAllowed", (MarkupContainer)this);
            ClearIndicatingAjaxLink<Void> pwdResetLink = new ClearIndicatingAjaxLink<Void>("link", this.getPageReference()){
                private static final long serialVersionUID = -6957616042924610290L;

                @Override
                protected void onClickInternal(AjaxRequestTarget target) {
                    pwdResetReqModalWin.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = -7834632442532690940L;

                        public Page createPage() {
                            Login.this.authenticate(Login.this.anonymousUser, Login.this.anonymousKey);
                            return new RequestPasswordResetModalPage(pwdResetReqModalWin);
                        }
                    });
                    pwdResetReqModalWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
                        private static final long serialVersionUID = 8804221891699487139L;

                        public void onClose(AjaxRequestTarget target) {
                            SyncopeSession.get().invalidate();
                            this.setResponsePage(Login.class);
                        }
                    });
                    pwdResetReqModalWin.show(target);
                }
            };
            pwdResetLink.add(new Component[]{new Label("linkTitle", this.getString("passwordReset"))});
            LinkPanel panel = new LinkPanel("passwordReset", (IModel<?>)new ResourceModel("passwordReset"));
            panel.add(new Component[]{pwdResetLink});
            pwdResetFrag.add(new Component[]{panel});
        } else {
            pwdResetFrag = new Fragment("passwordReset", "pwdResetNotAllowed", (MarkupContainer)this);
        }
        this.add(new Component[]{pwdResetFrag});
        final String pwdResetToken = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("pwdResetToken").toOptionalString();
        final ModalWindow pwdResetConfModalWin = new ModalWindow("pwdResetConfModal");
        if (StringUtils.isNotBlank((CharSequence)pwdResetToken)) {
            pwdResetConfModalWin.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
                private static final long serialVersionUID = 3109256773218160485L;

                protected void respond(AjaxRequestTarget target) {
                    ModalWindow window = (ModalWindow)this.getComponent();
                    window.show(target);
                }

                public void renderHead(Component component, IHeaderResponse response) {
                    response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this.getCallbackScript(), null));
                }
            }});
        }
        pwdResetConfModalWin.setCssClassName("w_silver");
        pwdResetConfModalWin.setInitialHeight(300);
        pwdResetConfModalWin.setInitialWidth(800);
        pwdResetConfModalWin.setCookieName("pwd-reset-conf-modal");
        pwdResetConfModalWin.setPageCreator(new ModalWindow.PageCreator(){
            private static final long serialVersionUID = -7834632442532690940L;

            public Page createPage() {
                Login.this.authenticate(Login.this.anonymousUser, Login.this.anonymousKey);
                return new ConfirmPasswordResetModalPage(pwdResetConfModalWin, pwdResetToken);
            }
        });
        pwdResetConfModalWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                SyncopeSession.get().invalidate();
                Login.this.setResponsePage(Login.class);
            }
        });
        this.add(new Component[]{pwdResetConfModalWin});
    }

    private void authenticate(String username, String password) {
        List entitlements = SyncopeSession.get().getService(EntitlementService.class, username, password).getOwnEntitlements();
        SyncopeSession.get().setUsername(username);
        SyncopeSession.get().setPassword(password);
        SyncopeSession.get().setEntitlements(CollectionWrapper.unwrap((Collection)entitlements).toArray(new String[0]));
        SyncopeSession.get().setVersion(this.version);
    }

    private class LocaleDropDown
    extends DropDownChoice<Locale> {
        private static final long serialVersionUID = 2349382679992357202L;

        public LocaleDropDown(String id) {
            super(id, SyncopeSession.SUPPORTED_LOCALES);
            this.setChoiceRenderer((IChoiceRenderer)new LocaleRenderer());
            this.setModel((IModel)new IModel<Locale>(){
                private static final long serialVersionUID = -6985170095629312963L;

                public Locale getObject() {
                    return LocaleDropDown.this.getSession().getLocale();
                }

                public void setObject(Locale object) {
                    LocaleDropDown.this.getSession().setLocale(object);
                }

                public void detach() {
                }
            });
            this.getModel().setObject((Object)Locale.ENGLISH);
        }

        protected boolean wantOnSelectionChangedNotifications() {
            return true;
        }

        private class LocaleRenderer
        extends ChoiceRenderer<Locale> {
            private static final long serialVersionUID = -3657529581555164741L;

            private LocaleRenderer() {
            }

            public String getDisplayValue(Locale locale) {
                return locale.getDisplayName(LocaleDropDown.this.getLocale());
            }
        }
    }
}

