/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.NotificationTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.IntMappingType;
import org.apache.syncope.common.types.TraceLevel;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.Configuration;
import org.apache.syncope.console.pages.panels.LoggerCategoryPanel;
import org.apache.syncope.console.pages.panels.RoleSearchPanel;
import org.apache.syncope.console.pages.panels.UserSearchPanel;
import org.apache.syncope.console.rest.LoggerRestClient;
import org.apache.syncope.console.rest.NotificationRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;

class NotificationModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -1975312550059578553L;
    @SpringBean
    private NotificationRestClient restClient;
    @SpringBean
    private LoggerRestClient loggerRestClient;

    public NotificationModalPage(final PageReference pageRef, final ModalWindow window, final NotificationTO notificationTO, final boolean createFlag) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)notificationTO));
        AjaxTextFieldPanel sender = new AjaxTextFieldPanel("sender", this.getString("sender"), (IModel<String>)new PropertyModel((Object)notificationTO, "sender"));
        sender.addRequiredLabel();
        sender.addValidator((IValidator<? super String>)EmailAddressValidator.getInstance());
        form.add(new Component[]{sender});
        AjaxTextFieldPanel subject = new AjaxTextFieldPanel("subject", this.getString("subject"), (IModel<String>)new PropertyModel((Object)notificationTO, "subject"));
        subject.addRequiredLabel();
        form.add(new Component[]{subject});
        AjaxDropDownChoicePanel<String> template = new AjaxDropDownChoicePanel<String>("template", this.getString("template"), (IModel<String>)new PropertyModel((Object)notificationTO, "template"));
        template.setChoices(this.confRestClient.getMailTemplates());
        template.addRequiredLabel();
        form.add(new Component[]{template});
        AjaxDropDownChoicePanel<TraceLevel> traceLevel = new AjaxDropDownChoicePanel<TraceLevel>("traceLevel", this.getString("traceLevel"), (IModel<TraceLevel>)new PropertyModel((Object)notificationTO, "traceLevel"));
        traceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        traceLevel.addRequiredLabel();
        form.add(new Component[]{traceLevel});
        AjaxCheckBoxPanel isActive = new AjaxCheckBoxPanel("isActive", this.getString("isActive"), (IModel<Boolean>)new PropertyModel((Object)notificationTO, "active"));
        if (createFlag) {
            isActive.getField().setDefaultModelObject((Object)Boolean.TRUE);
        }
        form.add(new Component[]{isActive});
        final WebMarkupContainer aboutContainer = new WebMarkupContainer("aboutContainer");
        aboutContainer.setOutputMarkupId(true);
        form.add(new Component[]{aboutContainer});
        final AjaxCheckBoxPanel checkAbout = new AjaxCheckBoxPanel("checkAbout", "checkAbout", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(notificationTO.getUserAbout() == null && notificationTO.getRoleAbout() == null)));
        aboutContainer.add(new Component[]{checkAbout});
        final AjaxCheckBoxPanel checkUserAbout = new AjaxCheckBoxPanel("checkUserAbout", "checkUserAbout", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(notificationTO.getUserAbout() != null)));
        aboutContainer.add(new Component[]{checkUserAbout});
        final AjaxCheckBoxPanel checkRoleAbout = new AjaxCheckBoxPanel("checkRoleAbout", "checkRoleAbout", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(notificationTO.getRoleAbout() != null)));
        aboutContainer.add(new Component[]{checkRoleAbout});
        final UserSearchPanel userAbout = new UserSearchPanel.Builder("userAbout").fiql(notificationTO.getUserAbout()).build();
        aboutContainer.add(new Component[]{userAbout});
        userAbout.setEnabled((Boolean)checkUserAbout.getModelObject());
        final RoleSearchPanel roleAbout = new RoleSearchPanel.Builder("roleAbout").fiql(notificationTO.getRoleAbout()).build();
        aboutContainer.add(new Component[]{roleAbout});
        roleAbout.setEnabled((Boolean)checkRoleAbout.getModelObject());
        checkAbout.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (((Boolean)checkAbout.getModelObject()).booleanValue()) {
                    checkUserAbout.setModelObject(Boolean.FALSE);
                    checkRoleAbout.setModelObject(Boolean.FALSE);
                    userAbout.setEnabled(Boolean.FALSE);
                    roleAbout.setEnabled(Boolean.FALSE);
                } else {
                    checkAbout.setModelObject(Boolean.TRUE);
                }
                target.add(new Component[]{aboutContainer});
            }
        }});
        checkUserAbout.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (((Boolean)checkUserAbout.getModelObject()).booleanValue()) {
                    checkAbout.setModelObject((Object)((Boolean)checkUserAbout.getModelObject() == false ? 1 : 0));
                    checkRoleAbout.setModelObject((Object)((Boolean)checkUserAbout.getModelObject() == false ? 1 : 0));
                    roleAbout.setEnabled(Boolean.FALSE);
                } else {
                    checkUserAbout.setModelObject(Boolean.TRUE);
                }
                userAbout.setEnabled(Boolean.TRUE);
                target.add(new Component[]{aboutContainer});
            }
        }});
        checkRoleAbout.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (((Boolean)checkRoleAbout.getModelObject()).booleanValue()) {
                    checkAbout.setModelObject(Boolean.FALSE);
                    checkUserAbout.setModelObject(Boolean.FALSE);
                    userAbout.setEnabled(Boolean.FALSE);
                } else {
                    checkRoleAbout.setModelObject(Boolean.TRUE);
                }
                roleAbout.setEnabled(Boolean.TRUE);
                target.add(new Component[]{aboutContainer});
            }
        }});
        final AjaxDropDownChoicePanel recipientAttrType = new AjaxDropDownChoicePanel("recipientAttrType", new ResourceModel("recipientAttrType", "recipientAttrType").getObject(), new PropertyModel((Object)notificationTO, "recipientAttrType"));
        recipientAttrType.setChoices(new ArrayList(IntMappingType.getAttributeTypes((AttributableType)AttributableType.USER, EnumSet.of(IntMappingType.UserId, IntMappingType.Password))));
        recipientAttrType.addRequiredLabel();
        form.add(new Component[]{recipientAttrType});
        final AjaxDropDownChoicePanel<String> recipientAttrName = new AjaxDropDownChoicePanel<String>("recipientAttrName", new ResourceModel("recipientAttrName", "recipientAttrName").getObject(), (IModel<String>)new PropertyModel((Object)notificationTO, "recipientAttrName"));
        recipientAttrName.setChoices(this.getSchemaNames((IntMappingType)recipientAttrType.getModelObject()));
        recipientAttrName.addRequiredLabel();
        form.add(new Component[]{recipientAttrName});
        recipientAttrType.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                recipientAttrName.setChoices(NotificationModalPage.this.getSchemaNames((IntMappingType)recipientAttrType.getModelObject()));
                target.add(new Component[]{recipientAttrName});
            }
        }});
        form.add(new Component[]{new LoggerCategoryPanel("eventSelection", this.loggerRestClient.listEvents(), (IModel)new PropertyModel((Object)notificationTO, "events"), this.getPageReference(), "Notification"){
            private static final long serialVersionUID = 6429053774964787735L;

            @Override
            protected String[] getListRoles() {
                return new String[0];
            }

            @Override
            protected String[] getChangeRoles() {
                return new String[0];
            }
        }});
        final WebMarkupContainer recipientsContainer = new WebMarkupContainer("recipientsContainer");
        recipientsContainer.setOutputMarkupId(true);
        form.add(new Component[]{recipientsContainer});
        final AjaxCheckBoxPanel checkStaticRecipients = new AjaxCheckBoxPanel("checkStaticRecipients", "recipients", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(!notificationTO.getStaticRecipients().isEmpty())));
        form.add(new Component[]{checkStaticRecipients});
        if (createFlag) {
            checkStaticRecipients.getField().setDefaultModelObject((Object)Boolean.FALSE);
        }
        final AjaxTextFieldPanel staticRecipientsFieldPanel = new AjaxTextFieldPanel("panel", "staticRecipients", (IModel<String>)new Model(null));
        staticRecipientsFieldPanel.addValidator((IValidator<? super String>)EmailAddressValidator.getInstance());
        staticRecipientsFieldPanel.setRequired((Boolean)checkStaticRecipients.getModelObject());
        if (notificationTO.getStaticRecipients().isEmpty()) {
            notificationTO.getStaticRecipients().add(null);
        }
        final MultiFieldPanel<String> staticRecipients = new MultiFieldPanel<String>("staticRecipients", (IModel<List<String>>)new PropertyModel((Object)notificationTO, "staticRecipients"), staticRecipientsFieldPanel);
        staticRecipients.setEnabled((Boolean)checkStaticRecipients.getModelObject());
        form.add(new Component[]{staticRecipients});
        final AjaxCheckBoxPanel checkRecipients = new AjaxCheckBoxPanel("checkRecipients", "checkRecipients", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(notificationTO.getRecipients() != null)));
        recipientsContainer.add(new Component[]{checkRecipients});
        if (createFlag) {
            checkRecipients.getField().setDefaultModelObject((Object)Boolean.TRUE);
        }
        final UserSearchPanel recipients = new UserSearchPanel.Builder("recipients").fiql(notificationTO.getRecipients()).build();
        recipients.setEnabled((Boolean)checkRecipients.getModelObject());
        recipientsContainer.add(new Component[]{recipients});
        final AjaxCheckBoxPanel selfAsRecipient = new AjaxCheckBoxPanel("selfAsRecipient", this.getString("selfAsRecipient"), (IModel<Boolean>)new PropertyModel((Object)notificationTO, "selfAsRecipient"));
        form.add(new Component[]{selfAsRecipient});
        if (createFlag) {
            selfAsRecipient.getField().setDefaultModelObject((Object)Boolean.FALSE);
        }
        selfAsRecipient.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (!(((Boolean)selfAsRecipient.getModelObject()).booleanValue() || ((Boolean)checkRecipients.getModelObject()).booleanValue() || ((Boolean)checkStaticRecipients.getModelObject()).booleanValue())) {
                    checkRecipients.getField().setDefaultModelObject((Object)Boolean.TRUE);
                    target.add(new Component[]{checkRecipients});
                    recipients.setEnabled((Boolean)checkRecipients.getModelObject());
                    target.add(new Component[]{recipients});
                    target.add(new Component[]{recipientsContainer});
                }
            }
        }});
        checkRecipients.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (!(((Boolean)checkRecipients.getModelObject()).booleanValue() || ((Boolean)selfAsRecipient.getModelObject()).booleanValue() || ((Boolean)checkStaticRecipients.getModelObject()).booleanValue())) {
                    checkStaticRecipients.getField().setDefaultModelObject((Object)Boolean.TRUE);
                    target.add(new Component[]{checkStaticRecipients});
                    staticRecipients.setEnabled(Boolean.TRUE);
                    target.add(new Component[]{staticRecipients});
                    staticRecipientsFieldPanel.setRequired(Boolean.TRUE);
                    target.add(new Component[]{staticRecipientsFieldPanel});
                }
                recipients.setEnabled((Boolean)checkRecipients.getModelObject());
                target.add(new Component[]{recipients});
                target.add(new Component[]{recipientsContainer});
            }
        }});
        checkStaticRecipients.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (!(((Boolean)checkStaticRecipients.getModelObject()).booleanValue() || ((Boolean)selfAsRecipient.getModelObject()).booleanValue() || ((Boolean)checkRecipients.getModelObject()).booleanValue())) {
                    checkRecipients.getField().setDefaultModelObject((Object)Boolean.TRUE);
                    checkRecipients.setEnabled(Boolean.TRUE);
                    target.add(new Component[]{checkRecipients});
                }
                staticRecipients.setEnabled((Boolean)checkStaticRecipients.getModelObject());
                staticRecipientsFieldPanel.setRequired((Boolean)checkStaticRecipients.getModelObject());
                recipients.setEnabled((Boolean)checkRecipients.getModelObject());
                target.add(new Component[]{staticRecipientsFieldPanel});
                target.add(new Component[]{staticRecipients});
                target.add(new Component[]{recipients});
                target.add(new Component[]{recipientsContainer});
            }
        }});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                notificationTO.setUserAbout((Boolean)checkAbout.getModelObject() == false && (Boolean)checkUserAbout.getModelObject() != false ? userAbout.buildFIQL() : null);
                notificationTO.setRoleAbout((Boolean)checkAbout.getModelObject() == false && (Boolean)checkRoleAbout.getModelObject() != false ? roleAbout.buildFIQL() : null);
                notificationTO.setRecipients((Boolean)checkRecipients.getModelObject() != false ? recipients.buildFIQL() : null);
                notificationTO.getStaticRecipients().removeAll(Collections.singleton(null));
                try {
                    if (createFlag) {
                        NotificationModalPage.this.restClient.create(notificationTO);
                    } else {
                        NotificationModalPage.this.restClient.update(notificationTO);
                    }
                    this.info((Serializable)((Object)this.getString("operation_succeeded")));
                    Configuration callerPage = (Configuration)pageRef.getPage();
                    callerPage.setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientException scee) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + scee.getMessage())));
                    NotificationModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                NotificationModalPage.this.feedbackPanel.refresh(target);
            }
        };
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        String allowedRoles = createFlag ? this.xmlRolesReader.getEntitlement("Notification", "create") : this.xmlRolesReader.getEntitlement("Notification", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }

    private List<String> getSchemaNames(IntMappingType type) {
        List<String> result;
        if (type == null) {
            result = Collections.emptyList();
        } else {
            switch (type) {
                case UserSchema: {
                    result = this.schemaRestClient.getSchemaNames(AttributableType.USER);
                    break;
                }
                case UserDerivedSchema: {
                    result = this.schemaRestClient.getDerSchemaNames(AttributableType.USER);
                    break;
                }
                case UserVirtualSchema: {
                    result = this.schemaRestClient.getVirSchemaNames(AttributableType.USER);
                    break;
                }
                case Username: {
                    result = Collections.singletonList("Username");
                    break;
                }
                default: {
                    result = Collections.emptyList();
                }
            }
        }
        return result;
    }
}

