/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.syncope.common.to.AbstractPolicyTO;
import org.apache.syncope.common.to.AccountPolicyTO;
import org.apache.syncope.common.to.PasswordPolicyTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.SyncPolicyTO;
import org.apache.syncope.common.types.AbstractPolicySpec;
import org.apache.syncope.common.types.AccountPolicySpec;
import org.apache.syncope.common.types.PasswordPolicySpec;
import org.apache.syncope.common.types.PolicyType;
import org.apache.syncope.common.types.SyncPolicySpec;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.ResourceModalPage;
import org.apache.syncope.console.pages.RoleModalPage;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.pages.panels.PolicyBeanPanel;
import org.apache.syncope.console.rest.PolicyRestClient;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class PolicyModalPage<T extends AbstractPolicyTO>
extends BaseModalPage {
    private static final long serialVersionUID = -7325772767481076679L;
    private static final int WIN_HEIGHT = 600;
    private static final int WIN_WIDTH = 1100;
    @SpringBean
    private PolicyRestClient policyRestClient;

    public PolicyModalPage(PageReference pageRef, final ModalWindow window, final T policyTO) {
        Fragment fragment;
        Form form = new Form("form");
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        AjaxTextFieldPanel policyid = new AjaxTextFieldPanel("id", "id", (IModel<String>)new PropertyModel(policyTO, "id"));
        policyid.setEnabled(false);
        policyid.setStyleSheet("ui-widget-content ui-corner-all short_fixedsize");
        form.add(new Component[]{policyid});
        AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel<String>)new PropertyModel(policyTO, "description"));
        description.addRequiredLabel();
        description.setStyleSheet("ui-widget-content ui-corner-all medium_dynamicsize");
        form.add(new Component[]{description});
        AjaxDropDownChoicePanel<PolicyType> type = new AjaxDropDownChoicePanel<PolicyType>("type", "type", (IModel<PolicyType>)new PropertyModel(policyTO, "type"));
        switch (policyTO.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_ACCOUNT, PolicyType.ACCOUNT));
                break;
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_PASSWORD, PolicyType.PASSWORD));
                break;
            }
            case GLOBAL_SYNC: 
            case SYNC: {
                type.setChoices(Arrays.asList(PolicyType.GLOBAL_SYNC, PolicyType.SYNC));
            }
        }
        type.setChoiceRenderer((IChoiceRenderer)new PolicyTypeRenderer());
        type.addRequiredLabel();
        form.add(new Component[]{type});
        if (policyTO instanceof AccountPolicyTO) {
            fragment = new Fragment("forAccountOnly", "authResourcesFragment", (MarkupContainer)form);
            ArrayList<String> resourceNames = new ArrayList<String>();
            for (ResourceTO resource : this.resourceRestClient.getAll()) {
                resourceNames.add(resource.getName());
            }
            fragment.add(new Component[]{new AjaxPalettePanel("authResources", new PropertyModel(policyTO, "resources"), new ListModel(resourceNames))});
        } else {
            fragment = new Fragment("forAccountOnly", "emptyFragment", (MarkupContainer)form);
        }
        form.add(new Component[]{fragment});
        AbstractPolicySpec policy = this.getPolicySpecification((AbstractPolicyTO)policyTO);
        form.add(new Component[]{new PolicyBeanPanel("panel", policy)});
        final ModalWindow mwindow = new ModalWindow("metaEditModalWin");
        mwindow.setCssClassName("w_silver");
        mwindow.setInitialHeight(600);
        mwindow.setInitialWidth(1100);
        mwindow.setCookieName("meta-edit-modal");
        this.add(new Component[]{mwindow});
        ArrayList<AbstractColumn> resColumns = new ArrayList<AbstractColumn>();
        resColumns.add(new AbstractColumn<String, String>((IModel)new StringResourceModel("name", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (String)rowModel.getObject())});
            }
        });
        resColumns.add(new AbstractColumn<String, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<String>> cellItem, String componentId, IModel<String> model) {
                final String resource = (String)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, PolicyModalPage.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        mwindow.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ResourceModalPage(PolicyModalPage.this.getPageReference(), mwindow, PolicyModalPage.this.resourceRestClient.read(resource), false);
                            }
                        });
                        mwindow.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Resources");
                cellItem.add(new Component[]{panel});
            }
        });
        SortableDataProvider<String, String> resDataProvider = new SortableDataProvider<String, String>(){
            private static final long serialVersionUID = 8263758912838836438L;

            public Iterator<? extends String> iterator(long first, long count) {
                return policyTO.getId() == 0L ? Collections.emptyList().iterator() : PolicyModalPage.this.policyRestClient.getPolicy(policyTO.getId()).getUsedByResources().subList((int)first, (int)first + (int)count).iterator();
            }

            public long size() {
                return policyTO.getId() == 0L ? 0L : (long)PolicyModalPage.this.policyRestClient.getPolicy(policyTO.getId()).getUsedByResources().size();
            }

            public IModel<String> model(String object) {
                return new Model((Serializable)((Object)object));
            }
        };
        final AjaxFallbackDefaultDataTable resources = new AjaxFallbackDefaultDataTable("resources", resColumns, (ISortableDataProvider)resDataProvider, 10);
        form.add(new Component[]{resources});
        ArrayList<Object> roleColumns = new ArrayList<Object>();
        roleColumns.add(new PropertyColumn((IModel)new ResourceModel("id", "id"), (Object)"id", "id"));
        roleColumns.add(new PropertyColumn((IModel)new ResourceModel("name", "name"), (Object)"name", "name"));
        roleColumns.add(new AbstractColumn<RoleTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<RoleTO>> cellItem, String componentId, IModel<RoleTO> model) {
                final RoleTO role = (RoleTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, PolicyModalPage.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        mwindow.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new RoleModalPage(PolicyModalPage.this.getPageReference(), mwindow, role);
                            }
                        });
                        mwindow.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Roles");
                cellItem.add(new Component[]{panel});
            }
        });
        SortableDataProvider<RoleTO, String> roleDataProvider = new SortableDataProvider<RoleTO, String>(){
            private static final long serialVersionUID = 8263758912838836438L;

            public Iterator<? extends RoleTO> iterator(long first, long count) {
                ArrayList<RoleTO> roles = new ArrayList<RoleTO>();
                if (policyTO.getId() > 0L) {
                    for (Long roleId : PolicyModalPage.this.policyRestClient.getPolicy(policyTO.getId()).getUsedByRoles().subList((int)first, (int)first + (int)count)) {
                        roles.add(PolicyModalPage.this.roleRestClient.read(roleId));
                    }
                }
                return roles.iterator();
            }

            public long size() {
                return policyTO.getId() == 0L ? 0L : (long)PolicyModalPage.this.policyRestClient.getPolicy(policyTO.getId()).getUsedByRoles().size();
            }

            public IModel<RoleTO> model(RoleTO object) {
                return new Model((Serializable)object);
            }
        };
        final AjaxFallbackDefaultDataTable roles = new AjaxFallbackDefaultDataTable("roles", roleColumns, (ISortableDataProvider)roleDataProvider, 10);
        form.add(new Component[]{roles});
        mwindow.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{resources});
                target.add(new Component[]{roles});
                if (PolicyModalPage.this.isModalResult()) {
                    PolicyModalPage.this.info((Serializable)((Object)PolicyModalPage.this.getString("operation_succeeded")));
                    PolicyModalPage.this.feedbackPanel.refresh(target);
                    PolicyModalPage.this.setModalResult(false);
                }
            }
        });
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("apply"), (AbstractPolicyTO)policyTO, policy, pageRef, window){
            private static final long serialVersionUID = -958724007591692537L;
            final /* synthetic */ AbstractPolicyTO val$policyTO;
            final /* synthetic */ AbstractPolicySpec val$policy;
            final /* synthetic */ PageReference val$pageRef;
            final /* synthetic */ ModalWindow val$window;
            {
                this.val$policyTO = abstractPolicyTO;
                this.val$policy = abstractPolicySpec;
                this.val$pageRef = pageReference;
                this.val$window = modalWindow;
                super(x0, x1);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                PolicyModalPage.this.setPolicySpecification(this.val$policyTO, this.val$policy);
                try {
                    if (this.val$policyTO.getId() > 0L) {
                        PolicyModalPage.this.policyRestClient.updatePolicy(this.val$policyTO);
                    } else {
                        PolicyModalPage.this.policyRestClient.createPolicy(this.val$policyTO);
                    }
                    ((BasePage)this.val$pageRef.getPage()).setModalResult(true);
                    this.val$window.close(target);
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("While creating policy", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    ((NotificationPanel)this.getPage().get("feedback")).refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ((NotificationPanel)this.getPage().get("feedback")).refresh(target);
            }
        };
        form.add(new Component[]{submit});
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    private AbstractPolicySpec getPolicySpecification(AbstractPolicyTO policyTO) {
        AccountPolicySpec spec;
        switch (policyTO.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                spec = ((AccountPolicyTO)policyTO).getSpecification() != null ? ((AccountPolicyTO)policyTO).getSpecification() : new AccountPolicySpec();
                break;
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                spec = ((PasswordPolicyTO)policyTO).getSpecification() != null ? ((PasswordPolicyTO)policyTO).getSpecification() : new PasswordPolicySpec();
                break;
            }
            default: {
                spec = ((SyncPolicyTO)policyTO).getSpecification() != null ? ((SyncPolicyTO)policyTO).getSpecification() : new SyncPolicySpec();
            }
        }
        return spec;
    }

    private void setPolicySpecification(AbstractPolicyTO policyTO, AbstractPolicySpec specification) {
        switch (policyTO.getType()) {
            case GLOBAL_ACCOUNT: 
            case ACCOUNT: {
                if (!(specification instanceof AccountPolicySpec)) {
                    throw new ClassCastException("policy is type Account, but spec is not: " + specification.getClass().getName());
                }
                ((AccountPolicyTO)policyTO).setSpecification((AccountPolicySpec)specification);
                break;
            }
            case GLOBAL_PASSWORD: 
            case PASSWORD: {
                if (!(specification instanceof PasswordPolicySpec)) {
                    throw new ClassCastException("policy is type Password, but spec is not: " + specification.getClass().getName());
                }
                ((PasswordPolicyTO)policyTO).setSpecification((PasswordPolicySpec)specification);
                break;
            }
            case GLOBAL_SYNC: 
            case SYNC: {
                if (!(specification instanceof SyncPolicySpec)) {
                    throw new ClassCastException("policy is type Sync, but spec is not: " + specification.getClass().getName());
                }
                ((SyncPolicyTO)policyTO).setSpecification((SyncPolicySpec)specification);
            }
        }
    }

    private class PolicyTypeRenderer
    extends ChoiceRenderer<PolicyType> {
        private static final long serialVersionUID = -8993265421104002134L;

        private PolicyTypeRenderer() {
        }

        public Object getDisplayValue(PolicyType object) {
            return PolicyModalPage.this.getString(object.name());
        }
    }
}

