/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.syncope.client.SyncopeClient;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.wrap.AbstractWrappable;
import org.apache.syncope.common.wrap.SubjectId;
import org.apache.syncope.console.commons.status.AbstractStatusBeanProvider;
import org.apache.syncope.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.AbstractStatusModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.BulkActionResultModalPage;
import org.apache.syncope.console.pages.panels.ActionDataTablePanel;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class ProvisioningModalPage<T extends AbstractAttributableTO>
extends AbstractStatusModalPage {
    private static final long serialVersionUID = -4285220460543213901L;
    private static final int ROWS_PER_PAGE = 10;
    private final ResourceTO resourceTO;
    private final Class<? extends AbstractAttributableTO> typeRef;
    private final PageReference pageRef;
    private final ModalWindow window;
    private final StatusUtils statusUtils;

    public ProvisioningModalPage(PageReference pageRef, ModalWindow window, ResourceTO resourceTO, Class<T> typeRef) {
        this.pageRef = pageRef;
        this.window = window;
        this.resourceTO = resourceTO;
        this.typeRef = typeRef;
        this.statusUtils = new StatusUtils(UserTO.class.isAssignableFrom(typeRef) ? this.userRestClient : this.roleRestClient);
        final ArrayList columns = new ArrayList();
        columns.add(new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, "Attributable id", new Object[0]), (Object)"attributableId", "attributableId"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("name", (Component)this, null, "Attributable name", new Object[0]), (Object)"attributableName", "attributableName"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("resourceName", (Component)this, null, "Resource name", new Object[0]), (Object)"resourceName", "resourceName"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("accountLink", (Component)this, null, "Account link", new Object[0]), (Object)"accountLink", "accountLink"));
        columns.add(new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("status", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = -3503023501954863131L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, IModel<StatusBean> model) {
                cellItem.add(new Component[]{ProvisioningModalPage.this.statusUtils.getStatusImagePanel(componentId, ((StatusBean)model.getObject()).getStatus())});
            }
        });
        final ActionDataTablePanel table = new ActionDataTablePanel("resourceDatatable", columns, new StatusBeanProvider(), 10, pageRef);
        String pageId = "Resources";
        table.addAction(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                try {
                    ProvisioningModalPage.this.bulkAssociationAction(target, ResourceDeassociationActionType.UNLINK, table, columns);
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("Error unlinkink resources", (Throwable)e);
                    ProvisioningModalPage.this.error((Serializable)((Object)(ProvisioningModalPage.this.getString("error") + ": " + e.getMessage())));
                    ProvisioningModalPage.this.feedbackPanel.refresh(target);
                }
            }
        }, ActionLink.ActionType.UNLINK, "Resources");
        table.addAction(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                try {
                    ProvisioningModalPage.this.bulkAssociationAction(target, ResourceDeassociationActionType.DEPROVISION, table, columns);
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("Error de-provisioning user", (Throwable)e);
                    ProvisioningModalPage.this.error((Serializable)((Object)(ProvisioningModalPage.this.getString("error") + ": " + e.getMessage())));
                    ProvisioningModalPage.this.feedbackPanel.refresh(target);
                }
            }
        }, ActionLink.ActionType.DEPROVISION, "Resources");
        table.addAction(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                try {
                    ProvisioningModalPage.this.bulkAssociationAction(target, ResourceDeassociationActionType.UNASSIGN, table, columns);
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("Error unassigning resources", (Throwable)e);
                    ProvisioningModalPage.this.error((Serializable)((Object)(ProvisioningModalPage.this.getString("error") + ": " + e.getMessage())));
                    ProvisioningModalPage.this.feedbackPanel.refresh(target);
                }
            }
        }, ActionLink.ActionType.UNASSIGN, "Resources");
        table.addCancelButton(window);
        this.add(new Component[]{table});
    }

    private void bulkAssociationAction(AjaxRequestTarget target, ResourceDeassociationActionType type, ActionDataTablePanel<StatusBean, String> table, List<IColumn<StatusBean, String>> columns) {
        ArrayList<StatusBean> beans = new ArrayList<StatusBean>(table.getModelObject());
        ArrayList<SubjectId> subjectIds = new ArrayList<SubjectId>();
        for (StatusBean bean : beans) {
            LOG.debug("Selected bean {}", (Object)bean);
            subjectIds.add((SubjectId)AbstractWrappable.getInstance(SubjectId.class, (Object)bean.getAttributableId()));
        }
        if (beans.isEmpty()) {
            this.window.close(target);
        } else {
            BulkActionResult res = this.resourceRestClient.bulkAssociationAction(this.resourceTO.getName(), this.typeRef, type, subjectIds);
            ((BasePage)this.pageRef.getPage()).setModalResult(true);
            this.setResponsePage((Page)new BulkActionResultModalPage(this.window, beans, columns, res, "attributableId"));
        }
    }

    private class StatusBeanProvider
    extends AbstractStatusBeanProvider {
        private static final long serialVersionUID = 4287357360778016173L;

        public StatusBeanProvider() {
            super("accountLink");
        }

        @Override
        public List<StatusBean> getStatusBeans() {
            String fiql = SyncopeClient.getUserSearchConditionBuilder().hasResources(ProvisioningModalPage.this.resourceTO.getName(), new String[0]).query();
            ArrayList<AbstractSubjectTO> subjects = new ArrayList<AbstractSubjectTO>();
            if (UserTO.class.isAssignableFrom(ProvisioningModalPage.this.typeRef)) {
                subjects.addAll(ProvisioningModalPage.this.userRestClient.search(fiql, 1, 10, (SortParam<String>)new SortParam((Object)"id", true)));
            } else {
                subjects.addAll(ProvisioningModalPage.this.roleRestClient.search(fiql, 1, 10, (SortParam<String>)new SortParam((Object)"id", true)));
            }
            List<ConnObjectWrapper> connObjects = ProvisioningModalPage.this.statusUtils.getConnectorObjects(subjects, Collections.singleton(ProvisioningModalPage.this.resourceTO.getName()));
            ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size() + 1);
            LinkedHashMap<String, StatusBean> initialStatusBeanMap = new LinkedHashMap<String, StatusBean>(connObjects.size());
            for (ConnObjectWrapper entry : connObjects) {
                StatusBean statusBean = ProvisioningModalPage.this.statusUtils.getStatusBean(entry.getAttributable(), entry.getResourceName(), entry.getConnObjectTO(), RoleTO.class.isAssignableFrom(ProvisioningModalPage.this.typeRef));
                initialStatusBeanMap.put(entry.getResourceName(), statusBean);
                statusBeans.add(statusBean);
            }
            return statusBeans;
        }
    }
}

