/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.common.to.AbstractSyncTaskTO;
import org.apache.syncope.common.to.PushTaskTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.common.types.MatchingRule;
import org.apache.syncope.common.types.UnmatchingRule;
import org.apache.syncope.console.pages.AbstractSyncTaskModalPage;
import org.apache.syncope.console.pages.panels.RoleSearchPanel;
import org.apache.syncope.console.pages.panels.UserSearchPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class PushTaskModalPage
extends AbstractSyncTaskModalPage {
    private static final long serialVersionUID = 2148403203517274669L;
    private final UserSearchPanel userFilter;
    private final RoleSearchPanel roleFilter;
    private final AjaxCheckBoxPanel checkUserFilter;
    private final AjaxCheckBoxPanel checkRoleFilter;

    @Override
    protected List<String> getSyncActions() {
        return this.taskRestClient.getPushActionsClasses();
    }

    public PushTaskModalPage(ModalWindow window, PushTaskTO taskTO, PageReference pageRef) {
        super(window, (AbstractSyncTaskTO)taskTO, pageRef);
        ((DropDownChoice)this.matchingRule.getField()).setDefaultModelObject((Object)(taskTO.getMatchingRule() == null ? MatchingRule.UPDATE : taskTO.getMatchingRule()));
        this.profile.add(new Component[]{this.matchingRule});
        ((DropDownChoice)this.unmatchingRule.getField()).setDefaultModelObject((Object)(taskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : taskTO.getUnmatchingRule()));
        this.profile.add(new Component[]{this.unmatchingRule});
        final WebMarkupContainer filterContainer = new WebMarkupContainer("filterContainer");
        filterContainer.setOutputMarkupId(true);
        this.checkUserFilter = new AjaxCheckBoxPanel("checkUserFilter", "checkUserFilter", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(taskTO.getUserFilter() != null)));
        filterContainer.add(new Component[]{this.checkUserFilter});
        this.checkRoleFilter = new AjaxCheckBoxPanel("checkRoleFilter", "checkRoleFilter", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(taskTO.getRoleFilter() != null)));
        filterContainer.add(new Component[]{this.checkRoleFilter});
        this.userFilter = new UserSearchPanel.Builder("userFilter").fiql(taskTO.getUserFilter()).build();
        this.userFilter.setEnabled((Boolean)this.checkUserFilter.getModelObject());
        filterContainer.add(new Component[]{this.userFilter});
        this.roleFilter = new RoleSearchPanel.Builder("roleFilter").fiql(taskTO.getRoleFilter()).build();
        this.roleFilter.setEnabled((Boolean)this.checkRoleFilter.getModelObject());
        filterContainer.add(new Component[]{this.roleFilter});
        this.checkUserFilter.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PushTaskModalPage.this.userFilter.setEnabled((Boolean)PushTaskModalPage.this.checkUserFilter.getModelObject());
                target.add(new Component[]{filterContainer});
            }
        }});
        this.checkRoleFilter.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PushTaskModalPage.this.roleFilter.setEnabled((Boolean)PushTaskModalPage.this.checkRoleFilter.getModelObject());
                target.add(new Component[]{filterContainer});
            }
        }});
        this.profile.add(new Component[]{filterContainer});
    }

    @Override
    public void submitAction(SchedTaskTO taskTO) {
        this.setFilters((PushTaskTO)taskTO);
        if (taskTO.getId() > 0L) {
            this.taskRestClient.updateSchedTask((SchedTaskTO)((PushTaskTO)taskTO));
        } else {
            this.taskRestClient.createSchedTask((SchedTaskTO)((PushTaskTO)taskTO));
        }
    }

    private void setFilters(PushTaskTO pushTaskTO) {
        pushTaskTO.setUserFilter((Boolean)this.checkUserFilter.getModelObject() != false ? this.userFilter.buildFIQL() : null);
        pushTaskTO.setRoleFilter((Boolean)this.checkRoleFilter.getModelObject() != false ? this.roleFilter.buildFIQL() : null);
    }
}

