/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.report.AbstractReportletConf;
import org.apache.syncope.common.report.ReportletConf;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.common.types.ReportExecExportFormat;
import org.apache.syncope.common.types.ReportExecStatus;
import org.apache.syncope.console.commons.DateFormatROModel;
import org.apache.syncope.console.commons.HttpResourceStream;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.markup.html.CrontabContainer;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.ExecMessageModalPage;
import org.apache.syncope.console.pages.ReportExecResultDownloadModalPage;
import org.apache.syncope.console.pages.ReportletConfModalPage;
import org.apache.syncope.console.wicket.ajax.form.AbstractAjaxDownloadBehavior;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListChoice;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.resource.IResourceStream;
import org.springframework.util.StringUtils;

public class ReportModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -5747628615211127644L;
    private static final String ADD_BUTTON_ID = "addButton";
    private static final String EDIT_BUTTON_ID = "editButton";
    private static final String REMOVE_BUTTON_ID = "removeButton";
    private static final String UP_BUTTON_ID = "upButton";
    private static final String DOWN_BUTTON_ID = "downButton";
    private static final int EXEC_EXPORT_WIN_HEIGHT = 100;
    private static final int EXEC_EXPORT_WIN_WIDTH = 400;
    private static final int REPORTLET_CONF_WIN_HEIGHT = 500;
    private static final int REPORTLET_CONF_WIN_WIDTH = 800;
    private final ReportTO reportTO;
    private final Form<ReportTO> form;
    private ReportExecExportFormat exportFormat;
    private long exportExecId;
    private AbstractReportletConf modalReportletConf;
    private String modalReportletConfOldName;
    private ListChoice<AbstractReportletConf> reportlets;

    public ReportModalPage(final ModalWindow window, ReportTO reportTO, final PageReference callerPageRef) {
        this.reportTO = reportTO;
        this.form = new Form("form");
        this.form.setModel((IModel)new CompoundPropertyModel((Object)reportTO));
        this.add(new Component[]{this.form});
        this.setupProfile();
        this.setupExecutions();
        final CrontabContainer crontab = new CrontabContainer("crontab", (PropertyModel<String>)new PropertyModel((Object)reportTO, "cronExpression"), reportTO.getCronExpression());
        this.form.add(new Component[]{crontab});
        ClearIndicatingAjaxButton submit = new ClearIndicatingAjaxButton("apply", (IModel)new ResourceModel("apply"), this.getPageReference()){
            private static final long serialVersionUID = -958724007591692537L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                ReportTO toSubmit;
                toSubmit.setCronExpression(StringUtils.hasText((String)(toSubmit = (ReportTO)form.getModelObject()).getCronExpression()) ? crontab.getCronExpression() : null);
                try {
                    if (toSubmit.getId() > 0L) {
                        ReportModalPage.this.reportRestClient.update(toSubmit);
                    } else {
                        ReportModalPage.this.reportRestClient.create(toSubmit);
                    }
                    ((BasePage)callerPageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientException e) {
                    AbstractBasePage.LOG.error("While creating or updating report", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    ReportModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ReportModalPage.this.feedbackPanel.refresh(target);
            }
        };
        if (reportTO.getId() > 0L) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "update"));
        } else {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "create"));
        }
        this.form.add(new Component[]{submit});
        ClearIndicatingAjaxButton cancel = new ClearIndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel"), this.getPageReference()){
            private static final long serialVersionUID = -958724007591692537L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        this.form.add(new Component[]{cancel});
    }

    private void setupProfile() {
        WebMarkupContainer profile = new WebMarkupContainer("profile");
        profile.setOutputMarkupId(true);
        this.form.add(new Component[]{profile});
        final ModalWindow reportletConfWin = new ModalWindow("reportletConfWin");
        reportletConfWin.setCssClassName("w_silver");
        reportletConfWin.setCookieName("reportlet-conf-win-modal");
        reportletConfWin.setInitialHeight(500);
        reportletConfWin.setInitialWidth(800);
        reportletConfWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                int foundIdx = -1;
                if (ReportModalPage.this.modalReportletConfOldName != null) {
                    for (int i = 0; i < ReportModalPage.this.reportTO.getReportletConfs().size() && foundIdx == -1; ++i) {
                        if (!((AbstractReportletConf)ReportModalPage.this.reportTO.getReportletConfs().get(i)).getName().equals(ReportModalPage.this.modalReportletConfOldName)) continue;
                        foundIdx = i;
                    }
                }
                if (ReportModalPage.this.modalReportletConf != null) {
                    if (foundIdx == -1) {
                        ReportModalPage.this.reportTO.getReportletConfs().add(ReportModalPage.this.modalReportletConf);
                    } else {
                        ReportModalPage.this.reportTO.getReportletConfs().set(foundIdx, ReportModalPage.this.modalReportletConf);
                    }
                }
                target.add(new Component[]{ReportModalPage.this.reportlets});
            }
        });
        this.add(new Component[]{reportletConfWin});
        Label idLabel = new Label("idLabel", (IModel)new ResourceModel("id"));
        profile.add(new Component[]{idLabel});
        AjaxTextFieldPanel id = new AjaxTextFieldPanel("id", this.getString("id"), (IModel<String>)new PropertyModel((Object)this.reportTO, "id"));
        id.setEnabled(false);
        profile.add(new Component[]{id});
        Label nameLabel = new Label("nameLabel", (IModel)new ResourceModel("name"));
        profile.add(new Component[]{nameLabel});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel<String>)new PropertyModel((Object)this.reportTO, "name"));
        profile.add(new Component[]{name});
        AjaxTextFieldPanel lastExec = new AjaxTextFieldPanel("lastExec", this.getString("lastExec"), new DateFormatROModel(new PropertyModel((Object)this.reportTO, "lastExec")));
        lastExec.setEnabled(false);
        profile.add(new Component[]{lastExec});
        AjaxTextFieldPanel nextExec = new AjaxTextFieldPanel("nextExec", this.getString("nextExec"), new DateFormatROModel(new PropertyModel((Object)this.reportTO, "nextExec")));
        nextExec.setEnabled(false);
        profile.add(new Component[]{nextExec});
        this.reportlets = new ListChoice<AbstractReportletConf>("reportletConfs", (IModel)new Model(), this.reportTO.getReportletConfs(), (IChoiceRenderer)new IChoiceRenderer<ReportletConf>(){
            private static final long serialVersionUID = 1048000918946220007L;

            public Object getDisplayValue(ReportletConf object) {
                return object.getName();
            }

            public String getIdValue(ReportletConf object, int index) {
                return object.getName();
            }
        }){
            private static final long serialVersionUID = 4022366881854379834L;

            protected CharSequence getDefaultChoice(String selectedValue) {
                return null;
            }
        };
        this.reportlets.setNullValid(true);
        profile.add(new Component[]{this.reportlets});
        this.reportlets.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{ReportModalPage.this.reportlets});
            }
        }});
        profile.add(new Component[]{new AjaxLink<Void>(ADD_BUTTON_ID){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                reportletConfWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        ReportModalPage.this.modalReportletConfOldName = null;
                        ReportModalPage.this.modalReportletConf = null;
                        return new ReportletConfModalPage(null, reportletConfWin, ReportModalPage.this.getPageReference());
                    }
                });
                reportletConfWin.show(target);
            }
        }});
        profile.add(new Component[]{new AjaxLink<Void>(EDIT_BUTTON_ID){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                if (ReportModalPage.this.reportlets.getModelObject() != null) {
                    reportletConfWin.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = -7834632442532690940L;

                        public Page createPage() {
                            ReportModalPage.this.modalReportletConfOldName = ((AbstractReportletConf)ReportModalPage.this.reportlets.getModelObject()).getName();
                            ReportModalPage.this.modalReportletConf = null;
                            return new ReportletConfModalPage((AbstractReportletConf)ReportModalPage.this.reportlets.getModelObject(), reportletConfWin, ReportModalPage.this.getPageReference());
                        }
                    });
                    reportletConfWin.show(target);
                }
            }
        }});
        profile.add(new Component[]{new AjaxLink<Void>(REMOVE_BUTTON_ID){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                ReportModalPage.this.reportTO.getReportletConfs().remove(ReportModalPage.this.reportlets.getModelObject());
                ReportModalPage.this.reportlets.setModelObject(null);
                target.add(new Component[]{ReportModalPage.this.reportlets});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                if (ReportModalPage.this.reportlets.getModelObject() != null) {
                    super.updateAjaxAttributes(attributes);
                    AjaxCallListener ajaxCallListener = new AjaxCallListener(){
                        private static final long serialVersionUID = 7160235486520935153L;

                        public CharSequence getPrecondition(Component component) {
                            return "if (!confirm('" + this.getString("confirmDelete") + "')) {return false;}";
                        }
                    };
                    attributes.getAjaxCallListeners().add(ajaxCallListener);
                }
            }
        }});
        profile.add(new Component[]{new AjaxLink<Void>(UP_BUTTON_ID){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                if (ReportModalPage.this.reportlets.getModelObject() != null) {
                    ReportModalPage.this.moveUp((AbstractReportletConf)ReportModalPage.this.reportlets.getModelObject());
                    target.add(new Component[]{ReportModalPage.this.reportlets});
                }
            }
        }});
        profile.add(new Component[]{new AjaxLink<Void>(DOWN_BUTTON_ID){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                if (ReportModalPage.this.reportlets.getModelObject() != null) {
                    ReportModalPage.this.moveDown((AbstractReportletConf)ReportModalPage.this.reportlets.getModelObject());
                    target.add(new Component[]{ReportModalPage.this.reportlets});
                }
            }
        }});
    }

    private void moveUp(AbstractReportletConf item) {
        List list = this.reportTO.getReportletConfs();
        int newPosition = list.indexOf(item) - 1;
        if (newPosition > -1) {
            list.remove(item);
            list.add(newPosition, item);
        }
    }

    private void moveDown(AbstractReportletConf item) {
        List list = this.reportTO.getReportletConfs();
        int newPosition = list.indexOf(item) + 1;
        if (newPosition < list.size()) {
            list.remove(item);
            list.add(newPosition, item);
        }
    }

    private void setupExecutions() {
        final WebMarkupContainer executions = new WebMarkupContainer("executionContainer");
        executions.setOutputMarkupId(true);
        this.form.add(new Component[]{executions});
        final ModalWindow reportExecMessageWin = new ModalWindow("reportExecMessageWin");
        reportExecMessageWin.setCssClassName("w_silver");
        reportExecMessageWin.setCookieName("report-exec-message-win-modal");
        this.add(new Component[]{reportExecMessageWin});
        final ModalWindow reportExecExportWin = new ModalWindow("reportExecExportWin");
        reportExecExportWin.setCssClassName("w_silver");
        reportExecExportWin.setCookieName("report-exec-export-win-modal");
        reportExecExportWin.setInitialHeight(100);
        reportExecExportWin.setInitialWidth(400);
        reportExecExportWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                AjaxExportDownloadBehavior behavior = new AjaxExportDownloadBehavior(ReportModalPage.this.exportFormat, ReportModalPage.this.exportExecId);
                executions.add(new Behavior[]{behavior});
                behavior.initiate(target);
            }
        });
        this.add(new Component[]{reportExecExportWin});
        final ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("startDate"), "startDate", "startDate"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("endDate"), "endDate", "endDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("status"), (Object)"status", "status"));
        columns.add(new ActionColumn<ReportExecTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public ActionLinksPanel getActions(String componentId, final IModel<ReportExecTO> model) {
                final ReportExecTO taskExecutionTO = (ReportExecTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, ReportModalPage.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        reportExecMessageWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ExecMessageModalPage(((ReportExecTO)model.getObject()).getMessage());
                            }
                        });
                        reportExecMessageWin.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Reports", StringUtils.hasText((String)((ReportExecTO)model.getObject()).getMessage()));
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        reportExecExportWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                ReportModalPage.this.exportExecId = ((ReportExecTO)model.getObject()).getId();
                                return new ReportExecResultDownloadModalPage(reportExecExportWin, ReportModalPage.this.getPageReference());
                            }
                        });
                        reportExecExportWin.show(target);
                    }
                }, ActionLink.ActionType.EXPORT, "Reports", ReportExecStatus.SUCCESS.name().equals(((ReportExecTO)model.getObject()).getStatus()));
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            ReportModalPage.this.reportRestClient.deleteExecution(taskExecutionTO.getId());
                            ReportModalPage.this.reportTO.getExecutions().remove(taskExecutionTO);
                            ReportModalPage.this.info((Serializable)((Object)ReportModalPage.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            ReportModalPage.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        ReportModalPage.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{executions});
                    }
                }, ActionLink.ActionType.DELETE, "Reports");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), ReportModalPage.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            ReportTO currentReportTO = ReportModalPage.this.reportTO.getId() == 0L ? ReportModalPage.this.reportTO : ReportModalPage.this.reportRestClient.read(ReportModalPage.this.reportTO.getId());
                            ReportModalPage.this.reportTO.getExecutions().clear();
                            ReportModalPage.this.reportTO.getExecutions().addAll(currentReportTO.getExecutions());
                            AjaxFallbackDefaultDataTable currentTable = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new ReportExecutionsProvider(ReportModalPage.this.reportTO), 10);
                            currentTable.setOutputMarkupId(true);
                            target.add(new Component[]{currentTable});
                            executions.addOrReplace(new Component[]{currentTable});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new ReportExecutionsProvider(this.reportTO), 10);
        executions.add(new Component[]{table});
    }

    public void setExportFormat(ReportExecExportFormat exportFormat) {
        this.exportFormat = exportFormat;
    }

    public void setModalReportletConf(AbstractReportletConf modalReportletConf) {
        this.modalReportletConf = modalReportletConf;
    }

    private class AjaxExportDownloadBehavior
    extends AbstractAjaxDownloadBehavior {
        private static final long serialVersionUID = 3109256773218160485L;
        private final ReportExecExportFormat exportFormat;
        private final long exportExecId;
        private HttpResourceStream stream;

        public AjaxExportDownloadBehavior(ReportExecExportFormat exportFormat, long exportExecId) {
            this.exportFormat = exportFormat;
            this.exportExecId = exportExecId;
        }

        private void createResourceStream() {
            if (this.stream == null) {
                this.stream = new HttpResourceStream(ReportModalPage.this.reportRestClient.exportExecutionResult(this.exportExecId, this.exportFormat));
            }
        }

        @Override
        protected String getFileName() {
            this.createResourceStream();
            return this.stream == null ? null : this.stream.getFilename();
        }

        @Override
        protected IResourceStream getResourceStream() {
            this.createResourceStream();
            return this.stream;
        }
    }

    private static class ReportExecutionsProvider
    extends SortableDataProvider<ReportExecTO, String> {
        private static final long serialVersionUID = 2118096121691420539L;
        private final SortableDataProviderComparator<ReportExecTO> comparator;
        private final ReportTO reportTO;

        public ReportExecutionsProvider(ReportTO reportTO) {
            this.reportTO = reportTO;
            this.setSort("startDate", SortOrder.DESCENDING);
            this.comparator = new SortableDataProviderComparator<ReportExecTO>(this);
        }

        public Iterator<ReportExecTO> iterator(long first, long count) {
            List list = this.reportTO.getExecutions();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.reportTO.getExecutions().size();
        }

        public IModel<ReportExecTO> model(final ReportExecTO taskExecution) {
            return new AbstractReadOnlyModel<ReportExecTO>(){
                private static final long serialVersionUID = 7485475149862342421L;

                public ReportExecTO getObject() {
                    return taskExecution;
                }
            };
        }
    }
}

