/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.annotation.FormAttributeField;
import org.apache.syncope.common.report.AbstractReportletConf;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.ReportModalPage;
import org.apache.syncope.console.pages.panels.RoleSearchPanel;
import org.apache.syncope.console.pages.panels.UserSearchPanel;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.CheckBoxMultipleChoiceFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.ClassUtils;

public class ReportletConfModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 3910027601200382958L;
    private static final String[] EXCLUDE_PROPERTIES = new String[]{"serialVersionUID", "class", "name", "reportletClassName"};
    private AbstractReportletConf reportletConf;
    private final AjaxTextFieldPanel name;
    private WebMarkupContainer propertiesContainer;
    private ListView<String> propView;

    public ReportletConfModalPage(AbstractReportletConf reportletConf, final ModalWindow window, final PageReference pageRef) {
        this.reportletConf = reportletConf;
        Form form = new Form("form");
        this.add(new Component[]{form});
        this.propertiesContainer = new WebMarkupContainer("container");
        this.propertiesContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.propertiesContainer});
        this.name = new AjaxTextFieldPanel("name", "name", (IModel<String>)(this.reportletConf == null ? new Model() : new PropertyModel((Object)this.reportletConf, "name")));
        this.name.setOutputMarkupId(true);
        this.name.addRequiredLabel();
        form.add(new Component[]{this.name});
        final AjaxDropDownChoicePanel<String> reportletClass = new AjaxDropDownChoicePanel<String>("reportletClass", "reportletClass", new IModel<String>(){
            private static final long serialVersionUID = -2316468110411802130L;

            public String getObject() {
                return ReportletConfModalPage.this.reportletConf == null ? null : ReportletConfModalPage.this.reportletConf.getClass().getName();
            }

            public void setObject(String object) {
                try {
                    Class<?> reportletClass = Class.forName(object);
                    ReportletConfModalPage.this.reportletConf = (AbstractReportletConf)reportletClass.newInstance();
                    ReportletConfModalPage.this.propertiesContainer.replace((Component)ReportletConfModalPage.this.buildPropView());
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("Cannot find or initialize {}", (Object)object, (Object)e);
                }
            }

            public void detach() {
            }
        });
        reportletClass.setStyleSheet("long_dynamicsize");
        reportletClass.setChoices(this.reportRestClient.getReportletConfClasses());
        ((DropDownChoice)reportletClass.getField()).setNullValid(true);
        reportletClass.addRequiredLabel();
        reportletClass.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 5538299138211283825L;

            protected void onUpdate(AjaxRequestTarget target) {
                ((DropDownChoice)reportletClass.getField()).setNullValid(false);
                target.add(new Component[]{reportletClass.getField()});
                target.add(new Component[]{ReportletConfModalPage.this.propertiesContainer});
            }
        }});
        form.add(new Component[]{reportletClass});
        this.propertiesContainer.add(new Component[]{this.buildPropView()});
        AjaxButton submit = new AjaxButton("apply", (IModel)new ResourceModel("apply")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                final BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)ReportletConfModalPage.this.reportletConf);
                wrapper.setPropertyValue("name", (Object)ReportletConfModalPage.this.name.getField().getInput());
                ReportletConfModalPage.this.propView.visitChildren((IVisitor)new IVisitor<Component, Void>(){

                    public void component(Component component, IVisit<Void> ivisit) {
                        if (component instanceof UserSearchPanel) {
                            wrapper.setPropertyValue(component.getDefaultModelObjectAsString(), (Object)((UserSearchPanel)component).buildFIQL());
                        }
                    }
                });
                ((ReportModalPage)pageRef.getPage()).setModalReportletConf(ReportletConfModalPage.this.reportletConf);
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ReportletConfModalPage.this.feedbackPanel.refresh(target);
            }
        };
        form.add(new Component[]{submit});
        ClearIndicatingAjaxButton cancel = new ClearIndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel"), pageRef){
            private static final long serialVersionUID = -958724007591692537L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }

    private FieldPanel buildSinglePanel(Class<?> type, String fieldName, String id) {
        FieldPanel result = null;
        PropertyModel model = new PropertyModel((Object)this.reportletConf, fieldName);
        if (ClassUtils.isAssignable(Boolean.class, type)) {
            result = new AjaxCheckBoxPanel(id, fieldName, (IModel<Boolean>)model);
        } else if (ClassUtils.isAssignable(Number.class, type)) {
            result = new SpinnerFieldPanel<Object>(id, fieldName, ClassUtils.resolvePrimitiveIfNecessary(type), (IModel<Object>)model, null, null);
        } else if (Date.class.equals(type)) {
            result = new DateTimeFieldPanel(id, fieldName, (IModel<Date>)model, "yyyy-MM-dd'T'HH:mm:ssZ");
        } else if (type.isEnum()) {
            result = new AjaxDropDownChoicePanel(id, fieldName, (IModel<?>)model).setChoices(Arrays.asList(type.getEnumConstants()));
        }
        if (result == null) {
            result = new AjaxTextFieldPanel(id, fieldName, (IModel<String>)model);
        }
        return result;
    }

    private ListView<String> buildPropView() {
        LoadableDetachableModel<List<String>> propViewModel = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                ArrayList<String> result = new ArrayList<String>();
                if (ReportletConfModalPage.this.reportletConf != null) {
                    for (Field field : ReportletConfModalPage.this.reportletConf.getClass().getDeclaredFields()) {
                        if (ArrayUtils.contains((Object[])EXCLUDE_PROPERTIES, (Object)field.getName())) continue;
                        result.add(field.getName());
                    }
                }
                return result;
            }
        };
        this.propView = new ListView<String>("propView", (IModel)propViewModel){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<String> item) {
                AbstractFieldPanel panel;
                String fieldName = (String)item.getModelObject();
                Label label = new Label("key", fieldName);
                item.add(new Component[]{label});
                Field field = null;
                try {
                    field = ReportletConfModalPage.this.reportletConf.getClass().getDeclaredField(fieldName);
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("Could not find field {} in class {}", new Object[]{fieldName, ReportletConfModalPage.this.reportletConf.getClass(), e});
                }
                if (field == null) {
                    return;
                }
                FormAttributeField annotation = field.getAnnotation(FormAttributeField.class);
                BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)ReportletConfModalPage.this.reportletConf);
                if (String.class.equals(field.getType()) && annotation != null && annotation.userSearch()) {
                    panel = new UserSearchPanel.Builder("value").fiql((String)wrapper.getPropertyValue(fieldName)).required(false).build();
                    panel.setDefaultModel((IModel)new Model((Serializable)((Object)fieldName)));
                } else if (String.class.equals(field.getType()) && annotation != null && annotation.roleSearch()) {
                    panel = new RoleSearchPanel.Builder("value").fiql((String)wrapper.getPropertyValue(fieldName)).required(false).build();
                    panel.setDefaultModel((IModel)new Model((Serializable)((Object)fieldName)));
                } else if (List.class.equals(field.getType())) {
                    Class listItemType = String.class;
                    if (field.getGenericType() instanceof ParameterizedType) {
                        listItemType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    }
                    if (listItemType.equals(String.class) && annotation != null) {
                        List<Object> choices;
                        switch (annotation.schema()) {
                            case UserSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getSchemaNames(AttributableType.USER);
                                break;
                            }
                            case UserDerivedSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getDerSchemaNames(AttributableType.USER);
                                break;
                            }
                            case UserVirtualSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getVirSchemaNames(AttributableType.USER);
                                break;
                            }
                            case RoleSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getSchemaNames(AttributableType.ROLE);
                                break;
                            }
                            case RoleDerivedSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getDerSchemaNames(AttributableType.ROLE);
                                break;
                            }
                            case RoleVirtualSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getVirSchemaNames(AttributableType.ROLE);
                                break;
                            }
                            case MembershipSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getSchemaNames(AttributableType.MEMBERSHIP);
                                break;
                            }
                            case MembershipDerivedSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getDerSchemaNames(AttributableType.MEMBERSHIP);
                                break;
                            }
                            case MembershipVirtualSchema: {
                                choices = ReportletConfModalPage.this.schemaRestClient.getVirSchemaNames(AttributableType.MEMBERSHIP);
                                break;
                            }
                            default: {
                                choices = Collections.emptyList();
                            }
                        }
                        panel = new AjaxPalettePanel("value", new PropertyModel((Object)ReportletConfModalPage.this.reportletConf, fieldName), new ListModel(choices), true);
                    } else if (listItemType.isEnum()) {
                        panel = new CheckBoxMultipleChoiceFieldPanel("value", new PropertyModel((Object)ReportletConfModalPage.this.reportletConf, fieldName), new ListModel(Arrays.asList(listItemType.getEnumConstants())));
                    } else {
                        if (((List)wrapper.getPropertyValue(fieldName)).isEmpty()) {
                            ((List)wrapper.getPropertyValue(fieldName)).add(null);
                        }
                        panel = new MultiFieldPanel("value", new PropertyModel((Object)ReportletConfModalPage.this.reportletConf, fieldName), ReportletConfModalPage.this.buildSinglePanel(field.getType(), fieldName, "panel"));
                    }
                } else {
                    panel = ReportletConfModalPage.this.buildSinglePanel(field.getType(), fieldName, "value");
                }
                item.add(new Component[]{panel});
            }
        };
        return this.propView;
    }
}

