/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.types.AuditLoggerName;
import org.apache.syncope.common.util.LoggerEventUtils;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.ReportModalPage;
import org.apache.syncope.console.pages.panels.LoggerCategoryPanel;
import org.apache.syncope.console.pages.panels.SelectedEventsPanel;
import org.apache.syncope.console.rest.LoggerRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.JobColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.CollectionUtils;

public class Reports
extends BasePage {
    private static final long serialVersionUID = -2071214196989178694L;
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 700;
    @SpringBean
    private LoggerRestClient loggerRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private WebMarkupContainer reportContainer;
    private WebMarkupContainer auditContainer;
    private int paginatorRows;
    private final ModalWindow window = new ModalWindow("reportWin");

    public Reports(PageParameters parameters) {
        super(parameters);
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setCookieName("view-report-win");
        this.add(new Component[]{this.window});
        this.setupReport();
        this.setupAudit();
    }

    private void setupReport() {
        this.reportContainer = new WebMarkupContainer("reportContainer");
        this.setWindowClosedCallback(this.window, this.reportContainer);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.reportContainer, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "list"));
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "report.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("name"), (Object)"name", "name"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("lastExec"), "lastExec", "lastExec"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("nextExec"), "nextExec", "nextExec"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("startDate"), "startDate", "startDate"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("endDate"), "endDate", "endDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("latestExecStatus"), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((Object)new JobColumn((IModel<String>)new StringResourceModel("", (Component)this, null, "", new Object[0]), "runtime", this.getPageReference(), this.reportRestClient));
        columns.add(new ActionColumn<ReportTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public ActionLinksPanel getActions(String componentId, IModel<ReportTO> model) {
                final ReportTO reportTO = (ReportTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, Reports.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Reports.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ReportModalPage(Reports.this.window, reportTO, Reports.this.getPageReference());
                            }
                        });
                        Reports.this.window.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Reports");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Reports.this.reportRestClient.startExecution(reportTO.getId());
                            Reports.this.getSession().info((Serializable)((Object)Reports.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            Reports.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        Reports.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{Reports.this.reportContainer});
                    }
                }, ActionLink.ActionType.EXECUTE, "Reports");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Reports.this.reportRestClient.delete(reportTO.getId());
                            Reports.this.info((Serializable)((Object)Reports.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            Reports.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{Reports.this.reportContainer});
                        Reports.this.feedbackPanel.refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Reports");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), Reports.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            target.add(new Component[]{Reports.this.reportContainer});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        final AjaxFallbackDefaultDataTable reportTable = new AjaxFallbackDefaultDataTable("reportTable", columns, (ISortableDataProvider)new ReportProvider(), this.paginatorRows);
        this.reportContainer.add(new Component[]{reportTable});
        this.reportContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.reportContainer});
        Form paginatorForm = new Form("paginatorForm");
        MetaDataRoleAuthorizationStrategy.authorize((Component)paginatorForm, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "list"));
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Reports.this.prefMan.set(Reports.this.getRequest(), Reports.this.getResponse(), "report.paginator.rows", String.valueOf(Reports.this.paginatorRows));
                reportTable.setItemsPerPage((long)Reports.this.paginatorRows);
                target.add(new Component[]{Reports.this.reportContainer});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        ClearIndicatingAjaxLink createLink = new ClearIndicatingAjaxLink("createLink", this.getPageReference()){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                Reports.this.window.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new ReportModalPage(Reports.this.window, new ReportTO(), Reports.this.getPageReference());
                    }
                });
                Reports.this.window.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Reports", "create"));
        this.add(new Component[]{createLink});
    }

    private void setupAudit() {
        this.auditContainer = new WebMarkupContainer("auditContainer");
        this.auditContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.auditContainer});
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.auditContainer, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Audit", "list"));
        Form form = new Form("auditForm");
        this.auditContainer.add(new Component[]{form});
        final ArrayList<String> events = new ArrayList<String>();
        List<AuditLoggerName> audits = this.loggerRestClient.listAudits();
        for (AuditLoggerName audit : audits) {
            events.add(LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)audit.getType(), (String)audit.getCategory(), (String)audit.getSubcategory(), (String)audit.getEvent(), (AuditElements.Result)audit.getResult()));
        }
        ListModel model = new ListModel(new ArrayList(events));
        form.add(new Component[]{new LoggerCategoryPanel("events", this.loggerRestClient.listEvents(), (IModel)model, this.getPageReference(), "Reports"){
            private static final long serialVersionUID = 6113164334533550277L;

            @Override
            protected String[] getListRoles() {
                return new String[]{Reports.this.xmlRolesReader.getEntitlement("Audit", "list")};
            }

            @Override
            protected String[] getChangeRoles() {
                return new String[]{Reports.this.xmlRolesReader.getEntitlement("Audit", "enable"), Reports.this.xmlRolesReader.getEntitlement("Audit", "disable")};
            }

            @Override
            public void onEventAction(IEvent<?> event) {
                if (event.getPayload() instanceof SelectedEventsPanel.EventSelectionChanged) {
                    AuditLoggerName auditLoggerName;
                    Map.Entry eventCategory;
                    SelectedEventsPanel.EventSelectionChanged eventSelectionChanged = (SelectedEventsPanel.EventSelectionChanged)event.getPayload();
                    for (String toBeRemoved : eventSelectionChanged.getToBeRemoved()) {
                        if (!events.contains(toBeRemoved)) continue;
                        eventCategory = LoggerEventUtils.parseEventCategory((String)toBeRemoved);
                        auditLoggerName = new AuditLoggerName(((EventCategoryTO)eventCategory.getKey()).getType(), ((EventCategoryTO)eventCategory.getKey()).getCategory(), ((EventCategoryTO)eventCategory.getKey()).getSubcategory(), CollectionUtils.isEmpty((Collection)((EventCategoryTO)eventCategory.getKey()).getEvents()) ? null : (String)((EventCategoryTO)eventCategory.getKey()).getEvents().iterator().next(), (AuditElements.Result)eventCategory.getValue());
                        Reports.this.loggerRestClient.disableAudit(auditLoggerName);
                        events.remove(toBeRemoved);
                    }
                    for (String toBeAdded : eventSelectionChanged.getToBeAdded()) {
                        if (events.contains(toBeAdded)) continue;
                        eventCategory = LoggerEventUtils.parseEventCategory((String)toBeAdded);
                        auditLoggerName = new AuditLoggerName(((EventCategoryTO)eventCategory.getKey()).getType(), ((EventCategoryTO)eventCategory.getKey()).getCategory(), ((EventCategoryTO)eventCategory.getKey()).getSubcategory(), CollectionUtils.isEmpty((Collection)((EventCategoryTO)eventCategory.getKey()).getEvents()) ? null : (String)((EventCategoryTO)eventCategory.getKey()).getEvents().iterator().next(), (AuditElements.Result)eventCategory.getValue());
                        Reports.this.loggerRestClient.enableAudit(auditLoggerName);
                        events.add(toBeAdded);
                    }
                }
            }
        }});
    }

    @Override
    public String getAjaxIndicatorMarkupId() {
        return "";
    }

    private class ReportProvider
    extends SortableDataProvider<ReportTO, String> {
        private static final long serialVersionUID = -2311716167583335852L;
        private final SortableDataProviderComparator<ReportTO> comparator;

        public ReportProvider() {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ReportTO>(this);
        }

        public Iterator<ReportTO> iterator(long first, long count) {
            int page = (int)first / Reports.this.paginatorRows;
            List<ReportTO> list = Reports.this.reportRestClient.list((page < 0 ? 0 : page) + 1, Reports.this.paginatorRows, (SortParam<String>)this.getSort());
            Collections.sort(list, this.comparator);
            return list.iterator();
        }

        public long size() {
            return Reports.this.reportRestClient.count();
        }

        public IModel<ReportTO> model(final ReportTO configuration) {
            return new AbstractReadOnlyModel<ReportTO>(){
                private static final long serialVersionUID = 4921104837546595602L;

                public ReportTO getObject() {
                    return configuration;
                }
            };
        }
    }
}

