/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.SecurityQuestionTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.rest.SecurityQuestionRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RequestPasswordResetModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -8419445804421211904L;
    @SpringBean
    private SecurityQuestionRestClient securityQuestionRestClient;

    public RequestPasswordResetModalPage(final ModalWindow window) {
        this.setOutputMarkupId(true);
        boolean handleSecurityQuestion = this.userSelfRestClient.isPwdResetRequiringSecurityQuestions();
        StatelessForm form = new StatelessForm("form");
        form.setOutputMarkupId(true);
        Label securityQuestionLabel = new Label("securityQuestionLabel", this.getString("securityQuestion"));
        securityQuestionLabel.setOutputMarkupPlaceholderTag(true);
        securityQuestionLabel.setVisible(handleSecurityQuestion);
        form.add(new Component[]{securityQuestionLabel});
        final AjaxTextFieldPanel securityQuestion = new AjaxTextFieldPanel("securityQuestion", "securityQuestion", (IModel<String>)new Model());
        securityQuestion.setReadOnly(true);
        securityQuestion.setRequired(true);
        securityQuestion.getField().setOutputMarkupId(true);
        securityQuestion.setOutputMarkupPlaceholderTag(true);
        securityQuestion.setVisible(handleSecurityQuestion);
        form.add(new Component[]{securityQuestion});
        final AjaxTextFieldPanel username = new AjaxTextFieldPanel("username", "username", (IModel<String>)new Model());
        username.setRequired(true);
        username.getField().setOutputMarkupId(true);
        if (handleSecurityQuestion) {
            username.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    RequestPasswordResetModalPage.this.getFeedbackMessages().clear();
                    target.add(new Component[]{RequestPasswordResetModalPage.this.feedbackPanel});
                    try {
                        SecurityQuestionTO read = RequestPasswordResetModalPage.this.securityQuestionRestClient.readByUser((String)username.getModelObject());
                        securityQuestion.setModelObject(read.getContent());
                    }
                    catch (Exception e) {
                        try {
                            AbstractBasePage.LOG.error("While fetching security question for {}", username.getModelObject(), (Object)e);
                            RequestPasswordResetModalPage.this.error((Serializable)((Object)(RequestPasswordResetModalPage.this.getString("error") + ": " + e.getMessage())));
                            RequestPasswordResetModalPage.this.feedbackPanel.refresh(target);
                            securityQuestion.setModelObject((Object)null);
                        }
                        catch (Throwable throwable) {
                            target.add(new Component[]{securityQuestion});
                            throw throwable;
                        }
                        target.add(new Component[]{securityQuestion});
                    }
                    target.add(new Component[]{securityQuestion});
                }
            }});
        }
        form.add(new Component[]{username});
        Label securityAnswerLabel = new Label("securityAnswerLabel", this.getString("securityAnswer"));
        securityAnswerLabel.setOutputMarkupPlaceholderTag(true);
        securityAnswerLabel.setVisible(handleSecurityQuestion);
        form.add(new Component[]{securityAnswerLabel});
        final AjaxTextFieldPanel securityAnswer = new AjaxTextFieldPanel("securityAnswer", "securityAnswer", (IModel<String>)new Model());
        securityAnswer.setRequired(handleSecurityQuestion);
        securityAnswer.setOutputMarkupPlaceholderTag(true);
        securityAnswer.setVisible(handleSecurityQuestion);
        form.add(new Component[]{securityAnswer});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit", "submit")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    RequestPasswordResetModalPage.this.userSelfRestClient.requestPasswordReset((String)username.getModelObject(), (String)securityAnswer.getModelObject());
                    this.setResponsePage((Page)new ResultStatusModalPage.Builder(window, (AbstractSubjectTO)new UserTO()).mode(Mode.SELF).build());
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("While requesting password reset for {}", username.getModelObject(), (Object)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    RequestPasswordResetModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                RequestPasswordResetModalPage.this.feedbackPanel.refresh(target);
            }
        };
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

