/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.AbstractSysInfoTO;
import org.apache.syncope.common.to.MappingItemTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.panels.ResourceConnConfPanel;
import org.apache.syncope.console.pages.panels.ResourceDetailsPanel;
import org.apache.syncope.console.pages.panels.ResourceMappingPanel;
import org.apache.syncope.console.pages.panels.ResourceSecurityPanel;
import org.apache.syncope.console.pages.panels.SysInfoPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class ResourceModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 1734415311027284221L;

    public ResourceModalPage(final PageReference pageRef, final ModalWindow window, ResourceTO resourceTO, final boolean createFlag) {
        this.add(new Component[]{new Label("new", (IModel)(StringUtils.isBlank((CharSequence)resourceTO.getName()) ? new ResourceModel("new") : new Model((Serializable)((Object)""))))});
        this.add(new Component[]{new Label("name", StringUtils.isBlank((CharSequence)resourceTO.getName()) ? "" : resourceTO.getName())});
        Form form = new Form("form");
        form.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        form.add(new Component[]{new ResourceDetailsPanel("details", resourceTO, this.resourceRestClient.getPropagationActionsClasses(), createFlag)});
        form.add(new Component[]{new SysInfoPanel("systeminformation", (AbstractSysInfoTO)resourceTO)});
        form.add(new Component[]{new ResourceMappingPanel("umapping", resourceTO, AttributableType.USER)});
        form.add(new Component[]{new ResourceMappingPanel("rmapping", resourceTO, AttributableType.ROLE)});
        ResourceConnConfPanel resourceConnConfPanel = new ResourceConnConfPanel("connconf", resourceTO, createFlag);
        MetaDataRoleAuthorizationStrategy.authorize((Component)resourceConnConfPanel, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Connectors", "read"));
        form.add(new Component[]{resourceConnConfPanel});
        form.add(new Component[]{new ResourceSecurityPanel("security", resourceTO)});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit", "submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ResourceTO resourceTO = (ResourceTO)form.getDefaultModelObject();
                boolean accountIdError = false;
                if (resourceTO.getUmapping() == null || resourceTO.getUmapping().getItems().isEmpty()) {
                    resourceTO.setUmapping(null);
                } else {
                    int uAccountIdCount = 0;
                    for (MappingItemTO item : resourceTO.getUmapping().getItems()) {
                        if (!item.isAccountid()) continue;
                        ++uAccountIdCount;
                    }
                    boolean bl = accountIdError = uAccountIdCount != 1;
                }
                if (resourceTO.getRmapping() == null || resourceTO.getRmapping().getItems().isEmpty()) {
                    resourceTO.setRmapping(null);
                } else {
                    int rAccountIdCount = 0;
                    for (MappingItemTO item : resourceTO.getRmapping().getItems()) {
                        if (!item.isAccountid()) continue;
                        ++rAccountIdCount;
                    }
                    accountIdError |= rAccountIdCount != 1;
                }
                if (accountIdError) {
                    this.error((Serializable)((Object)this.getString("accountIdValidation")));
                    ResourceModalPage.this.feedbackPanel.refresh(target);
                } else {
                    try {
                        if (createFlag) {
                            ResourceModalPage.this.resourceRestClient.create(resourceTO);
                        } else {
                            ResourceModalPage.this.resourceRestClient.update(resourceTO);
                        }
                        if (pageRef != null && pageRef.getPage() instanceof AbstractBasePage) {
                            ((AbstractBasePage)pageRef.getPage()).setModalResult(true);
                        }
                        window.close(target);
                    }
                    catch (Exception e) {
                        AbstractBasePage.LOG.error("Failure managing resource {}", (Object)resourceTO, (Object)e);
                        this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                        ResourceModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                ResourceModalPage.this.feedbackPanel.refresh(target);
            }
        };
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Resources", createFlag ? "create" : "update"));
    }

    public static class ResourceEvent {
        private AjaxRequestTarget target;

        public ResourceEvent(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

