/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.ConnectorModalPage;
import org.apache.syncope.console.pages.ProvisioningModalPage;
import org.apache.syncope.console.pages.ResourceModalPage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.AjaxDataTablePanel;
import org.apache.syncope.console.rest.ConnectorRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.syncope.console.wicket.markup.html.form.LinkPanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Resources
extends BasePage {
    private static final long serialVersionUID = -3789252860990261728L;
    private static final int WIN_HEIGHT = 600;
    private static final int WIN_WIDTH = 1100;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createResourceWin;
    private final ModalWindow editResourceWin;
    private final ModalWindow createConnectorWin;
    private final ModalWindow editConnectorWin;
    private final int resourcePaginatorRows;
    private final int connectorPaginatorRows;
    private WebMarkupContainer resourceContainer;
    private WebMarkupContainer connectorContainer;
    protected final ModalWindow statusmodal = new ModalWindow("statusModal");
    private static final int STATUS_MODAL_WIN_HEIGHT = 500;
    private static final int STATUS_MODAL_WIN_WIDTH = 700;

    public Resources(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createResourceWin = new ModalWindow("createResourceWin");
        componentArray[0] = this.createResourceWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editResourceWin = new ModalWindow("editResourceWin");
        componentArray2[0] = this.editResourceWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.createConnectorWin = new ModalWindow("createConnectorWin");
        componentArray3[0] = this.createConnectorWin;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.editConnectorWin = new ModalWindow("editConnectorWin");
        componentArray4[0] = this.editConnectorWin;
        this.add(componentArray4);
        this.statusmodal.setCssClassName("w_silver");
        this.statusmodal.setInitialHeight(500);
        this.statusmodal.setInitialWidth(700);
        this.statusmodal.setCookieName("status-modal");
        this.add(new Component[]{this.statusmodal});
        ClearIndicatingAjaxLink<Void> reloadLink = new ClearIndicatingAjaxLink<Void>("reloadLink", this.getPageReference()){
            private static final long serialVersionUID = 3109256773218160485L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                try {
                    Resources.this.connectorRestClient.reload();
                    this.info((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                }
                Resources.this.feedbackPanel.refresh(target);
                target.add(new Component[]{Resources.this.connectorContainer});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxCallListener ajaxCallListener = new AjaxCallListener(){
                    private static final long serialVersionUID = 7160235486520935153L;

                    public CharSequence getPrecondition(Component component) {
                        return "if (!confirm('" + this.getString("confirmReloadConnectors") + "')) " + "{return false;} else {return true;}";
                    }
                };
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)reloadLink, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Connectors", "reload"));
        this.add(new Component[]{reloadLink});
        this.resourcePaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "resources.paginator.rows");
        this.connectorPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "connectors.paginator.rows");
        this.setupResources();
        this.setupConnectors();
    }

    private void setupResources() {
        ArrayList columns = new ArrayList();
        columns.add(new PropertyColumn((IModel)new StringResourceModel("name", (Component)this, null, new Object[0]), (Object)"name", "name"));
        columns.add(new AbstractColumn<ResourceTO, String>((IModel)new StringResourceModel("connector", (Component)this, null, "connector", new Object[0])){
            private static final long serialVersionUID = 8263694778917279290L;

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, final IModel<ResourceTO> rowModel) {
                ClearIndicatingAjaxLink<String> editLink = new ClearIndicatingAjaxLink<String>("link", Resources.this.getPageReference()){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    protected void onClickInternal(AjaxRequestTarget target) {
                        Resources.this.editConnectorWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ConnectorModalPage(Resources.this.getPageReference(), Resources.this.editConnectorWin, Resources.this.connectorRestClient.read(((ResourceTO)rowModel.getObject()).getConnectorId()));
                            }
                        });
                        Resources.this.editConnectorWin.show(target);
                    }
                };
                editLink.add(new Component[]{new Label("linkTitle", ((ResourceTO)rowModel.getObject()).getConnectorDisplayName())});
                LinkPanel editConnPanel = new LinkPanel(componentId);
                editConnPanel.add(new Component[]{editLink});
                cellItem.add(new Component[]{editConnPanel});
                MetaDataRoleAuthorizationStrategy.authorize((Component)editConnPanel, (Action)Component.ENABLE, (String)Resources.this.xmlRolesReader.getEntitlement("Connectors", "read"));
            }
        });
        columns.add(new AbstractColumn<ResourceTO, String>((IModel)new StringResourceModel("propagationPrimary", (Component)this, null, new Object[0])){
            private static final long serialVersionUID = -3503023501954863131L;

            public void populateItem(Item<ICellPopulator<ResourceTO>> item, String componentId, IModel<ResourceTO> model) {
                item.add(new Component[]{new Label(componentId, "")});
                item.add(new Behavior[]{new AttributeModifier("class", (IModel)new Model((Serializable)((Object)Boolean.toString(((ResourceTO)model.getObject()).isPropagationPrimary()))))});
            }

            public String getCssClass() {
                return "narrowcolumn";
            }
        });
        columns.add(new PropertyColumn<ResourceTO, String>((IModel)new StringResourceModel("propagationPriority", (Component)this, null, new Object[0]), "propagationPriority", "propagationPriority"){

            public String getCssClass() {
                return "narrowcolumn";
            }
        });
        columns.add(new AbstractColumn<ResourceTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, final IModel<ResourceTO> model) {
                final ResourceTO resourceTO = (ResourceTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, Resources.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.statusmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ProvisioningModalPage<UserTO>(Resources.this.getPageReference(), Resources.this.statusmodal, (ResourceTO)model.getObject(), UserTO.class);
                            }
                        });
                        Resources.this.statusmodal.show(target);
                    }
                }, ActionLink.ActionType.MANAGE_USERS, "Resources");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.statusmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ProvisioningModalPage<RoleTO>(Resources.this.getPageReference(), Resources.this.statusmodal, (ResourceTO)model.getObject(), RoleTO.class);
                            }
                        });
                        Resources.this.statusmodal.show(target);
                    }
                }, ActionLink.ActionType.MANAGE_ROLES, "Resources");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        resourceTO.setUsyncToken(null);
                        resourceTO.setRsyncToken(null);
                        try {
                            Resources.this.resourceRestClient.update(resourceTO);
                            Resources.this.info((Serializable)((Object)Resources.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException e) {
                            Resources.this.error((Serializable)((Object)(Resources.this.getString("error") + ":" + e.getMessage())));
                            AbstractBasePage.LOG.error("While resetting sync token from " + resourceTO.getName(), (Throwable)e);
                        }
                        Resources.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{Resources.this.resourceContainer});
                    }
                }, ActionLink.ActionType.RESET, "Resources");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.editResourceWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ResourceModalPage(Resources.this.getPageReference(), Resources.this.editResourceWin, resourceTO, false);
                            }
                        });
                        Resources.this.editResourceWin.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Resources");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Resources.this.resourceRestClient.delete(resourceTO.getName());
                            Resources.this.info((Serializable)((Object)Resources.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException e) {
                            Resources.this.error((Serializable)((Object)(Resources.this.getString("error") + ": " + e.getMessage())));
                            AbstractBasePage.LOG.error("While deleting resource " + resourceTO.getName(), (Throwable)e);
                        }
                        Resources.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{Resources.this.resourceContainer});
                    }
                }, ActionLink.ActionType.DELETE, "Resources");
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxDataTablePanel table = new AjaxDataTablePanel("resourceDatatable", columns, new ResourcesProvider(), this.resourcePaginatorRows, (Collection<ActionLink.ActionType>)Arrays.asList(ActionLink.ActionType.DELETE), this.resourceRestClient, "name", "Resources", this.getPageReference());
        this.resourceContainer = new WebMarkupContainer("resourceContainer");
        this.resourceContainer.add(new Component[]{table});
        this.resourceContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.resourceContainer});
        this.setWindowClosedCallback(this.createResourceWin, this.resourceContainer);
        this.setWindowClosedCallback(this.editResourceWin, this.resourceContainer);
        this.createResourceWin.setCssClassName("w_silver");
        this.createResourceWin.setInitialHeight(600);
        this.createResourceWin.setInitialWidth(1100);
        this.createResourceWin.setCookieName("create-res-modal");
        this.editResourceWin.setCssClassName("w_silver");
        this.editResourceWin.setInitialHeight(600);
        this.editResourceWin.setInitialWidth(1100);
        this.editResourceWin.setCookieName("edit-res-modal");
        ClearIndicatingAjaxLink<Void> createResourceLink = new ClearIndicatingAjaxLink<Void>("createResourceLink", this.getPageReference()){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                Resources.this.createResourceWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        ResourceModalPage windows = new ResourceModalPage(Resources.this.getPageReference(), Resources.this.editResourceWin, new ResourceTO(), true);
                        return windows;
                    }
                });
                Resources.this.createResourceWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createResourceLink, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Resources", "create"));
        this.add(new Component[]{createResourceLink});
        Form paginatorForm = new Form("resourcePaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "resourcePaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Resources.this.prefMan.set(Resources.this.getRequest(), Resources.this.getResponse(), "resources.paginator.rows", String.valueOf(Resources.this.resourcePaginatorRows));
                table.setItemsPerPage(Resources.this.resourcePaginatorRows);
                target.add(new Component[]{Resources.this.resourceContainer});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private void setupConnectors() {
        ArrayList columns = new ArrayList();
        columns.add(new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, new Object[0]), (Object)"id", "id"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("name", (Component)this, null, new Object[0]), (Object)"connectorName", "connectorName"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("displayName", (Component)this, null, new Object[0]), (Object)"displayName", "displayName"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("bundleName", (Component)this, null, new Object[0]), (Object)"bundleName", "bundleName"));
        columns.add(new PropertyColumn((IModel)new StringResourceModel("version", (Component)this, null, new Object[0]), (Object)"version", "version"));
        columns.add(new AbstractColumn<ConnInstanceTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<ConnInstanceTO>> cellItem, String componentId, IModel<ConnInstanceTO> model) {
                final ConnInstanceTO connectorTO = (ConnInstanceTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, Resources.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.editConnectorWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ConnectorModalPage(Resources.this.getPageReference(), Resources.this.editConnectorWin, connectorTO);
                            }
                        });
                        Resources.this.editConnectorWin.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Connectors");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Resources.this.connectorRestClient.delete(connectorTO.getId());
                            Resources.this.info((Serializable)((Object)Resources.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException e) {
                            Resources.this.error((Serializable)((Object)(Resources.this.getString("error") + ": " + e.getMessage())));
                            AbstractBasePage.LOG.error("While deleting connector " + connectorTO.getId(), (Throwable)e);
                        }
                        target.add(new Component[]{Resources.this.connectorContainer});
                        Resources.this.feedbackPanel.refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Connectors");
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxDataTablePanel table = new AjaxDataTablePanel("connectorDatatable", columns, new ConnectorsProvider(), this.connectorPaginatorRows, (Collection<ActionLink.ActionType>)Arrays.asList(ActionLink.ActionType.DELETE), this.connectorRestClient, "id", "Connectors", this.getPageReference());
        this.connectorContainer = new WebMarkupContainer("connectorContainer");
        this.connectorContainer.add(new Component[]{table});
        this.connectorContainer.setOutputMarkupId(true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.connectorContainer, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Connectors", "list"));
        this.add(new Component[]{this.connectorContainer});
        this.setWindowClosedCallback(this.createConnectorWin, this.connectorContainer);
        this.setWindowClosedCallback(this.editConnectorWin, this.connectorContainer);
        this.createConnectorWin.setCssClassName("w_silver");
        this.createConnectorWin.setInitialHeight(600);
        this.createConnectorWin.setInitialWidth(1100);
        this.createConnectorWin.setCookieName("create-conn-modal");
        this.editConnectorWin.setCssClassName("w_silver");
        this.editConnectorWin.setInitialHeight(600);
        this.editConnectorWin.setInitialWidth(1100);
        this.editConnectorWin.setCookieName("edit-conn-modal");
        ClearIndicatingAjaxLink<Void> createConnectorLink = new ClearIndicatingAjaxLink<Void>("createConnectorLink", this.getPageReference()){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                Resources.this.createConnectorWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        ConnectorModalPage form = new ConnectorModalPage(Resources.this.getPageReference(), Resources.this.editConnectorWin, new ConnInstanceTO());
                        return form;
                    }
                });
                Resources.this.createConnectorWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConnectorLink, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Connectors", "create"));
        this.add(new Component[]{createConnectorLink});
        Form paginatorForm = new Form("connectorPaginatorForm");
        MetaDataRoleAuthorizationStrategy.authorize((Component)paginatorForm, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Connectors", "list"));
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "connectorPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Resources.this.prefMan.set(Resources.this.getRequest(), Resources.this.getResponse(), "connectors.paginator.rows", String.valueOf(Resources.this.connectorPaginatorRows));
                table.setItemsPerPage(Resources.this.connectorPaginatorRows);
                target.add(new Component[]{Resources.this.connectorContainer});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AbstractSearchResultPanel.EventDataWrapper) {
            ((AbstractSearchResultPanel.EventDataWrapper)event.getPayload()).getTarget().add(new Component[]{this.resourceContainer});
            ((AbstractSearchResultPanel.EventDataWrapper)event.getPayload()).getTarget().add(new Component[]{this.connectorContainer});
        }
    }

    private class ConnectorsProvider
    extends SortableDataProvider<ConnInstanceTO, String> {
        private static final long serialVersionUID = 4445909568349448518L;
        private final SortableDataProviderComparator<ConnInstanceTO> comparator;

        public ConnectorsProvider() {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ConnInstanceTO>(this);
        }

        public Iterator<ConnInstanceTO> iterator(long first, long count) {
            List<ConnInstanceTO> list = this.getConnectorsListDB();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.getConnectorsListDB().size();
        }

        public IModel<ConnInstanceTO> model(final ConnInstanceTO connector) {
            return new AbstractReadOnlyModel<ConnInstanceTO>(){
                private static final long serialVersionUID = -6033068018293569398L;

                public ConnInstanceTO getObject() {
                    return connector;
                }
            };
        }

        public List<ConnInstanceTO> getConnectorsListDB() {
            return Resources.this.connectorRestClient.getAllConnectors();
        }
    }

    class ResourcesProvider
    extends SortableDataProvider<ResourceTO, String> {
        private static final long serialVersionUID = -9055916672926643975L;
        private final SortableDataProviderComparator<ResourceTO> comparator;

        public ResourcesProvider() {
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ResourceTO>(this);
        }

        public Iterator<ResourceTO> iterator(long first, long count) {
            List<ResourceTO> list = this.getResourcesListDB();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.getResourcesListDB().size();
        }

        public IModel<ResourceTO> model(final ResourceTO resource) {
            return new AbstractReadOnlyModel<ResourceTO>(){
                private static final long serialVersionUID = 8952474152465381634L;

                public ResourceTO getObject() {
                    return resource;
                }
            };
        }

        public List<ResourceTO> getResourcesListDB() {
            return Resources.this.resourceRestClient.getAll();
        }
    }
}

