/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.common.to.PropagationStatus;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.PropagationTaskExecStatus;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.commons.status.Status;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.FailureMessageModalPage;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResultStatusModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 2646115294319713723L;
    private static final String IMG_STATUSES = "statuses/";
    @SpringBean(name="anonymousUser")
    private String anonymousUser;
    private final AbstractSubjectTO subject;
    private final Mode mode;
    private final StatusUtils statusUtils;

    private ResultStatusModalPage(final Builder builder) {
        this.subject = builder.subject;
        this.statusUtils = new StatusUtils(this.userRestClient);
        this.mode = builder.mode == null ? Mode.ADMIN : builder.mode;
        final ResultStatusModalPage page = this;
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        Fragment fragment = new Fragment("resultFrag", this.mode == Mode.SELF ? "userSelfResultFrag" : "propagationResultFrag", (MarkupContainer)this);
        fragment.setOutputMarkupId(true);
        container.add(new Component[]{fragment});
        if (this.mode == Mode.ADMIN) {
            PropagationStatus syncope = new PropagationStatus();
            syncope.setResource("Syncope");
            syncope.setStatus(PropagationTaskExecStatus.SUCCESS);
            ArrayList<PropagationStatus> propagations = new ArrayList<PropagationStatus>();
            propagations.add(syncope);
            propagations.addAll(this.subject.getPropagationStatusTOs());
            fragment.add(new Component[]{new Label("info", this.subject instanceof UserTO && ((UserTO)this.subject).getUsername() != null ? ((UserTO)this.subject).getUsername() : (this.subject instanceof RoleTO && ((RoleTO)this.subject).getName() != null ? ((RoleTO)this.subject).getName() : String.valueOf(this.subject.getId())))});
            ListView<PropagationStatus> propRes = new ListView<PropagationStatus>("resources", propagations){
                private static final long serialVersionUID = -1020475259727720708L;

                protected void populateItem(ListItem<PropagationStatus> item) {
                    String title;
                    String alt;
                    Image image;
                    PropagationStatus propTO = (PropagationStatus)item.getDefaultModelObject();
                    ListView attributes = ResultStatusModalPage.this.getConnObjectView(propTO);
                    Fragment attrhead = attributes.getModelObject() == null || attributes.getModelObject().isEmpty() ? new Fragment("attrhead", "emptyAttrHeadFrag", (MarkupContainer)page) : new Fragment("attrhead", "attrHeadFrag", (MarkupContainer)page);
                    item.add(new Component[]{attrhead});
                    item.add(new Component[]{attributes});
                    attrhead.add(new Component[]{new Label("resource", propTO.getResource())});
                    attrhead.add(new Component[]{new Label("propagation", propTO.getStatus() == null ? "UNDEFINED" : propTO.getStatus().toString())});
                    final ModalWindow failureWindow = new ModalWindow("failureWindow");
                    AjaxLink<Void> failureWindowLink = new AjaxLink<Void>("showFailureWindow"){
                        private static final long serialVersionUID = -7978723352517770644L;

                        public void onClick(AjaxRequestTarget target) {
                            failureWindow.show(target);
                        }
                    };
                    switch (propTO.getStatus()) {
                        case SUCCESS: 
                        case SUBMITTED: 
                        case CREATED: {
                            image = new Image("icon", ResultStatusModalPage.IMG_STATUSES + Status.ACTIVE.toString() + ".png");
                            alt = "success icon";
                            title = "success";
                            failureWindow.setVisible(false);
                            failureWindowLink.setEnabled(false);
                            break;
                        }
                        default: {
                            image = new Image("icon", ResultStatusModalPage.IMG_STATUSES + Status.SUSPENDED.toString() + ".png");
                            alt = "failure icon";
                            title = "failure";
                        }
                    }
                    image.add(new Behavior[]{new Behavior(){
                        private static final long serialVersionUID = 1469628524240283489L;

                        public void onComponentTag(Component component, ComponentTag tag) {
                            tag.put("alt", (CharSequence)alt);
                            tag.put("title", (CharSequence)title);
                        }
                    }});
                    final FailureMessageModalPage executionFailureMessagePage = propTO.getFailureReason() == null ? new FailureMessageModalPage(failureWindow.getContentId(), "") : new FailureMessageModalPage(failureWindow.getContentId(), propTO.getFailureReason());
                    failureWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = -7834632442532690940L;

                        public Page createPage() {
                            return executionFailureMessagePage;
                        }
                    });
                    failureWindow.setCookieName("failureWindow");
                    failureWindow.setCssClassName("w_silver");
                    failureWindowLink.add(new Component[]{image});
                    attrhead.add(new Component[]{failureWindowLink});
                    attrhead.add(new Component[]{failureWindow});
                }
            };
            fragment.add(new Component[]{propRes});
        }
        IndicatingAjaxLink<Void> close = new IndicatingAjaxLink<Void>("close"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                builder.window.close(target);
            }
        };
        container.add(new Component[]{close});
        this.setOutputMarkupId(true);
    }

    private ListView<String> getConnObjectView(final PropagationStatus propTO) {
        final ConnObjectTO before = propTO.getBeforeObj();
        final ConnObjectTO after = propTO.getAfterObj();
        ArrayList<String> head = new ArrayList<String>();
        if (this.subject instanceof UserTO) {
            head.add("__PASSWORD__");
            head.add("__ENABLE__");
        }
        head.add("__UID__");
        head.add("__NAME__");
        final Map beforeAttrMap = before == null ? Collections.emptyMap() : before.getAttrMap();
        final Map afterAttrMap = after == null ? Collections.emptyMap() : after.getAttrMap();
        HashSet attributes = new HashSet();
        attributes.addAll(beforeAttrMap.keySet());
        attributes.addAll(afterAttrMap.keySet());
        if (!(this.subject instanceof UserTO)) {
            attributes.remove("__PASSWORD__");
            attributes.remove("__ENABLE__");
        }
        ArrayList<Object> profile = new ArrayList<Object>();
        profile.addAll(attributes);
        profile.removeAll(head);
        Collections.sort(profile);
        for (String attr : head) {
            if (!attributes.contains(attr)) continue;
            profile.add(0, attr);
        }
        return new ListView<String>("attrs", profile){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                Fragment afterValue;
                Fragment beforeValue;
                String name = (String)item.getModelObject();
                if ("__ENABLE__".equals(name)) {
                    beforeValue = ResultStatusModalPage.this.getStatusIcon("beforeValue", propTO.getResource(), before);
                    afterValue = ResultStatusModalPage.this.getStatusIcon("afterValue", propTO.getResource(), after);
                } else {
                    beforeValue = ResultStatusModalPage.this.getLabelValue("beforeValue", name, beforeAttrMap);
                    afterValue = ResultStatusModalPage.this.getLabelValue("afterValue", name, afterAttrMap);
                }
                item.add(new Component[]{new Label("attrName", (IModel)new ResourceModel(name, name))});
                item.add(new Component[]{beforeValue});
                item.add(new Component[]{afterValue});
            }
        };
    }

    private Fragment getLabelValue(String id, String attrName, Map<String, AttributeTO> attrMap) {
        AttributeTO attr = attrMap.get(attrName);
        final String value = attr == null || attr.getValues() == null || attr.getValues().isEmpty() ? "" : ("__PASSWORD__".equals(attrName) ? "********" : (attr.getValues().size() > 1 ? attr.getValues().toString() : (String)attr.getValues().get(0)));
        Component label = new Label("value", value.length() > 50 ? value.substring(0, 50) + "..." : value).add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1469628524240283489L;

            public void onComponentTag(Component component, ComponentTag tag) {
                tag.put("title", (CharSequence)value);
            }
        }});
        Fragment frag = new Fragment(id, "attrValueFrag", (MarkupContainer)this);
        frag.add(new Component[]{label});
        return frag;
    }

    private Fragment getStatusIcon(String id, String resourceName, ConnObjectTO objectTO) {
        Fragment frag;
        String title;
        String alt;
        Image image;
        switch (this.statusUtils.getStatusBean((AbstractAttributableTO)this.subject, resourceName, objectTO, this.subject instanceof RoleTO).getStatus()) {
            case ACTIVE: {
                image = new Image("status", IMG_STATUSES + Status.ACTIVE.toString() + ".png");
                alt = "active icon";
                title = "Enabled";
                break;
            }
            case SUSPENDED: {
                image = new Image("status", IMG_STATUSES + Status.SUSPENDED.toString() + ".png");
                alt = "inactive icon";
                title = "Disabled";
                break;
            }
            default: {
                image = null;
                alt = null;
                title = null;
            }
        }
        if (image == null) {
            frag = new Fragment(id, "emptyFrag", (MarkupContainer)this);
        } else {
            image.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1469628524240283489L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.put("alt", (CharSequence)alt);
                    tag.put("title", (CharSequence)title);
                    tag.put("width", (CharSequence)"12px");
                    tag.put("height", (CharSequence)"12px");
                }
            }});
            frag = new Fragment(id, "remoteStatusFrag", (MarkupContainer)this);
            frag.add(new Component[]{image});
        }
        return frag;
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 220361441802274899L;
        private ModalWindow window;
        private Mode mode;
        private AbstractSubjectTO subject;

        public Builder(ModalWindow window, AbstractSubjectTO attributable) {
            this.window = window;
            this.subject = attributable;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public ResultStatusModalPage build() {
            return new ResultStatusModalPage(this);
        }
    }
}

