/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.common.mod.RoleMod;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.util.AttributableOperations;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.pages.panels.RolePanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class RoleModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -1732493223434085205L;
    protected final PageReference pageRef;
    protected final ModalWindow window;
    protected final Mode mode;
    protected final boolean createFlag;
    protected final RolePanel rolePanel;
    protected RoleTO originalRoleTO;

    public RoleModalPage(PageReference pageRef, ModalWindow window, RoleTO roleTO) {
        this(pageRef, window, roleTO, Mode.ADMIN);
    }

    public RoleModalPage(final PageReference pageRef, ModalWindow window, RoleTO roleTO, Mode mode) {
        this.pageRef = pageRef;
        this.window = window;
        this.mode = mode;
        boolean bl = this.createFlag = roleTO.getId() == 0L;
        if (!this.createFlag) {
            this.originalRoleTO = (RoleTO)SerializationUtils.clone((Serializable)roleTO);
        }
        Form form = new Form("roleForm");
        form.setMultiPart(true);
        this.add(new Component[]{new Label("displayName", roleTO.getId() == 0L ? "" : roleTO.getDisplayName())});
        form.setModel((IModel)new CompoundPropertyModel((Object)roleTO));
        this.rolePanel = new RolePanel.Builder("rolePanel").form(form).roleTO(roleTO).roleModalPageMode(mode).pageRef(this.getPageReference()).build();
        form.add(new Component[]{this.rolePanel});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    RoleModalPage.this.submitAction(target, form);
                    if (pageRef.getPage() instanceof BasePage) {
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                    }
                    RoleModalPage.this.closeAction(target, form);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    RoleModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                RoleModalPage.this.feedbackPanel.refresh(target);
            }
        };
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                RoleModalPage.this.closeAction(target, form);
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Roles", this.createFlag ? "create" : "update"));
        this.add(new Component[]{form});
    }

    protected void submitAction(AjaxRequestTarget target, Form<?> form) {
        RoleMod roleMod;
        RoleTO roleTO = (RoleTO)form.getDefaultModelObject();
        ArrayList<String> entitlementList = new ArrayList<String>(this.rolePanel.getSelectedEntitlements());
        roleTO.getEntitlements().clear();
        roleTO.getEntitlements().addAll(entitlementList);
        RoleTO result = this.createFlag ? this.roleRestClient.create(roleTO) : ((roleMod = AttributableOperations.diff((RoleTO)roleTO, (RoleTO)this.originalRoleTO)).isEmpty() ? roleTO : this.roleRestClient.update(this.originalRoleTO.getETagValue(), roleMod));
        this.setResponsePage((Page)new ResultStatusModalPage.Builder(this.window, (AbstractSubjectTO)result).build());
    }

    protected void closeAction(AjaxRequestTarget target, Form<?> form) {
        this.window.close(target);
    }
}

