/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.RoleSearchPanel;
import org.apache.syncope.console.pages.panels.RoleSearchResultPanel;
import org.apache.syncope.console.pages.panels.RoleSummaryPanel;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.markup.html.tree.TreeRolePanel;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Roles
extends BasePage {
    private static final long serialVersionUID = -2147758241610831969L;
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 800;
    @SpringBean
    private RoleRestClient restClient;
    private final ModalWindow editRoleWin;
    private final WebMarkupContainer roleTabsContainer = new WebMarkupContainer("roleTabsContainer");

    public Roles(PageParameters parameters) {
        super(parameters);
        this.roleTabsContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.roleTabsContainer});
        this.editRoleWin = new ModalWindow("editRoleWin");
        this.editRoleWin.setCssClassName("w_silver");
        this.editRoleWin.setInitialHeight(500);
        this.editRoleWin.setInitialWidth(800);
        this.editRoleWin.setCookieName("edit-role-modal");
        this.add(new Component[]{this.editRoleWin});
        TreeRolePanel treePanel = new TreeRolePanel("treePanel");
        treePanel.setOutputMarkupId(true);
        this.roleTabsContainer.add(new Component[]{treePanel});
        RoleSummaryPanel summaryPanel = new RoleSummaryPanel.Builder("summaryPanel").window(this.editRoleWin).callerPageRef(this.getPageReference()).build();
        this.roleTabsContainer.add(new Component[]{summaryPanel});
        this.editRoleWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                RoleSummaryPanel summaryPanel = (RoleSummaryPanel)Roles.this.roleTabsContainer.get("summaryPanel");
                TreeNodeClickUpdate data = new TreeNodeClickUpdate(target, summaryPanel == null || summaryPanel.getSelectedNode() == null ? 0L : summaryPanel.getSelectedNode().getId());
                Roles.this.send((IEventSink)Roles.this.getPage(), Broadcast.BREADTH, data);
                if (Roles.this.modalResult) {
                    Roles.this.getSession().info((Serializable)((Object)Roles.this.getString("operation_succeeded")));
                    Roles.this.feedbackPanel.refresh(target);
                    Roles.this.modalResult = false;
                }
            }
        });
        final RoleSearchResultPanel searchResult = new RoleSearchResultPanel("searchResult", true, null, this.getPageReference(), this.restClient);
        this.add(new Component[]{searchResult});
        Form searchForm = new Form("searchForm");
        this.add(new Component[]{searchForm});
        final RoleSearchPanel searchPanel = new RoleSearchPanel.Builder("searchPanel").build();
        searchForm.add(new Component[]{searchPanel});
        ClearIndicatingAjaxButton searchButton = new ClearIndicatingAjaxButton("search", (IModel)new ResourceModel("search"), this.getPageReference()){
            private static final long serialVersionUID = -958724007591692537L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                String fiql = searchPanel.buildFIQL();
                AbstractBasePage.LOG.debug("Node condition {}", (Object)fiql);
                Roles.this.doSearch(target, fiql, searchResult);
                Session.get().getFeedbackMessages().clear();
                searchPanel.getSearchFeedback().refresh(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                searchPanel.getSearchFeedback().refresh(target);
            }
        };
        searchForm.add(new Component[]{searchButton});
        searchForm.setDefaultButton((IFormSubmittingComponent)searchButton);
    }

    private void doSearch(AjaxRequestTarget target, String fiql, AbstractSearchResultPanel resultsetPanel) {
        if (fiql == null) {
            this.error((Serializable)((Object)this.getString("search_error")));
            return;
        }
        resultsetPanel.search(fiql, target);
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof TreeNodeClickUpdate) {
            TreeNodeClickUpdate update = (TreeNodeClickUpdate)event.getPayload();
            RoleSummaryPanel summaryPanel = new RoleSummaryPanel.Builder("summaryPanel").window(this.editRoleWin).callerPageRef(this.getPageReference()).selectedNodeId(update.getSelectedNodeId()).build();
            this.roleTabsContainer.addOrReplace(new Component[]{summaryPanel});
            update.getTarget().add(new Component[]{this.roleTabsContainer});
        }
    }

    public static class TreeNodeClickUpdate {
        private final AjaxRequestTarget target;
        private Long selectedNodeId;

        public TreeNodeClickUpdate(AjaxRequestTarget target, Long selectedNodeId) {
            this.target = target;
            this.selectedNodeId = selectedNodeId;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public Long getSelectedNodeId() {
            return this.selectedNodeId;
        }

        public void setSelectedNodeId(Long selectedNodeId) {
            this.selectedNodeId = selectedNodeId;
        }
    }
}

