/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.List;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.console.pages.AbstractSchedTaskModalPage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;

public class SchedTaskModalPage
extends AbstractSchedTaskModalPage {
    private static final long serialVersionUID = -2501860242590060867L;

    public SchedTaskModalPage(ModalWindow window, SchedTaskTO taskTO, PageReference callerPageRef) {
        super(window, taskTO, callerPageRef);
        LoadableDetachableModel<List<String>> classNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return SchedTaskModalPage.this.taskRestClient.getJobClasses();
            }
        };
        AjaxDropDownChoicePanel className = new AjaxDropDownChoicePanel("jobClassName", this.getString("class"), new PropertyModel((Object)taskTO, "jobClassName"));
        className.setChoices((List)classNames.getObject());
        className.addRequiredLabel();
        className.setEnabled(taskTO.getId() == 0L);
        className.setStyleSheet("ui-widget-content ui-corner-all long_dynamicsize");
        this.profile.add(new Component[]{className});
        this.description.setEnabled(!"org.apache.syncope.core.quartz.RoleMemberProvisionTaskJob".equals(taskTO.getJobClassName()));
        this.description.setVisible(!"org.apache.syncope.core.quartz.RoleMemberProvisionTaskJob".equals(taskTO.getJobClassName()));
        className.setVisible(!"org.apache.syncope.core.quartz.RoleMemberProvisionTaskJob".equals(taskTO.getJobClassName()));
    }

    @Override
    public void submitAction(SchedTaskTO taskTO) {
        if (taskTO.getId() > 0L) {
            this.taskRestClient.updateSchedTask(taskTO);
        } else {
            this.taskRestClient.createSchedTask(taskTO);
        }
    }
}

