/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.AbstractSchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.SchemaType;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.SchemaModalPageFactory;
import org.apache.syncope.console.commons.SelectChoiceRenderer;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.pages.AbstractSchemaModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.panels.JQueryUITabbedPanel;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ReflectionUtils;

public class Schema
extends BasePage {
    private static final long serialVersionUID = 8091922398776299403L;
    private static final Map<SchemaType, List<String>> COL_NAMES = new HashMap<SchemaType, List<String>>(){
        private static final long serialVersionUID = 3109256773218160485L;
        {
            this.put(SchemaType.NORMAL, Arrays.asList("name", "type", "mandatoryCondition", "uniqueConstraint", "multivalue", "readonly"));
            this.put(SchemaType.DERIVED, Arrays.asList("name", "expression"));
            this.put(SchemaType.VIRTUAL, Arrays.asList("name", "readonly"));
        }
    };
    private static final Map<Map.Entry<AttributableType, SchemaType>, String> PAGINATOR_ROWS_KEYS = new HashMap<Map.Entry<AttributableType, SchemaType>, String>(){
        private static final long serialVersionUID = 3109256773218160485L;
        {
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.CONFIGURATION, SchemaType.NORMAL), "conf.schema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.USER, SchemaType.NORMAL), "user.schema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.USER, SchemaType.DERIVED), "user.derived.schema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.USER, SchemaType.VIRTUAL), "user.virtual.schema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.MEMBERSHIP, SchemaType.NORMAL), "membership.schema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.MEMBERSHIP, SchemaType.DERIVED), "membership.derived.aschema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.MEMBERSHIP, SchemaType.VIRTUAL), "membership.virtual.aschema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.ROLE, SchemaType.NORMAL), "role.schema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.ROLE, SchemaType.DERIVED), "role.derived.schema.paginator.rows");
            this.put(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(AttributableType.ROLE, SchemaType.VIRTUAL), "role.virtual.schema.paginator.rows");
        }
    };
    private static final int WIN_WIDTH = 600;
    private static final int WIN_HEIGHT = 200;
    private static final int NORMAL_WIN_HEIGHT = 500;
    @SpringBean
    private SchemaRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final String allowedCreateRoles;
    private final String allowedReadRoles;
    private final String allowedDeleteRoles;

    public Schema() {
        this.allowedCreateRoles = this.xmlRolesReader.getEntitlement("Schema", "create");
        this.allowedReadRoles = this.xmlRolesReader.getEntitlement("Schema", "read");
        this.allowedDeleteRoles = this.xmlRolesReader.getEntitlement("Schema", "delete");
        for (final AttributableType attrType : AttributableType.values()) {
            String attrTypeAsString = attrType.name().toLowerCase();
            ArrayList<3> tabs = new ArrayList<3>();
            for (final SchemaType schemaType : SchemaType.values()) {
                if (attrType == AttributableType.CONFIGURATION && schemaType != SchemaType.NORMAL) continue;
                String schemaTypeAsString = schemaType.name().toLowerCase();
                tabs.add(new AbstractTab((IModel)new Model((Serializable)((Object)this.getString(schemaTypeAsString)))){
                    private static final long serialVersionUID = -5861786415855103549L;

                    public WebMarkupContainer getPanel(String panelId) {
                        return new SchemaTypePanel(panelId, attrType, schemaType);
                    }
                });
            }
            this.add(new Component[]{new JQueryUITabbedPanel(attrTypeAsString + "Tabs", tabs)});
        }
    }

    private <T extends AbstractSchemaModalPage> List<IColumn> getColumns(final WebMarkupContainer webContainer, final ModalWindow modalWindow, final AttributableType attributableType, final SchemaType schemaType, Collection<String> fields) {
        ArrayList<IColumn> columns = new ArrayList<IColumn>();
        for (final String field : fields) {
            Field clazzField = ReflectionUtils.findField((Class)schemaType.getToClass(), (String)field);
            if (clazzField == null) continue;
            if (clazzField.getType().equals(Boolean.class) || clazzField.getType().equals(Boolean.TYPE)) {
                columns.add((IColumn)new AbstractColumn<AbstractSchemaTO, String>((IModel)new ResourceModel(field)){
                    private static final long serialVersionUID = 8263694778917279290L;

                    public void populateItem(Item<ICellPopulator<AbstractSchemaTO>> item, String componentId, IModel<AbstractSchemaTO> model) {
                        BeanWrapperImpl bwi = new BeanWrapperImpl(model.getObject());
                        Object obj = bwi.getPropertyValue(field);
                        item.add(new Component[]{new Label(componentId, "")});
                        item.add(new Behavior[]{new AttributeModifier("class", (IModel)new Model((Serializable)((Object)obj.toString())))});
                    }

                    public String getCssClass() {
                        return "small_fixedsize";
                    }
                });
                continue;
            }
            PropertyColumn column = new PropertyColumn((IModel)new ResourceModel(field), field, field){
                private static final long serialVersionUID = 3282547854226892169L;

                public String getCssClass() {
                    String css = super.getCssClass();
                    if ("name".equals(field)) {
                        css = StringUtils.isBlank((CharSequence)css) ? "medium_fixedsize" : css + " medium_fixedsize";
                    }
                    return css;
                }
            };
            columns.add((IColumn)column);
        }
        columns.add((IColumn)new AbstractColumn<AbstractSchemaTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<AbstractSchemaTO>> item, String componentId, IModel<AbstractSchemaTO> model) {
                final AbstractSchemaTO schemaTO = (AbstractSchemaTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, Schema.this.getPageReference());
                panel.addWithRoles(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        modalWindow.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                AbstractSchemaTO page = SchemaModalPageFactory.getSchemaModalPage(attributableType, schemaType);
                                page.setSchemaModalPage(Schema.this.getPageReference(), modalWindow, (AbstractSchemaTO)schemaTO, false);
                                return page;
                            }
                        });
                        modalWindow.show(target);
                    }
                }, ActionLink.ActionType.EDIT, Schema.this.allowedReadRoles);
                panel.addWithRoles(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        switch (schemaType) {
                            case DERIVED: {
                                Schema.this.restClient.deleteDerSchema(attributableType, schemaTO.getName());
                                break;
                            }
                            case VIRTUAL: {
                                Schema.this.restClient.deleteVirSchema(attributableType, schemaTO.getName());
                                break;
                            }
                            default: {
                                Schema.this.restClient.deleteSchema(attributableType, schemaTO.getName());
                            }
                        }
                        Schema.this.info((Serializable)((Object)Schema.this.getString("operation_succeeded")));
                        Schema.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{webContainer});
                    }
                }, ActionLink.ActionType.DELETE, Schema.this.allowedDeleteRoles);
                item.add(new Component[]{panel});
            }
        });
        return columns;
    }

    private Form<Void> getPaginatorForm(final WebMarkupContainer webContainer, final AjaxFallbackDefaultDataTable dataTable, String formname, SchemaTypePanel schemaTypePanel, final String rowsPerPagePrefName) {
        Form form = new Form(formname);
        final DropDownChoice rowChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)schemaTypePanel, "pageRows"), this.prefMan.getPaginatorChoices(), new SelectChoiceRenderer());
        rowChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.prefMan.set(Schema.this.getRequest(), Schema.this.getResponse(), rowsPerPagePrefName, rowChooser.getInput());
                dataTable.setItemsPerPage((long)((Integer)rowChooser.getModelObject()).intValue());
                target.add(new Component[]{webContainer});
            }
        }});
        form.add(new Component[]{rowChooser});
        return form;
    }

    private <T extends AbstractSchemaModalPage> AjaxLink<Void> getCreateSchemaLink(final ModalWindow modalWindow, final AttributableType attrType, final SchemaType schemaType, String winLinkName) {
        ClearIndicatingAjaxLink<Void> link = new ClearIndicatingAjaxLink<Void>(winLinkName, this.getPageReference()){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                modalWindow.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        Object page = SchemaModalPageFactory.getSchemaModalPage(attrType, schemaType);
                        ((AbstractSchemaModalPage)((Object)page)).setSchemaModalPage(Schema.this.getPageReference(), modalWindow, null, true);
                        return page;
                    }
                });
                modalWindow.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)link, (Action)ENABLE, (String)this.allowedCreateRoles);
        return link;
    }

    private class SchemaTypePanel
    extends Panel {
        private static final long serialVersionUID = 2854050613688773575L;
        private int pageRows;
        private final AttributableType attrType;
        private final SchemaType schemaType;

        public SchemaTypePanel(String id, AttributableType attrType, SchemaType schemaType) {
            super(id);
            this.attrType = attrType;
            this.schemaType = schemaType;
            this.setup();
        }

        private void setup() {
            ModalWindow editSchemaWin = new ModalWindow("editSchemaWin");
            editSchemaWin.setCssClassName("w_silver");
            editSchemaWin.setInitialWidth(600);
            if (this.schemaType == SchemaType.NORMAL) {
                editSchemaWin.setInitialHeight(500);
            } else {
                editSchemaWin.setInitialHeight(200);
            }
            editSchemaWin.setCookieName("editSchemaWin");
            editSchemaWin.setMarkupId("editSchemaWin");
            this.add(new Component[]{editSchemaWin});
            WebMarkupContainer schemaWrapContainer = new WebMarkupContainer("schemaWrapContainer");
            schemaWrapContainer.setOutputMarkupId(true);
            if (this.schemaType != SchemaType.VIRTUAL) {
                schemaWrapContainer.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"width:auto;"))});
            }
            this.add(new Component[]{schemaWrapContainer});
            WebMarkupContainer schemaContainer = new WebMarkupContainer("schemaContainer");
            schemaContainer.setOutputMarkupId(true);
            schemaWrapContainer.add(new Component[]{schemaContainer});
            Schema.this.setWindowClosedCallback(editSchemaWin, schemaContainer);
            String paginatorRowsKey = (String)PAGINATOR_ROWS_KEYS.get(new AbstractMap.SimpleEntry<AttributableType, SchemaType>(this.attrType, this.schemaType));
            this.pageRows = Schema.this.prefMan.getPaginatorRows(this.getRequest(), paginatorRowsKey);
            List tableCols = Schema.this.getColumns(schemaContainer, editSchemaWin, this.attrType, this.schemaType, (Collection)COL_NAMES.get(this.schemaType));
            AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", tableCols, (ISortableDataProvider)new SchemaProvider(this.attrType, this.schemaType), this.pageRows);
            table.setOutputMarkupId(true);
            schemaContainer.add(new Component[]{table});
            schemaWrapContainer.add(new Component[]{Schema.this.getPaginatorForm(schemaContainer, table, "paginatorForm", this, paginatorRowsKey)});
            this.add(new Component[]{Schema.this.getCreateSchemaLink(editSchemaWin, this.attrType, this.schemaType, "createSchemaLink")});
        }
    }

    private class SchemaProvider
    extends SortableDataProvider<AbstractSchemaTO, String> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<AbstractSchemaTO> comparator;
        private final AttributableType attrType;
        private final SchemaType schemaType;

        public SchemaProvider(AttributableType attrType, SchemaType schemaType) {
            this.attrType = attrType;
            this.schemaType = schemaType;
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<AbstractSchemaTO>(this);
        }

        public Iterator<AbstractSchemaTO> iterator(long first, long count) {
            List<? extends AbstractSchemaTO> list = Schema.this.restClient.getSchemas(this.attrType, this.schemaType);
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return Schema.this.restClient.getSchemas(this.attrType, this.schemaType).size();
        }

        public IModel<AbstractSchemaTO> model(AbstractSchemaTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

