/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.AttributeSchemaType;
import org.apache.syncope.common.types.CipherAlgorithm;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.pages.AbstractSchemaModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.Strings;

public class SchemaModalPage
extends AbstractSchemaModalPage<SchemaTO> {
    private static final long serialVersionUID = -5991561277287424057L;

    public SchemaModalPage(AttributableType kind) {
        super(kind);
    }

    @Override
    public void setSchemaModalPage(final PageReference pageRef, final ModalWindow window, SchemaTO schemaTO, final boolean createFlag) {
        final SchemaTO schema = schemaTO == null ? new SchemaTO() : schemaTO;
        Form schemaForm = new Form("form");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        schemaForm.setOutputMarkupId(true);
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel<String>)new PropertyModel((Object)schema, "name"));
        name.addRequiredLabel();
        name.setEnabled(createFlag);
        schemaForm.add(new Component[]{name});
        final AjaxDropDownChoicePanel<AttributeSchemaType> type = new AjaxDropDownChoicePanel<AttributeSchemaType>("type", this.getString("type"), (IModel<AttributeSchemaType>)new PropertyModel((Object)schema, "type"));
        type.setChoices(Arrays.asList(AttributeSchemaType.values()));
        type.addRequiredLabel();
        schemaForm.add(new Component[]{type});
        final AjaxTextFieldPanel conversionPattern = new AjaxTextFieldPanel("conversionPattern", this.getString("conversionPattern"), (IModel<String>)new PropertyModel((Object)schema, "conversionPattern"));
        schemaForm.add(new Component[]{conversionPattern});
        final WebMarkupContainer conversionParams = new WebMarkupContainer("conversionParams");
        conversionParams.setOutputMarkupPlaceholderTag(true);
        conversionParams.add(new Component[]{conversionPattern});
        schemaForm.add(new Component[]{conversionParams});
        final WebMarkupContainer typeParams = new WebMarkupContainer("typeParams");
        typeParams.setOutputMarkupPlaceholderTag(true);
        final AjaxTextFieldPanel enumerationValuesPanel = new AjaxTextFieldPanel("panel", "enumerationValues", (IModel<String>)new Model(null));
        final MultiFieldPanel<String> enumerationValues = new MultiFieldPanel<String>("enumerationValues", (IModel<List<String>>)new Model(), enumerationValuesPanel);
        enumerationValues.setModelObject(this.getEnumValuesAsList(schema.getEnumerationValues()));
        final MultiFieldPanel<String> enumerationKeys = new MultiFieldPanel<String>("enumerationKeys", (IModel<List<String>>)new Model(), new AjaxTextFieldPanel("panel", "enumerationKeys", (IModel<String>)new Model(null)));
        enumerationKeys.setModelObject(this.getEnumValuesAsList(schema.getEnumerationKeys()));
        final WebMarkupContainer enumParams = new WebMarkupContainer("enumParams");
        enumParams.setOutputMarkupPlaceholderTag(true);
        enumParams.add(new Component[]{enumerationValues});
        enumParams.add(new Component[]{enumerationKeys});
        typeParams.add(new Component[]{enumParams});
        final AjaxTextFieldPanel secretKey = new AjaxTextFieldPanel("secretKey", this.getString("secretKey"), (IModel<String>)new PropertyModel((Object)schema, "secretKey"));
        final AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm = new AjaxDropDownChoicePanel<CipherAlgorithm>("cipherAlgorithm", this.getString("cipherAlgorithm"), (IModel<CipherAlgorithm>)new PropertyModel((Object)schema, "cipherAlgorithm"));
        cipherAlgorithm.setChoices(Arrays.asList(CipherAlgorithm.values()));
        final WebMarkupContainer encryptedParams = new WebMarkupContainer("encryptedParams");
        encryptedParams.setOutputMarkupPlaceholderTag(true);
        encryptedParams.add(new Component[]{secretKey});
        encryptedParams.add(new Component[]{cipherAlgorithm});
        typeParams.add(new Component[]{encryptedParams});
        final AjaxTextFieldPanel mimeType = new AjaxTextFieldPanel("mimeType", this.getString("mimeType"), (IModel<String>)new PropertyModel((Object)schema, "mimeType"));
        mimeType.setChoices(this.mimeTypesInitializer.getMimeTypes());
        final WebMarkupContainer binaryParams = new WebMarkupContainer("binaryParams");
        binaryParams.setOutputMarkupPlaceholderTag(true);
        binaryParams.add(new Component[]{mimeType});
        typeParams.add(new Component[]{binaryParams});
        schemaForm.add(new Component[]{typeParams});
        this.showHide(schema, type, conversionParams, conversionPattern, enumParams, enumerationValuesPanel, enumerationValues, enumerationKeys, encryptedParams, secretKey, cipherAlgorithm, binaryParams, mimeType);
        type.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                SchemaModalPage.this.showHide(schema, type, conversionParams, conversionPattern, enumParams, enumerationValuesPanel, enumerationValues, enumerationKeys, encryptedParams, secretKey, cipherAlgorithm, binaryParams, mimeType);
                target.add(new Component[]{conversionParams});
                target.add(new Component[]{typeParams});
            }
        }});
        LoadableDetachableModel<List<String>> validatorsList = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return SchemaModalPage.this.schemaRestClient.getAllValidatorClasses();
            }
        };
        AjaxDropDownChoicePanel validatorClass = new AjaxDropDownChoicePanel("validatorClass", this.getString("validatorClass"), new PropertyModel((Object)schema, "validatorClass"));
        ((DropDownChoice)validatorClass.getField()).setNullValid(true);
        validatorClass.setChoices((List)validatorsList.getObject());
        schemaForm.add(new Component[]{validatorClass});
        AutoCompleteTextField<String> mandatoryCondition = new AutoCompleteTextField<String>("mandatoryCondition"){
            private static final long serialVersionUID = -2428903969518079100L;

            protected Iterator<String> getChoices(String input) {
                List<Object> choices = new ArrayList();
                if (Strings.isEmpty((CharSequence)input)) {
                    choices = Collections.emptyList();
                } else if ("true".startsWith(input.toLowerCase())) {
                    choices.add("true");
                } else if ("false".startsWith(input.toLowerCase())) {
                    choices.add("false");
                }
                return choices.iterator();
            }
        };
        mandatoryCondition.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        schemaForm.add(new Component[]{mandatoryCondition});
        WebMarkupContainer pwdJexlHelp = JexlHelpUtil.getJexlHelpWebContainer("jexlHelp");
        AjaxLink<Void> pwdQuestionMarkJexlHelp = JexlHelpUtil.getAjaxLink(pwdJexlHelp, "questionMarkJexlHelp");
        schemaForm.add(new Component[]{pwdQuestionMarkJexlHelp});
        pwdQuestionMarkJexlHelp.add(new Component[]{pwdJexlHelp});
        AjaxCheckBoxPanel multivalue = new AjaxCheckBoxPanel("multivalue", this.getString("multivalue"), (IModel<Boolean>)new PropertyModel((Object)schema, "multivalue"));
        schemaForm.add(new Component[]{multivalue});
        AjaxCheckBoxPanel readonly = new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel<Boolean>)new PropertyModel((Object)schema, "readonly"));
        schemaForm.add(new Component[]{readonly});
        AjaxCheckBoxPanel uniqueConstraint = new AjaxCheckBoxPanel("uniqueConstraint", this.getString("uniqueConstraint"), (IModel<Boolean>)new PropertyModel((Object)schema, "uniqueConstraint"));
        schemaForm.add(new Component[]{uniqueConstraint});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SchemaTO schemaTO = (SchemaTO)form.getDefaultModelObject();
                schemaTO.setEnumerationValues(SchemaModalPage.this.getEnumValuesAsString(enumerationValues.getView().getModelObject()));
                schemaTO.setEnumerationKeys(SchemaModalPage.this.getEnumValuesAsString(enumerationKeys.getView().getModelObject()));
                if (schemaTO.isMultivalue() && schemaTO.isUniqueConstraint()) {
                    this.error((Serializable)((Object)this.getString("multivalueAndUniqueConstr.validation")));
                    SchemaModalPage.this.feedbackPanel.refresh(target);
                    return;
                }
                try {
                    if (createFlag) {
                        SchemaModalPage.this.schemaRestClient.createSchema(SchemaModalPage.this.kind, schemaTO);
                    } else {
                        SchemaModalPage.this.schemaRestClient.updateSchema(SchemaModalPage.this.kind, schemaTO);
                    }
                    if (pageRef.getPage() instanceof BasePage) {
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                    }
                    window.close(target);
                }
                catch (SyncopeClientException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    SchemaModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                SchemaModalPage.this.feedbackPanel.refresh(target);
            }
        };
        schemaForm.add(new Component[]{submit});
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        schemaForm.add(new Component[]{cancel});
        String allowedRoles = createFlag ? this.xmlRolesReader.getEntitlement("Schema", "create") : this.xmlRolesReader.getEntitlement("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{schemaForm});
    }

    private void showHide(SchemaTO schema, AjaxDropDownChoicePanel<AttributeSchemaType> type, WebMarkupContainer conversionParams, AjaxTextFieldPanel conversionPattern, WebMarkupContainer enumParams, AjaxTextFieldPanel enumerationValuesPanel, MultiFieldPanel<String> enumerationValues, MultiFieldPanel<String> enumerationKeys, WebMarkupContainer encryptedParams, AjaxTextFieldPanel secretKey, AjaxDropDownChoicePanel<CipherAlgorithm> cipherAlgorithm, WebMarkupContainer binaryParams, AjaxTextFieldPanel mimeType) {
        int typeOrdinal = Integer.parseInt(type.getField().getValue());
        if (AttributeSchemaType.Long.ordinal() == typeOrdinal || AttributeSchemaType.Double.ordinal() == typeOrdinal || AttributeSchemaType.Date.ordinal() == typeOrdinal) {
            conversionParams.setVisible(true);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject((Object)null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject((Object)null);
            binaryParams.setVisible(false);
            mimeType.setModelObject((Object)null);
        } else if (AttributeSchemaType.Enum.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject((Object)null);
            enumParams.setVisible(true);
            if (!enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.addRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(schema.getEnumerationValues()));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(schema.getEnumerationKeys()));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject((Object)null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject((Object)null);
            binaryParams.setVisible(false);
            mimeType.setModelObject((Object)null);
        } else if (AttributeSchemaType.Encrypted.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject((Object)null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(true);
            if (!secretKey.isRequired()) {
                secretKey.addRequiredLabel();
            }
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.addRequiredLabel();
            }
            binaryParams.setVisible(false);
            mimeType.setModelObject((Object)null);
        } else if (AttributeSchemaType.Binary.ordinal() == typeOrdinal) {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject((Object)null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject((Object)null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject((Object)null);
            binaryParams.setVisible(true);
        } else {
            conversionParams.setVisible(false);
            conversionPattern.setModelObject((Object)null);
            enumParams.setVisible(false);
            if (enumerationValuesPanel.isRequired()) {
                enumerationValuesPanel.removeRequiredLabel();
            }
            enumerationValues.setModelObject(this.getEnumValuesAsList(null));
            enumerationKeys.setModelObject(this.getEnumValuesAsList(null));
            encryptedParams.setVisible(false);
            if (secretKey.isRequired()) {
                secretKey.removeRequiredLabel();
            }
            secretKey.setModelObject((Object)null);
            if (cipherAlgorithm.isRequired()) {
                cipherAlgorithm.removeRequiredLabel();
            }
            cipherAlgorithm.setModelObject((Object)null);
            binaryParams.setVisible(false);
            mimeType.setModelObject((Object)null);
        }
    }

    private String getEnumValuesAsString(List<String> enumerationValues) {
        StringBuilder builder = new StringBuilder();
        for (String str : enumerationValues) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(str.trim());
        }
        return builder.toString();
    }

    private List<String> getEnumValuesAsList(String enumerationValues) {
        ArrayList<String> values = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)enumerationValues)) {
            for (String value : enumerationValues.split(";")) {
                values.add(value.trim());
            }
        } else {
            values.add("");
        }
        return values;
    }
}

