/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.SecurityQuestionTO;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.Configuration;
import org.apache.syncope.console.rest.SecurityQuestionRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

class SecurityQuestionModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -6709838862698327502L;
    @SpringBean
    private SecurityQuestionRestClient restClient;

    public SecurityQuestionModalPage(final PageReference pageRef, final ModalWindow window, final SecurityQuestionTO securityQuestionTO, final boolean createFlag) {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)securityQuestionTO));
        AjaxTextFieldPanel contentFieldPanel = new AjaxTextFieldPanel("content", "content", (IModel<String>)new PropertyModel((Object)securityQuestionTO, "content"));
        contentFieldPanel.setRequired(true);
        form.add(new Component[]{contentFieldPanel});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    if (createFlag) {
                        SecurityQuestionModalPage.this.restClient.create(securityQuestionTO);
                    } else {
                        SecurityQuestionModalPage.this.restClient.update(securityQuestionTO);
                    }
                    this.info((Serializable)((Object)this.getString("operation_succeeded")));
                    Configuration callerPage = (Configuration)pageRef.getPage();
                    callerPage.setModalResult(true);
                    window.close(target);
                }
                catch (SyncopeClientException scee) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + scee.getMessage())));
                    SecurityQuestionModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                SecurityQuestionModalPage.this.feedbackPanel.refresh(target);
            }
        };
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        String allowedRoles = createFlag ? this.xmlRolesReader.getEntitlement("SecurityQuestion", "create") : this.xmlRolesReader.getEntitlement("SecurityQuestion", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add(new Component[]{cancel});
        this.add(new Component[]{form});
    }
}

