/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.ResourceAssociationActionType;
import org.apache.syncope.console.commons.status.AbstractStatusBeanProvider;
import org.apache.syncope.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.console.commons.status.Status;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.AbstractStatusModalPage;
import org.apache.syncope.console.pages.ActionResultModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.BulkActionResultModalPage;
import org.apache.syncope.console.pages.panels.ActionDataTablePanel;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class StatusModalPage<T extends AbstractSubjectTO>
extends AbstractStatusModalPage {
    private static final long serialVersionUID = -9148734710505211261L;
    private final AbstractSubjectTO subjectTO;
    private int rowsPerPage = 10;
    final StatusUtils statusUtils;
    final boolean statusOnly;
    final ClearIndicatingAjaxButton cancel;
    final WebMarkupContainer pwdMgt;
    final Form<?> pwdMgtForm;
    final AjaxCheckBoxPanel changepwd;
    final PasswordTextField password;
    final PasswordTextField confirm;
    final PageReference pageRef;
    final ModalWindow window;
    final ActionDataTablePanel<StatusBean, String> table;
    final List<IColumn<StatusBean, String>> columns;

    public StatusModalPage(PageReference pageRef, ModalWindow window, AbstractSubjectTO attributableTO) {
        this(pageRef, window, attributableTO, false);
    }

    public StatusModalPage(final PageReference pageRef, final ModalWindow window, final AbstractSubjectTO subjectTO, final boolean statusOnly) {
        this.pageRef = pageRef;
        this.window = window;
        this.statusOnly = statusOnly;
        this.subjectTO = subjectTO;
        this.statusUtils = new StatusUtils(subjectTO instanceof UserTO ? this.userRestClient : this.roleRestClient);
        this.columns = new ArrayList<IColumn<StatusBean, String>>();
        this.columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("resourceName", (Component)this, null, "Resource name", new Object[0]), "resourceName"){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, final IModel<StatusBean> model) {
                cellItem.add(new Component[]{new Label(componentId, ((StatusBean)model.getObject()).getResourceName()){
                    private static final long serialVersionUID = 8432079838783825801L;

                    protected void onComponentTag(ComponentTag tag) {
                        if (((StatusBean)model.getObject()).isLinked()) {
                            super.onComponentTag(tag);
                        } else {
                            tag.put("style", (CharSequence)"color: #DDDDDD");
                        }
                    }
                }});
            }
        });
        this.columns.add((IColumn<StatusBean, String>)new PropertyColumn((IModel)new StringResourceModel("accountLink", (Component)this, null, "Account link", new Object[0]), (Object)"accountLink", "accountLink"));
        this.columns.add((IColumn<StatusBean, String>)new AbstractColumn<StatusBean, String>((IModel)new StringResourceModel("status", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = -3503023501954863131L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<StatusBean>> cellItem, String componentId, IModel<StatusBean> model) {
                if (((StatusBean)model.getObject()).isLinked()) {
                    cellItem.add(new Component[]{StatusModalPage.this.statusUtils.getStatusImagePanel(componentId, ((StatusBean)model.getObject()).getStatus())});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "")});
                }
            }
        });
        this.table = new ActionDataTablePanel<StatusBean, String>("resourceDatatable", this.columns, (ISortableDataProvider)new AttributableStatusProvider(), this.rowsPerPage, pageRef){
            private static final long serialVersionUID = 6510391461033818316L;

            @Override
            public boolean isElementEnabled(StatusBean element) {
                return !statusOnly || element.getStatus() != Status.OBJECT_NOT_FOUND;
            }
        };
        this.table.setOutputMarkupId(true);
        String pageId = subjectTO instanceof RoleTO ? "Roles" : "Users";
        Fragment pwdMgtFragment = new Fragment("pwdMgtFields", "pwdMgtFragment", (MarkupContainer)this);
        this.addOrReplace(new Component[]{pwdMgtFragment});
        this.pwdMgt = new WebMarkupContainer("pwdMgt");
        pwdMgtFragment.add(new Component[]{this.pwdMgt.setOutputMarkupId(true)});
        this.pwdMgtForm = new Form("pwdMgtForm");
        this.pwdMgtForm.setVisible(false).setEnabled(false);
        this.pwdMgt.add(new Component[]{this.pwdMgtForm});
        this.password = new PasswordTextField("password", (IModel)new Model());
        this.pwdMgtForm.add(new Component[]{this.password.setRequired(false).setEnabled(false)});
        this.confirm = new PasswordTextField("confirm", (IModel)new Model());
        this.pwdMgtForm.add(new Component[]{this.confirm.setRequired(false).setEnabled(false)});
        this.changepwd = new AjaxCheckBoxPanel("changepwd", "changepwd", (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(false)));
        this.pwdMgtForm.add(new Component[]{this.changepwd.setModelObject((Object)false)});
        this.pwdMgtForm.add(new Component[]{new Label("changePwdLabel", (IModel)new ResourceModel("changePwdLabel", "Password propagation"))});
        this.changepwd.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                StatusModalPage.this.password.setEnabled(((Boolean)StatusModalPage.this.changepwd.getModelObject()).booleanValue());
                StatusModalPage.this.confirm.setEnabled(((Boolean)StatusModalPage.this.changepwd.getModelObject()).booleanValue());
                target.add(new Component[]{StatusModalPage.this.pwdMgt});
            }
        }});
        this.cancel = new ClearIndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel"), pageRef){
            private static final long serialVersionUID = -2341391430136818026L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        }.feedbackPanelAutomaticReload(false);
        this.pwdMgtForm.add(new Component[]{this.cancel});
        ClearIndicatingAjaxButton goon = new ClearIndicatingAjaxButton("continue", (IModel)new ResourceModel("continue"), pageRef){
            private static final long serialVersionUID = -2341391430136818027L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
            }
        };
        this.pwdMgtForm.add(new Component[]{goon});
        if (statusOnly) {
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    try {
                        StatusModalPage.this.userRestClient.reactivate(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                        StatusModalPage.this.setResponsePage((Page)new ActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns));
                    }
                    catch (Exception e) {
                        AbstractBasePage.LOG.error("Error enabling resources", (Throwable)e);
                        StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                        StatusModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }, ActionLink.ActionType.REACTIVATE, pageId);
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    try {
                        StatusModalPage.this.userRestClient.suspend(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        if (pageRef.getPage() instanceof BasePage) {
                            ((BasePage)pageRef.getPage()).setModalResult(true);
                        }
                        StatusModalPage.this.setResponsePage((Page)new ActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns));
                    }
                    catch (Exception e) {
                        AbstractBasePage.LOG.error("Error disabling resources", (Throwable)e);
                        StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                        StatusModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }, ActionLink.ActionType.SUSPEND, pageId);
        } else {
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    try {
                        if (subjectTO instanceof UserTO) {
                            StatusModalPage.this.userRestClient.unlink(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        } else {
                            StatusModalPage.this.roleRestClient.unlink(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        }
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                        StatusModalPage.this.setResponsePage((Page)new ActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns));
                    }
                    catch (Exception e) {
                        AbstractBasePage.LOG.error("Error unlinking resources", (Throwable)e);
                        StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                        StatusModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }, ActionLink.ActionType.UNLINK, pageId);
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    try {
                        if (subjectTO instanceof UserTO) {
                            StatusModalPage.this.userRestClient.link(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        } else {
                            StatusModalPage.this.roleRestClient.link(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        }
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                        StatusModalPage.this.setResponsePage((Page)new ActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns));
                    }
                    catch (Exception e) {
                        AbstractBasePage.LOG.error("Error linking resources", (Throwable)e);
                        StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                        StatusModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }, ActionLink.ActionType.LINK, pageId);
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    try {
                        BulkActionResult bulkActionResult = subjectTO instanceof UserTO ? StatusModalPage.this.userRestClient.deprovision(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject())) : StatusModalPage.this.roleRestClient.deprovision(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                        StatusModalPage.this.setResponsePage((Page)new BulkActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns, bulkActionResult, "resourceName"));
                    }
                    catch (Exception e) {
                        AbstractBasePage.LOG.error("Error de-provisioning user", (Throwable)e);
                        StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                        StatusModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }, ActionLink.ActionType.DEPROVISION, pageId);
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    if (subjectTO instanceof UserTO) {
                        StatusModalPage.this.passwordManagement(target, ResourceAssociationActionType.PROVISION, StatusModalPage.this.table.getModelObject());
                    } else {
                        try {
                            BulkActionResult bulkActionResult = StatusModalPage.this.roleRestClient.provision(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                            ((BasePage)pageRef.getPage()).setModalResult(true);
                            StatusModalPage.this.setResponsePage((Page)new BulkActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns, bulkActionResult, "resourceName"));
                        }
                        catch (Exception e) {
                            AbstractBasePage.LOG.error("Error provisioning user", (Throwable)e);
                            StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                            StatusModalPage.this.feedbackPanel.refresh(target);
                        }
                    }
                }
            }.feedbackPanelAutomaticReload(!(subjectTO instanceof UserTO)), ActionLink.ActionType.PROVISION, pageId);
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    try {
                        BulkActionResult bulkActionResult = subjectTO instanceof UserTO ? StatusModalPage.this.userRestClient.unassign(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject())) : StatusModalPage.this.roleRestClient.unassign(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                        StatusModalPage.this.setResponsePage((Page)new BulkActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns, bulkActionResult, "resourceName"));
                    }
                    catch (Exception e) {
                        AbstractBasePage.LOG.error("Error unassigning resources", (Throwable)e);
                        StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                        StatusModalPage.this.feedbackPanel.refresh(target);
                    }
                }
            }, ActionLink.ActionType.UNASSIGN, pageId);
            this.table.addAction(new ActionLink(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    if (subjectTO instanceof UserTO) {
                        StatusModalPage.this.passwordManagement(target, ResourceAssociationActionType.ASSIGN, StatusModalPage.this.table.getModelObject());
                    } else {
                        try {
                            BulkActionResult bulkActionResult = StatusModalPage.this.roleRestClient.assign(subjectTO.getETagValue(), subjectTO.getId(), new ArrayList<StatusBean>(StatusModalPage.this.table.getModelObject()));
                            ((BasePage)pageRef.getPage()).setModalResult(true);
                            StatusModalPage.this.setResponsePage((Page)new BulkActionResultModalPage(window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns, bulkActionResult, "resourceName"));
                        }
                        catch (Exception e) {
                            AbstractBasePage.LOG.error("Error assigning resources", (Throwable)e);
                            StatusModalPage.this.error((Serializable)((Object)(StatusModalPage.this.getString("error") + ": " + e.getMessage())));
                            StatusModalPage.this.feedbackPanel.refresh(target);
                        }
                    }
                }
            }.feedbackPanelAutomaticReload(!(subjectTO instanceof UserTO)), ActionLink.ActionType.ASSIGN, pageId);
        }
        this.table.addCancelButton(window);
        this.add(new Component[]{this.table});
    }

    private void passwordManagement(AjaxRequestTarget target, final ResourceAssociationActionType type, final Collection<StatusBean> selection) {
        ClearIndicatingAjaxButton goon = new ClearIndicatingAjaxButton("continue", (IModel)new ResourceModel("continue", "Continue"), this.pageRef){
            private static final long serialVersionUID = -2341391430136818027L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                try {
                    BulkActionResult bulkActionResult;
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)StatusModalPage.this.password.getModelObject())) && !((String)StatusModalPage.this.password.getModelObject()).equals(StatusModalPage.this.confirm.getModelObject())) {
                        throw new Exception(this.getString("passwordMismatch"));
                    }
                    switch (type) {
                        case ASSIGN: {
                            bulkActionResult = StatusModalPage.this.userRestClient.assign(StatusModalPage.this.subjectTO.getETagValue(), StatusModalPage.this.subjectTO.getId(), new ArrayList<StatusBean>(selection), (Boolean)StatusModalPage.this.changepwd.getModelObject(), (String)StatusModalPage.this.password.getModelObject());
                            break;
                        }
                        case PROVISION: {
                            bulkActionResult = StatusModalPage.this.userRestClient.provision(StatusModalPage.this.subjectTO.getETagValue(), StatusModalPage.this.subjectTO.getId(), new ArrayList<StatusBean>(selection), (Boolean)StatusModalPage.this.changepwd.getModelObject(), (String)StatusModalPage.this.password.getModelObject());
                            break;
                        }
                        default: {
                            bulkActionResult = null;
                        }
                    }
                    ((BasePage)StatusModalPage.this.pageRef.getPage()).setModalResult(true);
                    if (bulkActionResult != null) {
                        this.setResponsePage((Page)new BulkActionResultModalPage(StatusModalPage.this.window, StatusModalPage.this.getStatusBeans(StatusModalPage.this.table.getModelObject()), StatusModalPage.this.columns, bulkActionResult, "resourceName"));
                    } else {
                        target.add(new Component[]{((BasePage)StatusModalPage.this.pageRef.getPage()).getFeedbackPanel()});
                        StatusModalPage.this.window.close(target);
                    }
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("Error provisioning resources", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    StatusModalPage.this.feedbackPanel.refresh(target);
                }
            }
        }.feedbackPanelAutomaticReload(false);
        this.pwdMgtForm.addOrReplace(new Component[]{goon});
        this.table.setVisible(false);
        this.pwdMgtForm.setVisible(true).setEnabled(true);
        target.add(new Component[]{this.table});
        target.add(new Component[]{this.pwdMgt});
    }

    private List<StatusBean> getStatusBeans(Collection<StatusBean> selection) {
        ArrayList<String> resources = new ArrayList<String>(selection.size());
        for (StatusBean statusBean : selection) {
            resources.add(statusBean.getResourceName());
        }
        List<ConnObjectWrapper> connObjects = this.statusUtils.getConnectorObjects(Collections.singletonList(this.subjectTO), resources);
        ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size());
        for (ConnObjectWrapper entry : connObjects) {
            StatusBean statusBean = "Syncope".equals(entry.getResourceName()) ? this.getCurrentSyncopeStatusBean() : this.statusUtils.getStatusBean((AbstractAttributableTO)this.subjectTO, entry.getResourceName(), entry.getConnObjectTO(), this.subjectTO instanceof RoleTO);
            statusBeans.add(statusBean);
        }
        return statusBeans;
    }

    private StatusBean getCurrentSyncopeStatusBean() {
        StatusBean syncope = new StatusBean((AbstractAttributableTO)this.subjectTO, "Syncope");
        syncope.setAccountLink(((UserTO)this.subjectTO).getUsername());
        Status syncopeStatus = Status.UNDEFINED;
        try {
            syncopeStatus = Status.valueOf(this.userRestClient.read(this.subjectTO.getId()).getStatus().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unexpected status found: {}", (Object)((UserTO)this.subjectTO).getStatus(), (Object)e);
        }
        syncope.setStatus(syncopeStatus);
        return syncope;
    }

    private class AttributableStatusProvider
    extends AbstractStatusBeanProvider {
        private static final long serialVersionUID = 4586969457669796621L;

        public AttributableStatusProvider() {
            super(StatusModalPage.this.statusOnly ? "resourceName" : "accountLink");
        }

        @Override
        public List<StatusBean> getStatusBeans() {
            StatusBean statusBean;
            ArrayList<String> resources = new ArrayList<String>();
            for (ResourceTO resourceTO : StatusModalPage.this.resourceRestClient.getAll()) {
                resources.add(resourceTO.getName());
            }
            List<ConnObjectWrapper> connObjects = StatusModalPage.this.statusUtils.getConnectorObjects(StatusModalPage.this.subjectTO);
            ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size() + 1);
            for (ConnObjectWrapper entry : connObjects) {
                statusBean = StatusModalPage.this.statusUtils.getStatusBean((AbstractAttributableTO)StatusModalPage.this.subjectTO, entry.getResourceName(), entry.getConnObjectTO(), StatusModalPage.this.subjectTO instanceof RoleTO);
                statusBeans.add(statusBean);
                resources.remove(entry.getResourceName());
            }
            if (StatusModalPage.this.statusOnly) {
                StatusBean syncope = new StatusBean((AbstractAttributableTO)StatusModalPage.this.subjectTO, "Syncope");
                syncope.setAccountLink(((UserTO)StatusModalPage.this.subjectTO).getUsername());
                Status syncopeStatus = Status.UNDEFINED;
                if (((UserTO)StatusModalPage.this.subjectTO).getStatus() != null) {
                    try {
                        syncopeStatus = Status.valueOf(((UserTO)StatusModalPage.this.subjectTO).getStatus().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        AbstractBasePage.LOG.warn("Unexpected status found: {}", (Object)((UserTO)StatusModalPage.this.subjectTO).getStatus(), (Object)e);
                    }
                }
                syncope.setStatus(syncopeStatus);
                statusBeans.add(syncope);
            } else {
                for (String resource : resources) {
                    statusBean = StatusModalPage.this.statusUtils.getStatusBean((AbstractAttributableTO)StatusModalPage.this.subjectTO, resource, null, StatusModalPage.this.subjectTO instanceof RoleTO);
                    statusBean.setLinked(false);
                    statusBeans.add(statusBean);
                }
            }
            return statusBeans;
        }
    }
}

