/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.TaskExecTO;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.ExecMessageModalPage;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.springframework.util.StringUtils;

public abstract class TaskModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -4110576026663173545L;
    protected WebMarkupContainer profile;
    protected WebMarkupContainer executions;
    protected Form<AbstractTaskTO> form;

    public TaskModalPage(final AbstractTaskTO taskTO) {
        final ModalWindow taskExecMessageWin = new ModalWindow("taskExecMessageWin");
        taskExecMessageWin.setCssClassName("w_silver");
        taskExecMessageWin.setCookieName("task-exec-message-win-modal");
        this.add(new Component[]{taskExecMessageWin});
        this.form = new Form("form");
        this.form.setModel((IModel)new CompoundPropertyModel((Object)taskTO));
        this.add(new Component[]{this.form});
        this.profile = new WebMarkupContainer("profile");
        this.profile.setOutputMarkupId(true);
        this.form.add(new Component[]{this.profile});
        this.executions = new WebMarkupContainer("executionContainer");
        this.executions.setOutputMarkupId(true);
        this.form.add(new Component[]{this.executions});
        Label idLabel = new Label("idLabel", (IModel)new ResourceModel("id"));
        this.profile.add(new Component[]{idLabel});
        AjaxTextFieldPanel id = new AjaxTextFieldPanel("id", this.getString("id"), (IModel<String>)new PropertyModel((Object)taskTO, "id"));
        id.setEnabled(false);
        this.profile.add(new Component[]{id});
        final ArrayList<Object> columns = new ArrayList<Object>();
        int paginatorRows = 10;
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("startDate"), "startDate", "startDate"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("endDate"), "endDate", "endDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("status"), (Object)"status", "status"));
        columns.add(new ActionColumn<TaskExecTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public ActionLinksPanel getActions(String componentId, final IModel<TaskExecTO> model) {
                final TaskExecTO taskExecutionTO = (TaskExecTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, TaskModalPage.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        taskExecMessageWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ExecMessageModalPage(((TaskExecTO)model.getObject()).getMessage());
                            }
                        });
                        taskExecMessageWin.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Tasks", StringUtils.hasText((String)((TaskExecTO)model.getObject()).getMessage()));
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            TaskModalPage.this.taskRestClient.deleteExecution(taskExecutionTO.getId());
                            taskTO.getExecutions().remove(taskExecutionTO);
                            TaskModalPage.this.info((Serializable)((Object)TaskModalPage.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            TaskModalPage.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        TaskModalPage.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{TaskModalPage.this.executions});
                    }
                }, ActionLink.ActionType.DELETE, "Tasks");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), TaskModalPage.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            AjaxFallbackDefaultDataTable currentTable = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new TaskExecutionsProvider(taskTO.getId(), 10), 10);
                            currentTable.setOutputMarkupId(true);
                            target.add(new Component[]{currentTable});
                            TaskModalPage.this.executions.addOrReplace(new Component[]{currentTable});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new TaskExecutionsProvider(taskTO.getId(), 10), 10);
        this.executions.add(new Component[]{table});
    }

    protected class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecTO, String> {
        private static final long serialVersionUID = 8943636537120648961L;
        private final SortableDataProviderComparator<TaskExecTO> comparator;
        private final Long taskId;
        private final int paginatorRows;

        public TaskExecutionsProvider(Long taskId, int paginatorRows) {
            this.taskId = taskId;
            this.paginatorRows = paginatorRows;
            this.setSort("startDate", SortOrder.DESCENDING);
            this.comparator = new SortableDataProviderComparator<TaskExecTO>(this);
        }

        public Iterator<TaskExecTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            List<TaskExecTO> list = TaskModalPage.this.taskRestClient.listExecutions(this.taskId, (page < 0 ? 0 : page) + 1, this.paginatorRows);
            Collections.sort(list, this.comparator);
            return list.iterator();
        }

        public long size() {
            return TaskModalPage.this.taskRestClient.countExecutions(this.taskId);
        }

        public IModel<TaskExecTO> model(final TaskExecTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecTO>(){
                private static final long serialVersionUID = 7485475149862342421L;

                public TaskExecTO getObject() {
                    return taskExecution;
                }
            };
        }
    }
}

