/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.common.to.TaskExecTO;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.panels.AjaxDataTablePanel;
import org.apache.syncope.console.pages.panels.NotificationTasks;
import org.apache.syncope.console.pages.panels.PropagationTasks;
import org.apache.syncope.console.pages.panels.PushTasksPanel;
import org.apache.syncope.console.pages.panels.SchedTasks;
import org.apache.syncope.console.pages.panels.SyncTasksPanel;
import org.apache.syncope.console.rest.BaseRestClient;
import org.apache.syncope.console.rest.TaskRestClient;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

public class Tasks
extends BasePage {
    private static final long serialVersionUID = 5289215853622289061L;

    public Tasks() {
        this.add(new Component[]{new PropagationTasks("propagation", this.getPageReference())});
        this.add(new Component[]{new NotificationTasks("notification", this.getPageReference())});
        this.add(new Component[]{new SchedTasks("sched", this.getPageReference())});
        this.add(new Component[]{new SyncTasksPanel("sync", this.getPageReference())});
        this.add(new Component[]{new PushTasksPanel("push", this.getPageReference())});
        this.getPageReference();
    }

    @Override
    public void setWindowClosedCallback(ModalWindow window, WebMarkupContainer container) {
        super.setWindowClosedCallback(window, container);
    }

    public static AjaxDataTablePanel<AbstractTaskTO, String> updateTaskTable(List<IColumn<AbstractTaskTO, String>> columns, TasksProvider<? extends AbstractTaskTO> dataProvider, WebMarkupContainer container, int currentPage, PageReference pageRef, BaseRestClient restClient) {
        AjaxDataTablePanel<AbstractTaskTO, String> table = new AjaxDataTablePanel<AbstractTaskTO, String>("datatable", columns, (ISortableDataProvider<AbstractTaskTO, String>)dataProvider, ((TasksProvider)dataProvider).paginatorRows, (Collection<ActionLink.ActionType>)Arrays.asList(ActionLink.ActionType.DELETE, ActionLink.ActionType.DRYRUN, ActionLink.ActionType.EXECUTE), restClient, "id", "Tasks", pageRef);
        table.setCurrentPage(currentPage);
        table.setOutputMarkupId(true);
        container.addOrReplace(new Component[]{table});
        return table;
    }

    @Override
    public String getAjaxIndicatorMarkupId() {
        return "";
    }

    public static class TasksProvider<T extends AbstractTaskTO>
    extends SortableDataProvider<T, String> {
        private static final long serialVersionUID = -20112718133295756L;
        private final SortableDataProviderComparator<T> comparator;
        private final TaskRestClient restClient;
        private final int paginatorRows;
        private final String id;
        private final Class<T> reference;

        public TasksProvider(TaskRestClient restClient, int paginatorRows, String id, Class<T> reference) {
            this.setSort("id", SortOrder.DESCENDING);
            this.comparator = new SortableDataProviderComparator(this);
            this.paginatorRows = paginatorRows;
            this.restClient = restClient;
            this.id = id;
            this.reference = reference;
        }

        public Iterator<T> iterator(long first, long count) {
            ArrayList<AbstractTaskTO> tasks = new ArrayList<AbstractTaskTO>();
            int page = (int)first / this.paginatorRows;
            for (AbstractTaskTO task : this.restClient.list(this.reference, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort())) {
                if (task instanceof SchedTaskTO && ((SchedTaskTO)task).getLastExec() == null && task.getExecutions() != null && !task.getExecutions().isEmpty()) {
                    Collections.sort(task.getExecutions(), new Comparator<TaskExecTO>(){

                        @Override
                        public int compare(TaskExecTO left, TaskExecTO right) {
                            return left.getStartDate().compareTo(right.getStartDate());
                        }
                    });
                    ((SchedTaskTO)task).setLastExec(((TaskExecTO)task.getExecutions().get(task.getExecutions().size() - 1)).getStartDate());
                }
                tasks.add(task);
            }
            Collections.sort(tasks, this.comparator);
            return tasks.iterator();
        }

        public long size() {
            return this.restClient.count(this.id);
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }

    public static class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecTO, String> {
        private static final long serialVersionUID = -5401263348984206145L;
        private final SortableDataProviderComparator<TaskExecTO> comparator;
        private final AbstractTaskTO taskTO;

        public TaskExecutionsProvider(AbstractTaskTO taskTO) {
            this.taskTO = taskTO;
            this.setSort("startDate", SortOrder.DESCENDING);
            this.comparator = new SortableDataProviderComparator<TaskExecTO>(this);
        }

        public Iterator<TaskExecTO> iterator(long first, long count) {
            List<TaskExecTO> list = this.getTaskDB();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.getTaskDB().size();
        }

        public IModel<TaskExecTO> model(final TaskExecTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecTO>(){
                private static final long serialVersionUID = 7485475149862342421L;

                public TaskExecTO getObject() {
                    return taskExecution;
                }
            };
        }

        public List<TaskExecTO> getTaskDB() {
            return this.taskTO.getExecutions();
        }
    }
}

