/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.WorkflowFormTO;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.pages.ApprovalModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.rest.ApprovalRestClient;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Todo
extends BasePage {
    private static final long serialVersionUID = -7122136682275797903L;
    @SpringBean
    private ApprovalRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow window;
    private static final int WIN_HEIGHT = 400;
    private static final int WIN_WIDTH = 600;
    private WebMarkupContainer container;
    private int paginatorRows;

    public Todo(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("editApprovalWin");
        componentArray[0] = this.window;
        this.add(componentArray);
        this.container = new WebMarkupContainer("approvalContainer");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.container, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Approval", "list"));
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "todo.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("taskId"), (Object)"taskId", "taskId"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("createTime"), "createTime", "createTime"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new ResourceModel("dueDate"), "dueDate", "dueDate"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("owner"), (Object)"owner", "owner"));
        columns.add(new AbstractColumn<WorkflowFormTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<WorkflowFormTO>> cellItem, String componentId, IModel<WorkflowFormTO> model) {
                final WorkflowFormTO formTO = (WorkflowFormTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, Todo.this.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Todo.this.restClient.claimForm(formTO.getTaskId());
                            Todo.this.info((Serializable)((Object)Todo.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scee) {
                            Todo.this.error((Serializable)((Object)(Todo.this.getString("error") + ": " + scee.getMessage())));
                        }
                        Todo.this.feedbackPanel.refresh(target);
                        target.add(new Component[]{Todo.this.container});
                    }
                }, ActionLink.ActionType.CLAIM, "Approval");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        Todo.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ApprovalModalPage(Todo.this.getPageReference(), Todo.this.window, formTO);
                            }
                        });
                        Todo.this.window.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Approval", SyncopeSession.get().getUsername().equals(formTO.getOwner()));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable approvalTable = new AjaxFallbackDefaultDataTable("approvalTable", columns, (ISortableDataProvider)new ApprovalProvider(), this.paginatorRows);
        this.container.add(new Component[]{approvalTable});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        Form approvalPaginatorForm = new Form("paginatorForm");
        MetaDataRoleAuthorizationStrategy.authorize((Component)approvalPaginatorForm, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Approval", "list"));
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Todo.this.prefMan.set(Todo.this.getRequest(), Todo.this.getResponse(), "todo.paginator.rows", String.valueOf(Todo.this.paginatorRows));
                approvalTable.setItemsPerPage((long)Todo.this.paginatorRows);
                target.add(new Component[]{Todo.this.container});
            }
        }});
        approvalPaginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{approvalPaginatorForm});
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(400);
        this.window.setInitialWidth(600);
        this.window.setCookieName("edit-approval-modal");
        this.setWindowClosedCallback(this.window, this.container);
    }

    private class ApprovalProvider
    extends SortableDataProvider<WorkflowFormTO, String> {
        private static final long serialVersionUID = -2311716167583335852L;
        private final SortableDataProviderComparator<WorkflowFormTO> comparator;

        public ApprovalProvider() {
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<WorkflowFormTO>(this);
        }

        public Iterator<WorkflowFormTO> iterator(long first, long count) {
            List<WorkflowFormTO> list = Todo.this.restClient.getForms();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return Todo.this.restClient.getForms().size();
        }

        public IModel<WorkflowFormTO> model(final WorkflowFormTO configuration) {
            return new AbstractReadOnlyModel<WorkflowFormTO>(){
                private static final long serialVersionUID = -2566070996511906708L;

                public WorkflowFormTO getObject() {
                    return configuration;
                }
            };
        }
    }
}

