/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.panels.AttributesPanel;
import org.apache.syncope.console.pages.panels.DerivedAttributesPanel;
import org.apache.syncope.console.pages.panels.MembershipsPanel;
import org.apache.syncope.console.pages.panels.ResourcesPanel;
import org.apache.syncope.console.pages.panels.SecurityQuestionPanel;
import org.apache.syncope.console.pages.panels.UserDetailsPanel;
import org.apache.syncope.console.pages.panels.VirtualAttributesPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public abstract class UserModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 5002005009737457667L;
    protected final PageReference pageRef;
    protected final ModalWindow window;
    protected UserTO userTO;
    protected final Mode mode;
    private Fragment fragment = null;
    private final boolean resetPassword;
    protected final AjaxCheckBoxPanel storePassword;

    public UserModalPage(PageReference callerPageRef, ModalWindow window, UserTO userTO, Mode mode, boolean resetPassword) {
        this.pageRef = callerPageRef;
        this.window = window;
        this.userTO = userTO;
        this.mode = mode;
        this.resetPassword = resetPassword;
        this.fragment = new Fragment("userModalFrag", "userModalEditFrag", (MarkupContainer)this);
        this.fragment.setOutputMarkupId(true);
        this.add(new Component[]{this.fragment});
        this.storePassword = new AjaxCheckBoxPanel("storePassword", "storePassword", (IModel<Boolean>)new Model((Serializable)Boolean.TRUE));
    }

    public UserTO getUserTO() {
        return this.userTO;
    }

    public void setUserTO(UserTO userTO) {
        this.userTO = userTO;
    }

    protected Form<UserTO> setupEditPanel() {
        this.fragment.add(new Component[]{new Label("id", this.userTO.getId() == 0L ? "" : this.userTO.getUsername())});
        this.fragment.add(new Component[]{new Label("new", (IModel)(this.userTO.getId() == 0L ? new ResourceModel("new") : new Model((Serializable)((Object)""))))});
        Form form = new Form("UserForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)this.userTO));
        form.add(new Component[]{new UserDetailsPanel("details", this.userTO, form, this.resetPassword, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new Label("statuspanel", "")});
        form.add(new Component[]{new Label("pwdChangeInfo", "")});
        form.add(new Component[]{new Label("securityQuestion", "")});
        form.addOrReplace(new Component[]{new SecurityQuestionPanel("securityQuestion", this.userTO)});
        form.add(new Component[]{new Label("accountinformation", "")});
        Fragment storePwdFragment = new Fragment("storePwdFrag", "storePwdCheck", (MarkupContainer)form);
        storePwdFragment.setOutputMarkupId(true);
        Label storePasswordLabel = new Label("storePasswordLabel", (IModel)new ResourceModel("storePassword"));
        storePwdFragment.add(new Component[]{storePasswordLabel});
        storePwdFragment.add(new Component[]{this.storePassword});
        form.add(new Component[]{this.userTO.getId() == 0L && this.mode != Mode.TEMPLATE ? storePwdFragment : new Fragment("storePwdFrag", "emptyFragment", (MarkupContainer)form)});
        form.add(new Component[]{new AttributesPanel("attrs", this.userTO, form, this.mode)});
        form.add(new Component[]{new DerivedAttributesPanel("derAttrs", this.userTO)});
        form.add(new Component[]{new VirtualAttributesPanel("virAttrs", this.userTO, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new ResourcesPanel.Builder("resources").attributableTO(this.userTO).build()});
        form.add(new Component[]{new MembershipsPanel("memberships", this.userTO, this.mode, null, this.getPageReference())});
        AjaxButton submit = this.getOnSubmit();
        if (this.mode == Mode.ADMIN) {
            String allowedRoles = this.userTO.getId() == 0L ? this.xmlRolesReader.getEntitlement("Users", "create") : this.xmlRolesReader.getEntitlement("Users", "update");
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)allowedRoles);
        }
        this.fragment.add(new Component[]{form});
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        AjaxButton cancel = new AjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = 530608535790823587L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                UserModalPage.this.window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        return form;
    }

    protected AjaxButton getOnSubmit() {
        return new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    UserModalPage.this.submitAction(target, form);
                    if (UserModalPage.this.pageRef.getPage() instanceof BasePage) {
                        ((BasePage)UserModalPage.this.pageRef.getPage()).setModalResult(true);
                    }
                    UserModalPage.this.closeAction(target, form);
                }
                catch (Exception e) {
                    AbstractBasePage.LOG.error("While creating or updating user", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    UserModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                UserModalPage.this.feedbackPanel.refresh(target);
            }
        };
    }

    protected abstract void submitAction(AjaxRequestTarget var1, Form<?> var2);

    protected abstract void closeAction(AjaxRequestTarget var1, Form<?> var2);
}

