/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.SelectOnlyUserSearchResultPanel;
import org.apache.syncope.console.pages.panels.UserSearchPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class UserOwnerSelectModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 2106489458494696439L;

    public UserOwnerSelectModalPage(PageReference pageRef, ModalWindow window) {
        final SelectOnlyUserSearchResultPanel searchResult = new SelectOnlyUserSearchResultPanel("searchResult", true, null, pageRef, window, this.userRestClient);
        this.add(new Component[]{searchResult});
        Form searchForm = new Form("searchForm");
        this.add(new Component[]{searchForm});
        final UserSearchPanel searchPanel = new UserSearchPanel.Builder("searchPanel").build();
        searchForm.add(new Component[]{searchPanel});
        searchForm.add(new Component[]{new IndicatingAjaxButton("search", (IModel)new ResourceModel("search")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                String searchCond = searchPanel.buildFIQL();
                UserOwnerSelectModalPage.this.doSearch(target, searchCond, searchResult);
                Session.get().getFeedbackMessages().clear();
                searchPanel.getSearchFeedback().refresh(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                searchPanel.getSearchFeedback().refresh(target);
            }
        }});
    }

    private void doSearch(AjaxRequestTarget target, String fiql, AbstractSearchResultPanel resultsetPanel) {
        if (fiql == null) {
            this.error((Serializable)((Object)this.getString("search_error")));
            return;
        }
        resultsetPanel.search(fiql, target);
    }
}

