/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.mod.StatusMod;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.util.AttributableOperations;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.pages.UserModalPage;
import org.apache.syncope.console.rest.UserSelfRestClient;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class UserSelfModalPage
extends UserModalPage {
    private static final long serialVersionUID = 603212869211672852L;
    @SpringBean
    private UserSelfRestClient restClient;
    private final UserTO initialUserTO;

    public UserSelfModalPage(PageReference callerPageRef, ModalWindow window, UserTO userTO) {
        super(callerPageRef, window, userTO, Mode.SELF, userTO.getId() != 0L);
        this.initialUserTO = (UserTO)SerializationUtils.clone((Serializable)userTO);
        this.setupEditPanel();
    }

    @Override
    protected void submitAction(AjaxRequestTarget target, Form<?> form) {
        UserTO updatedUserTO = (UserTO)form.getModelObject();
        if (updatedUserTO.getId() == 0L) {
            this.restClient.create(updatedUserTO, (Boolean)this.storePassword.getModelObject());
        } else {
            UserMod userMod = AttributableOperations.diff((UserTO)updatedUserTO, (UserTO)this.initialUserTO);
            if (StringUtils.isNotBlank((CharSequence)userMod.getPassword())) {
                StatusMod pwdPropRequest = new StatusMod();
                pwdPropRequest.setOnSyncope(true);
                pwdPropRequest.getResourceNames().addAll(updatedUserTO.getResources());
                userMod.setPwdPropRequest(pwdPropRequest);
            }
            if (!userMod.isEmpty()) {
                this.restClient.update(userMod);
            }
        }
    }

    @Override
    protected void closeAction(AjaxRequestTarget target, Form<?> form) {
        this.setResponsePage((Page)new ResultStatusModalPage.Builder(this.window, (AbstractSubjectTO)this.userTO).mode(this.mode).build());
    }
}

