/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.EditUserModalPage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.UserSearchPanel;
import org.apache.syncope.console.pages.panels.UserSearchResultPanel;
import org.apache.syncope.console.rest.UserRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Users
extends BasePage {
    private static final long serialVersionUID = 134681165644474568L;
    private static final int EDIT_MODAL_WIN_HEIGHT = 550;
    private static final int EDIT_MODAL_WIN_WIDTH = 800;
    @SpringBean
    private UserRestClient restClient;

    public Users(PageParameters parameters) {
        super(parameters);
        final ModalWindow editModalWin = new ModalWindow("editModal");
        editModalWin.setCssClassName("w_silver");
        editModalWin.setInitialHeight(550);
        editModalWin.setInitialWidth(800);
        editModalWin.setCookieName("edit-modal");
        this.add(new Component[]{editModalWin});
        final UserSearchResultPanel searchResult = new UserSearchResultPanel("searchResult", true, null, this.getPageReference(), this.restClient);
        this.add(new Component[]{searchResult});
        UserSearchResultPanel listResult = new UserSearchResultPanel("listResult", false, null, this.getPageReference(), this.restClient);
        this.add(new Component[]{listResult});
        ClearIndicatingAjaxLink<Void> createLink = new ClearIndicatingAjaxLink<Void>("createLink", this.getPageReference()){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                editModalWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new EditUserModalPage(Users.this.getPageReference(), editModalWin, new UserTO());
                    }
                });
                editModalWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Users", "create"));
        this.add(new Component[]{createLink});
        this.setWindowClosedReloadCallback(editModalWin);
        Form searchForm = new Form("searchForm");
        this.add(new Component[]{searchForm});
        final UserSearchPanel searchPanel = new UserSearchPanel.Builder("searchPanel").build();
        searchForm.add(new Component[]{searchPanel});
        ClearIndicatingAjaxButton searchButton = new ClearIndicatingAjaxButton("search", (IModel)new ResourceModel("search"), this.getPageReference()){
            private static final long serialVersionUID = -958724007591692537L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                String fiql = searchPanel.buildFIQL();
                AbstractBasePage.LOG.debug("FIQL: " + fiql);
                Users.this.doSearch(target, fiql, searchResult);
                Session.get().getFeedbackMessages().clear();
                searchPanel.getSearchFeedback().refresh(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                searchPanel.getSearchFeedback().refresh(target);
            }
        };
        searchForm.add(new Component[]{searchButton});
        searchForm.setDefaultButton((IFormSubmittingComponent)searchButton);
    }

    private void doSearch(AjaxRequestTarget target, String fiql, AbstractSearchResultPanel resultsetPanel) {
        if (fiql == null) {
            this.error((Serializable)((Object)this.getString("search_error")));
            return;
        }
        resultsetPanel.search(fiql, target);
    }

    private void setWindowClosedReloadCallback(ModalWindow window) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                AbstractSearchResultPanel.EventDataWrapper data = new AbstractSearchResultPanel.EventDataWrapper();
                data.setTarget(target);
                data.setCreate(true);
                Users.this.send((IEventSink)Users.this.getPage(), Broadcast.BREADTH, data);
                if (Users.this.isModalResult()) {
                    Users.this.setModalResult(false);
                    Users.this.getSession().info((Serializable)((Object)Users.this.getString("operation_succeeded")));
                    Users.this.feedbackPanel.refresh(target);
                }
            }
        });
    }
}

